/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.migration;

public class Version {
    private int major;
    private int minor;
    private int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version create(String version) {
        String[] vs = version.split("\\.");
        switch (vs.length) {
            case 3: {
                return new Version(Integer.parseInt(vs[0]), Integer.parseInt(vs[1]), Integer.parseInt(vs[2]));
            }
            case 2: {
                return new Version(Integer.parseInt(vs[0]), Integer.parseInt(vs[1]), 0);
            }
            case 1: {
                return new Version(Integer.parseInt(vs[0]), 0, 0);
            }
        }
        throw new IllegalArgumentException(String.format("version[%s] format is error", version));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getVersion() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public String getNextVersion() {
        return this.major + 1 + "." + this.minor + "." + this.patch;
    }

    public String getNextMinorVersion() {
        return this.major + "." + (this.minor + 1) + "." + this.patch;
    }

    public String getNextPatchVersion() {
        return this.major + "." + this.minor + "." + (this.patch + 1);
    }
}

