/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.AbstractJdbcMappingFactory;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.mapping.ObjectDbMixedMappingFactory;
import cn.featherfly.common.db.mapping.ObjectToDbMappingFactory;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.ClassNameConversion;
import cn.featherfly.common.repository.mapping.PropertyNameConversion;
import java.util.List;

public class JdbcMappingFactoryImpl
implements JdbcMappingFactory {
    private AbstractJdbcMappingFactory factory;

    public JdbcMappingFactoryImpl(DatabaseMetadata metadata, Dialect dialect) {
        this(metadata, dialect, new SqlTypeMappingManager());
    }

    public JdbcMappingFactoryImpl(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(metadata, dialect, sqlTypeMappingManager, null, null);
    }

    public JdbcMappingFactoryImpl(DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(metadata, dialect, new SqlTypeMappingManager(), classNameConversions, propertyNameConversions);
    }

    public JdbcMappingFactoryImpl(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(MappingMode.OBJ_DB_MIXED, metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions);
    }

    public JdbcMappingFactoryImpl(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect) {
        this(mappingMode, metadata, dialect, new SqlTypeMappingManager());
    }

    public JdbcMappingFactoryImpl(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(mappingMode, metadata, dialect, sqlTypeMappingManager, null, null);
    }

    public JdbcMappingFactoryImpl(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(mappingMode, metadata, dialect, new SqlTypeMappingManager(), classNameConversions, propertyNameConversions);
    }

    public JdbcMappingFactoryImpl(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this.factory = mappingMode == MappingMode.OBJ_TO_DB ? new ObjectToDbMappingFactory(metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions) : new ObjectDbMixedMappingFactory(metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions);
    }

    public <T> ClassMapping<T> getClassMapping(Class<T> type) {
        return this.factory.getClassMapping(type);
    }

    @Override
    public Dialect getDialect() {
        return this.factory.getDialect();
    }

    @Override
    public DatabaseMetadata getMetadata() {
        return this.factory.getMetadata();
    }

    public static enum MappingMode {
        OBJ_DB_MIXED,
        OBJ_TO_DB;

    }
}

