/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.jpa.ColumnDefault;
import cn.featherfly.common.db.jpa.Comment;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.JdbcMappingFactory;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.SystemPropertyUtils;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.ClassNameConversion;
import cn.featherfly.common.repository.mapping.ClassNameJpaConversion;
import cn.featherfly.common.repository.mapping.ClassNameUnderlineConversion;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.repository.mapping.PropertyNameConversion;
import cn.featherfly.common.repository.mapping.PropertyNameJpaConversion;
import cn.featherfly.common.repository.mapping.PropertyNameUnderlineConversion;
import java.math.BigDecimal;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcMappingFactory
implements JdbcMappingFactory {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<Class<?>, ClassMapping<?>> mappedTypes = new HashMap();
    protected DatabaseMetadata metadata;
    protected Dialect dialect;
    protected List<ClassNameConversion> classNameConversions = new ArrayList<ClassNameConversion>();
    protected List<PropertyNameConversion> propertyNameConversions = new ArrayList<PropertyNameConversion>();
    protected SqlTypeMappingManager sqlTypeMappingManager;

    protected AbstractJdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect) {
        this(metadata, dialect, null);
    }

    protected AbstractJdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(metadata, dialect, sqlTypeMappingManager, null, null);
    }

    protected AbstractJdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(metadata, dialect, new SqlTypeMappingManager(), classNameConversions, propertyNameConversions);
    }

    protected AbstractJdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this.metadata = metadata;
        this.dialect = dialect;
        if (Lang.isEmpty(classNameConversions)) {
            this.classNameConversions.add((ClassNameConversion)new ClassNameJpaConversion());
            this.classNameConversions.add((ClassNameConversion)new ClassNameUnderlineConversion());
        } else {
            this.classNameConversions.addAll(classNameConversions);
        }
        if (Lang.isEmpty(propertyNameConversions)) {
            this.propertyNameConversions.add((PropertyNameConversion)new PropertyNameJpaConversion());
            this.propertyNameConversions.add((PropertyNameConversion)new PropertyNameUnderlineConversion());
        } else {
            this.propertyNameConversions.addAll(propertyNameConversions);
        }
        this.sqlTypeMappingManager = sqlTypeMappingManager == null ? new SqlTypeMappingManager() : sqlTypeMappingManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setColumnMapping(PropertyMapping mapping, BeanProperty<?> beanProperty) {
        Comment comment;
        ColumnDefault columnDefault;
        boolean isPk = beanProperty.hasAnnotation(Id.class);
        Column column = (Column)beanProperty.getAnnotation(Column.class);
        if (column != null) {
            mapping.setSize(ClassUtils.isParent(Number.class, (Class)beanProperty.getType()) ? column.precision() : column.length());
            mapping.setDecimalDigits(column.scale());
            mapping.setInsertable(column.insertable());
            mapping.setUpdatable(column.updatable());
            mapping.setUnique(column.unique());
            mapping.setNullable(column.nullable());
        } else if (beanProperty.getType() == String.class) {
            mapping.setSize(255);
        } else if (beanProperty.getType() == Double.class || beanProperty.getType() == Double.TYPE || beanProperty.getType() == Float.class || beanProperty.getType() == Float.TYPE || beanProperty.getType() == BigDecimal.class) {
            mapping.setSize(12);
            mapping.setDecimalDigits(2);
        }
        if (mapping.getSize() == 0) {
            SQLType sqlType = this.sqlTypeMappingManager.getSqlType(beanProperty.getType());
            mapping.setSize(this.dialect.getDefaultSize(sqlType));
        }
        if ((columnDefault = (ColumnDefault)beanProperty.getAnnotation(ColumnDefault.class)) != null) {
            mapping.setDefaultValue(columnDefault.value());
        }
        if ((comment = (Comment)beanProperty.getAnnotation(Comment.class)) != null) {
            mapping.setRemark(comment.value());
        }
        if (beanProperty.getType().isEnum() && !this.sqlTypeMappingManager.isEnumWithOrdinal()) {
            mapping.setSize(this.dialect.getDefaultSize(this.sqlTypeMappingManager.getEnumOrdinalType()));
        }
        if (!isPk) return;
        mapping.setNullable(false);
        GeneratedValue generatedValue = (GeneratedValue)beanProperty.getAnnotation(GeneratedValue.class);
        if (generatedValue != null) {
            if (generatedValue.strategy() != GenerationType.IDENTITY && generatedValue.strategy() != GenerationType.AUTO) throw new JdbcMappingException("\u53ea\u5b9e\u73b0\u4e86IDENTITY, AUTO\u65f6\u4f7f\u7528\u6570\u636e\u5e93\u7684\u81ea\u589e\u957f\u7684\u7b56\u7565");
            mapping.setAutoincrement(true);
            return;
        } else {
            mapping.setAutoincrement(true);
        }
    }

    protected boolean isTransient(BeanProperty<?> beanProperty, StringBuilder logInfo) {
        boolean result;
        boolean bl = result = beanProperty.hasAnnotation(java.beans.Transient.class) || beanProperty.hasAnnotation(Transient.class);
        if (result && this.logger.isDebugEnabled()) {
            logInfo.append(String.format("%s###\t%s is annotated with @Transient, ignore", SystemPropertyUtils.getLineSeparator(), beanProperty.getName()));
        }
        return result;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    public SqlTypeMappingManager getSqlTypeMappingManager() {
        return this.sqlTypeMappingManager;
    }

    public List<ClassNameConversion> getClassNameConversions() {
        return this.classNameConversions;
    }

    public void setClassNameConversions(List<ClassNameConversion> classNameConversions) {
        this.classNameConversions = classNameConversions;
    }

    public List<PropertyNameConversion> getPropertyNameConversions() {
        return this.propertyNameConversions;
    }

    public void setPropertyNameConversions(List<PropertyNameConversion> propertyNameConversions) {
        this.propertyNameConversions = propertyNameConversions;
    }

    @Override
    public DatabaseMetadata getMetadata() {
        return this.metadata;
    }
}

