/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml.basic;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlJoinOnBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectColumnsBasicBuilder;
import cn.featherfly.common.db.builder.dml.basic.SqlSelectJoinOnBasicBuilder;
import cn.featherfly.common.db.builder.model.SelectColumnElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.repository.operate.AggregateFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlSelectBasicBuilder
implements SqlBuilder {
    protected String tableAlias;
    protected String tableName;
    protected boolean buildWithFrom = true;
    protected List<SelectColumnElement> columns = new ArrayList<SelectColumnElement>(0);
    protected Dialect dialect;
    protected ClassMapping<?> classMapping;
    protected SqlSelectColumnsBasicBuilder defaultSelectColumnsBasicBuilder;
    protected List<SqlJoinOnBasicBuilder> sqlJoinOnBasicBuilders = new ArrayList<SqlJoinOnBasicBuilder>(0);
    protected List<SqlSelectColumnsBasicBuilder> joinSelectColumnsBasicBuilders = new ArrayList<SqlSelectColumnsBasicBuilder>(0);
    protected MappingFactory mappingFactory;

    public SqlSelectBasicBuilder(Dialect dialect, String tableName) {
        this(dialect, tableName, null);
    }

    public SqlSelectBasicBuilder(Dialect dialect, String tableName, String tableAlias) {
        this.dialect = dialect;
        this.tableAlias = tableAlias;
        this.tableName = tableName;
        this.defaultSelectColumnsBasicBuilder = new SqlSelectColumnsBasicBuilder(dialect, tableAlias);
    }

    public SqlSelectBasicBuilder(Dialect dialect, ClassMapping<?> classMapping, MappingFactory mappingFactory) {
        this(dialect, classMapping, null, mappingFactory);
    }

    public SqlSelectBasicBuilder(Dialect dialect, ClassMapping<?> classMapping, String tableAlias, MappingFactory mappingFactory) {
        this.dialect = dialect;
        this.classMapping = classMapping;
        this.tableName = classMapping.getRepositoryName();
        this.tableAlias = tableAlias;
        this.mappingFactory = mappingFactory;
        this.defaultSelectColumnsBasicBuilder = new SqlSelectColumnsBasicBuilder(dialect, classMapping, tableAlias, mappingFactory);
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
        this.defaultSelectColumnsBasicBuilder.setTableAlias(tableAlias);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isBuildWithFrom() {
        return this.buildWithFrom;
    }

    public void setBuildWithFrom(boolean buildWithFrom) {
        this.buildWithFrom = buildWithFrom;
    }

    public SqlSelectBasicBuilder addSelectColumn(String column, AggregateFunction aggregateFunction) {
        this.defaultSelectColumnsBasicBuilder.addSelectColumn(column, aggregateFunction);
        return this;
    }

    public SqlSelectBasicBuilder addSelectColumn(String column, AggregateFunction aggregateFunction, String asName) {
        this.defaultSelectColumnsBasicBuilder.addSelectColumn(column, aggregateFunction, asName);
        return this;
    }

    public SqlSelectBasicBuilder addSelectColumn(String column) {
        this.defaultSelectColumnsBasicBuilder.addSelectColumn(column);
        return this;
    }

    public SqlSelectBasicBuilder addSelectColumn(String column, String asName) {
        this.defaultSelectColumnsBasicBuilder.addSelectColumn(column, asName);
        return this;
    }

    public SqlSelectBasicBuilder addSelectColumns(String ... columns) {
        this.defaultSelectColumnsBasicBuilder.addSelectColumns(columns);
        return this;
    }

    public SqlSelectBasicBuilder addSelectColumns(Collection<String> columns) {
        this.defaultSelectColumnsBasicBuilder.addSelectColumns(columns);
        return this;
    }

    public SqlSelectBasicBuilder addSelectProperty(String propertyName, String aliasName) {
        this.defaultSelectColumnsBasicBuilder.addSelectProperty(propertyName, aliasName);
        return this;
    }

    public SqlSelectBasicBuilder addSelectProperties(Map<String, String> properties) {
        this.defaultSelectColumnsBasicBuilder.addSelectProperties(properties);
        return this;
    }

    public SqlSelectJoinOnBasicBuilder join(String conditionColumn, String joinTableName, String joinTableAlias, String joinTableColumnName) {
        return this.join(Join.INNER_JOIN, conditionColumn, joinTableName, joinTableAlias, joinTableColumnName);
    }

    public SqlSelectJoinOnBasicBuilder join(String conditionTableAlias, String conditionColumn, String joinTableName, String joinTableAlias, String joinTableColumnName) {
        return this.join(Join.INNER_JOIN, conditionTableAlias, conditionColumn, joinTableName, joinTableAlias, joinTableColumnName);
    }

    public SqlSelectJoinOnBasicBuilder join(Join join, String conditionColumn, String joinTableName, String joinTableAlias, String joinTableColumnName) {
        return this.join(join, this.tableAlias, conditionColumn, joinTableName, joinTableAlias, joinTableColumnName);
    }

    public SqlSelectJoinOnBasicBuilder join(Join join, String conditionTableAlias, String conditionColumn, String joinTableName, String joinTableAlias, String joinTableColumnName) {
        SqlJoinOnBasicBuilder joinOnBuilder = new SqlJoinOnBasicBuilder(this.dialect, join, joinTableName, joinTableAlias, joinTableColumnName, conditionTableAlias, conditionColumn);
        this.sqlJoinOnBasicBuilders.add(joinOnBuilder);
        SqlSelectColumnsBasicBuilder joinSelectColumnsBuilder = new SqlSelectColumnsBasicBuilder(this.dialect, joinTableAlias);
        return new SqlSelectJoinOnBasicBuilder(this, joinSelectColumnsBuilder);
    }

    public SqlSelectJoinOnBasicBuilder join(String conditionTableAlias, String conditionColumn, ClassMapping<?> classMapping, String tableAlias) {
        return this.join(Join.INNER_JOIN, conditionTableAlias, conditionColumn, classMapping, tableAlias);
    }

    public SqlSelectJoinOnBasicBuilder join(String conditionTableAlias, String conditionColumn, ClassMapping<?> classMapping, String tableAlias, String joinTableColumnName) {
        return this.join(Join.INNER_JOIN, conditionTableAlias, conditionColumn, classMapping, tableAlias, joinTableColumnName);
    }

    public SqlSelectJoinOnBasicBuilder join(Join join, String conditionTableAlias, String conditionColumn, ClassMapping<?> classMapping, String tableAlias) {
        return this.join(join, conditionTableAlias, conditionColumn, classMapping, tableAlias, ((PropertyMapping)classMapping.getPrivaryKeyPropertyMappings().get(0)).getRepositoryFieldName());
    }

    public SqlSelectJoinOnBasicBuilder join(Join join, String conditionTableAlias, String conditionColumn, ClassMapping<?> classMapping, String tableAlias, String joinTableColumnName) {
        SqlJoinOnBasicBuilder joinOnBuilder = new SqlJoinOnBasicBuilder(this.dialect, join, classMapping.getRepositoryName(), tableAlias, joinTableColumnName, conditionTableAlias, conditionColumn);
        this.sqlJoinOnBasicBuilders.add(joinOnBuilder);
        SqlSelectColumnsBasicBuilder joinSelectColumnsBuilder = new SqlSelectColumnsBasicBuilder(this.dialect, classMapping, tableAlias, this.mappingFactory);
        return new SqlSelectJoinOnBasicBuilder(this, joinSelectColumnsBuilder);
    }

    void addJoinSelectColumnsBasicBuilder(SqlSelectColumnsBasicBuilder joinSelectColumnsBuilder) {
        this.joinSelectColumnsBasicBuilders.add(joinSelectColumnsBuilder);
    }

    public String build() {
        StringBuilder select = new StringBuilder();
        Dialect.Keyworld keyworld = this.dialect.getKeywords();
        select.append(keyworld.select());
        select.append(" ").append(this.defaultSelectColumnsBasicBuilder.build());
        for (SqlSelectColumnsBasicBuilder joinColumnsBuilder : this.joinSelectColumnsBasicBuilders) {
            select.append(",").append(" ").append(joinColumnsBuilder.build());
        }
        if (this.buildWithFrom) {
            AssertIllegalArgument.isNotEmpty((String)this.tableName, (String)"buildWithFrom=true\u65f6\uff0ctableName\u4e0d\u80fd\u4e3a\u7a7a");
            select.append(" ").append(keyworld.from()).append(" ").append(this.dialect.buildTableSql(this.tableName, this.tableAlias));
            this.sqlJoinOnBasicBuilders.forEach(builder -> select.append(" ").append(builder.build()));
        }
        return select.toString();
    }
}

