/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml;

import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.dml.SelectBuilder;
import cn.featherfly.common.db.builder.dml.SqlConditionBuilder;
import cn.featherfly.common.db.builder.dml.SqlConditionGroup;
import cn.featherfly.common.db.builder.dml.SqlFindBuilder;
import cn.featherfly.common.db.builder.dml.SqlSelectBuilder;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.builder.dml.FindBuilder;
import cn.featherfly.common.repository.builder.dml.QueryBuilder;
import cn.featherfly.common.repository.operate.AggregateFunction;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlQueryBuilder
implements SelectBuilder,
QueryBuilder {
    private SqlConditionGroup conditionGroup;
    private SqlSortBuilder sortBuilder;
    private SqlFindBuilder findBuilder;
    private SqlSelectBuilder selectBuilder;
    private Dialect dialect;

    public SqlQueryBuilder(Dialect dialect) {
        this.dialect = dialect;
        this.sortBuilder = new SqlSortBuilder(dialect);
        this.conditionGroup = new SqlConditionGroup(dialect, this.sortBuilder);
    }

    public String build() {
        StringBuilder result = new StringBuilder();
        if (this.findBuilder != null) {
            result.append(this.findBuilder.build());
        } else if (this.selectBuilder != null) {
            result.append(this.selectBuilder.build());
        }
        String condition = this.conditionGroup.build();
        if (Strings.isNotBlank((String)condition)) {
            BuilderUtils.link(result, "WHERE");
            BuilderUtils.link(result, condition);
        }
        BuilderUtils.link(result, this.sortBuilder.build());
        return result.toString().trim();
    }

    public List<Object> getParams() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object param = this.conditionGroup.getParamValue();
        if (param == null) {
            result.add(param);
        } else if (param instanceof Collection) {
            result.addAll((Collection)param);
        } else if (param.getClass().isArray()) {
            int length = Array.getLength(param);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(param, i));
            }
        }
        return result;
    }

    public FindBuilder find(String target) {
        return this.find(target, null);
    }

    public FindBuilder find(String target, String alias) {
        this.conditionGroup.setQueryAlias(alias);
        this.sortBuilder.setTableAlias(alias);
        this.findBuilder = new SqlFindBuilder(this.dialect, target, alias, this.conditionGroup);
        return this.findBuilder;
    }

    @Override
    public SelectBuilder select(String columnName, AggregateFunction aggregateFunction) {
        return this.selectBuilder().select(columnName, aggregateFunction);
    }

    @Override
    public SelectBuilder select(String columnName) {
        return this.selectBuilder().select(columnName);
    }

    @Override
    public SelectBuilder select(String columnName, String asName) {
        return this.selectBuilder().select(columnName, asName);
    }

    @Override
    public SelectBuilder select(String columnName, AggregateFunction aggregateFunction, String asName) {
        return this.selectBuilder().select(columnName, aggregateFunction, asName);
    }

    @Override
    public SelectBuilder select(Map<String, String> columnNames) {
        return this.selectBuilder().select(columnNames);
    }

    @Override
    public SelectBuilder select(String[] columnNames) {
        return this.selectBuilder().select(columnNames);
    }

    @Override
    public SelectBuilder select(Collection<String> columnNames) {
        return this.selectBuilder().select(columnNames);
    }

    @Override
    public SqlConditionBuilder from(String tableName) {
        return this.from(tableName, null);
    }

    @Override
    public SqlConditionBuilder from(String tableName, String alias) {
        this.conditionGroup.setQueryAlias(alias);
        this.sortBuilder.setTableAlias(alias);
        return this.selectBuilder().from(tableName, alias);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    private SqlSelectBuilder selectBuilder() {
        if (this.selectBuilder == null) {
            this.selectBuilder = new SqlSelectBuilder(this.dialect, this.conditionGroup);
        }
        return this.selectBuilder;
    }
}

