/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.migration;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.SqlExecutor;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.db.migration.Diff;
import cn.featherfly.common.db.migration.ModifyTable;
import cn.featherfly.common.db.migration.TableMapping;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Index;
import cn.featherfly.common.repository.mapping.ClassMapping;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrator.class);
    private Dialect dialect;
    private SqlExecutor sqlExecutor;
    private SqlTypeMappingManager sqlTypeMappingManager;

    public Migrator(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(dataSource, dialect, sqlTypeMappingManager, true);
    }

    public Migrator(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, boolean generateSchema) {
        this(dataSource, dialect, sqlTypeMappingManager, generateSchema, dialect.getDefaultSchema(JdbcUtils.getCatalog(dataSource)));
    }

    public Migrator(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, boolean generateSchema, String schema) {
        this.dialect = dialect;
        this.sqlTypeMappingManager = sqlTypeMappingManager;
        this.sqlExecutor = new SqlExecutor(dataSource);
        if (generateSchema) {
            // empty if block
        }
    }

    public String initSql(Set<ClassMapping<?>> classMappings) {
        StringBuilder sql = new StringBuilder();
        this.appendSqlWithEnd(sql, this.dialect.getInitSqlHeader());
        for (ClassMapping<?> classMapping : classMappings) {
            this.appendSqlWithEnd(sql, this.createSql(classMapping, true));
        }
        this.appendSqlWithEnd(sql, this.dialect.getInitSqlFooter());
        String result = sql.toString();
        LOGGER.debug("create init sql -> \n{}", (Object)result);
        return result;
    }

    public String createSql(ClassMapping<?> classMapping) {
        return this.createSql(classMapping, false);
    }

    public String createSql(ClassMapping<?> classMapping, boolean dropIfExists) {
        return this.createSql(ClassMappingUtils.createTable(classMapping, this.dialect, this.sqlTypeMappingManager), dropIfExists, classMapping.getType());
    }

    private String createSql(TableMapping tableMapping, boolean dropIfExists) {
        return this.createSql(tableMapping.table, dropIfExists, tableMapping.classMapping == null ? null : tableMapping.classMapping.getType());
    }

    private String createSql(Table table, boolean dropIfExists, Class<?> type) {
        StringBuilder sql = new StringBuilder();
        if (dropIfExists) {
            this.appendSqlWithEnd(sql, this.dialect.buildDropTableDDL(table.getSchema(), table.getName(), true));
        }
        String result = sql.append(this.dialect.buildCreateTableDDL(table)).toString();
        if (type == null) {
            LOGGER.debug("create sql for table {} -> \n{}", (Object)table.getName(), (Object)result);
        } else {
            LOGGER.debug("create sql for entity {} -> \n{}", (Object)type.getName(), (Object)result);
        }
        return result;
    }

    public void create(Set<ClassMapping<?>> classMappings) {
        this.sqlExecutor.execute(this.initSql(classMappings));
    }

    public String updateSql(DataSource previousDataSource, DataSource currentDataSource) {
        return this.updateSql(previousDataSource, currentDataSource, ModifyType.MODIFY);
    }

    public String updateSql(DataSource previousDataSource, DataSource currentDataSource, ModifyType modifyType) {
        return this.updateSql(previousDataSource, currentDataSource, modifyType, true);
    }

    public String updateSql(DataSource previousDataSource, ModifyType tableModifyType, boolean dropNotExistTable, ModifyType columnModifyType, boolean dropNotExistColumn, boolean dropNotExistIndex) {
        return this.updateSql(previousDataSource, this.sqlExecutor.getDataSource(), tableModifyType, dropNotExistTable, columnModifyType, dropNotExistColumn, dropNotExistIndex);
    }

    public String updateSql(DataSource previousDataSource, DataSource currentDataSource, ModifyType modifyType, boolean dropNotExist) {
        return this.updateSql(previousDataSource, currentDataSource, modifyType, dropNotExist, modifyType, dropNotExist, dropNotExist);
    }

    public String updateSql(DataSource previousDataSource, DataSource currentDataSource, ModifyType tableModifyType, boolean dropNotExistTable, ModifyType columnModifyType, boolean dropNotExistColumn, boolean dropNotExistIndex) {
        DatabaseMetadata previousMetadata = DatabaseMetadataManager.getDefaultManager().reCreate(previousDataSource);
        DatabaseMetadata currentMetadata = DatabaseMetadataManager.getDefaultManager().reCreate(currentDataSource);
        return this.updateSql(previousMetadata, currentMetadata, tableModifyType, dropNotExistTable, columnModifyType, dropNotExistColumn, dropNotExistIndex);
    }

    public String updateSql(DatabaseMetadata previousMetadata, DatabaseMetadata currentMetadata, ModifyType tableModifyType, boolean dropNotExistTable, ModifyType columnModifyType, boolean dropNotExistColumn, boolean dropNotExistIndex) {
        Diff diff = new Diff();
        HashSet<String> tableNameSet = new HashSet<String>();
        for (Table current : currentMetadata.getTables()) {
            Table previous = previousMetadata.getTable(current.getName());
            tableNameSet.add(this.diff(previous, current, null, diff));
        }
        for (Table previous : previousMetadata.getTables()) {
            if (tableNameSet.contains(previous.getName())) continue;
            diff.notExistTables.add(previous);
        }
        return this.diffSql(diff, tableModifyType, dropNotExistTable, columnModifyType, dropNotExistColumn, dropNotExistIndex);
    }

    public String updateSql(Set<ClassMapping<?>> classMappings) {
        return this.updateSql(classMappings, ModifyType.MODIFY, true);
    }

    public String updateSql(Set<ClassMapping<?>> classMappings, ModifyType modifyType, boolean dropNoMapping) {
        return this.updateSql(classMappings, modifyType, dropNoMapping, modifyType, dropNoMapping, dropNoMapping);
    }

    public String updateSql(Set<ClassMapping<?>> classMappings, ModifyType tableModifyType, boolean dropNoMappingTable, ModifyType columnModifyType, boolean dropNoMappingColumn, boolean dropNoMappingIndex) {
        return this.updateSql(classMappings, tableModifyType, dropNoMappingTable, columnModifyType, dropNoMappingColumn, dropNoMappingIndex, DatabaseMetadataManager.getDefaultManager().reCreate(this.sqlExecutor.getDataSource()));
    }

    public String updateSql(Set<ClassMapping<?>> classMappings, ModifyType tableModifyType, boolean dropNoMappingTable, ModifyType columnModifyType, boolean dropNoMappingColumn, boolean dropNoMappingIndex, DatabaseMetadata databaseMetadata) {
        Diff diff = new Diff();
        HashSet<String> tableNameSet = new HashSet<String>();
        for (ClassMapping<?> classMapping : classMappings) {
            Table tableMetadata = databaseMetadata.getTable(classMapping.getRepositoryName());
            Table table = ClassMappingUtils.createTable(classMapping, this.dialect, this.sqlTypeMappingManager);
            tableNameSet.add(this.diff(tableMetadata, table, classMapping, diff));
        }
        for (Table tableMetadata : databaseMetadata.getTables()) {
            if (tableNameSet.contains(tableMetadata.getName())) continue;
            diff.notExistTables.add(tableMetadata);
        }
        return this.diffSql(diff, tableModifyType, dropNoMappingTable, columnModifyType, dropNoMappingColumn, dropNoMappingIndex);
    }

    public void update(Set<ClassMapping<?>> classMappings) {
        this.sqlExecutor.execute(this.updateSql(classMappings));
    }

    public void update(Set<ClassMapping<?>> classMappings, ModifyType tableModifyType, boolean dropTableNotMapping, ModifyType columnModifyType, boolean dropColumnNotMapping, boolean dropIndexNotMapping) {
        this.sqlExecutor.execute(this.updateSql(classMappings, tableModifyType, dropTableNotMapping, columnModifyType, dropColumnNotMapping, dropIndexNotMapping));
    }

    private String diff(Table previous, Table current, ClassMapping<?> classMapping, Diff diff) {
        if (previous == null) {
            diff.newTables.add(new TableMapping(current, classMapping));
        } else if (!previous.equals(current)) {
            ModifyTable modifyTable = diff.modifyTables.getModifyTable(current);
            if (modifyTable == null) {
                modifyTable = new ModifyTable(current, classMapping);
                diff.modifyTables.put(modifyTable);
            }
            for (Column column : current.getColumns()) {
                Column columnMetadata = previous.getColumn(column.getName());
                if (columnMetadata == null) {
                    modifyTable.newColumns.put(classMapping.getPropertyMappingByPersitField(column.getName()), column);
                    continue;
                }
                if (columnMetadata.equals(column)) continue;
                modifyTable.modifyColumns.put(classMapping.getPropertyMappingByPersitField(column.getName()), column);
            }
            for (Column columnMetadata : previous.getColumns()) {
                if (current.getColumn(columnMetadata.getName()) != null) continue;
                modifyTable.noMappingColumns.add(columnMetadata);
            }
            for (Index index : current.getIndexs()) {
                Index indexMetadata = previous.getIndex(index.getName());
                if (indexMetadata == null) {
                    modifyTable.addIndexs.add(index);
                    continue;
                }
                if (indexMetadata.equals((Object)index)) continue;
                modifyTable.dropIndexs.add(indexMetadata);
                modifyTable.addIndexs.add(index);
            }
            for (Index indexMetadata : previous.getIndexs()) {
                if (current.hasIndex(indexMetadata.getName())) continue;
                modifyTable.notExistIndexs.add(indexMetadata);
            }
        }
        return current.getName();
    }

    private String diffSql(Diff diff, ModifyType tableModifyType, boolean dropNotExistTable, ModifyType columnModifyType, boolean dropNotExistColumn, boolean dropNotExistIndex) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.dialect.getInitSqlHeader()).append(";").append("\n");
        diff.newTables.forEach(tableMapping -> this.appendSqlWithEnd(sql, this.createSql((TableMapping)tableMapping, true)));
        for (Map.Entry<Table, ModifyTable> entry : diff.modifyTables.modifyTableMap.entrySet()) {
            Table table2 = entry.getKey();
            ModifyTable modifyTable = entry.getValue();
            if (ModifyType.MODIFY == tableModifyType) {
                ArrayList<Column> dropColumns = new ArrayList<Column>();
                ArrayList<Index> dropIndex = new ArrayList<Index>();
                if (dropNotExistColumn) {
                    dropColumns.addAll(modifyTable.noMappingColumns);
                }
                dropIndex.addAll(modifyTable.dropIndexs);
                if (dropNotExistIndex) {
                    dropIndex.addAll(modifyTable.notExistIndexs);
                }
                for (Index index : dropIndex) {
                    this.appendSqlWithEnd(sql, this.dialect.buildDropIndexDDL(table2.getSchema(), table2.getName(), index.getName()));
                }
                if (ModifyType.MODIFY == columnModifyType) {
                    this.appendSqlWithEnd(sql, this.dialect.buildAlterTableDDL(table2.getSchema(), table2.getName(), (Column[])CollectionUtils.toArray(modifyTable.newColumns.values(), Column.class), (Column[])CollectionUtils.toArray(modifyTable.modifyColumns.values(), Column.class), (Column[])CollectionUtils.toArray(dropColumns, Column.class)));
                } else if (ModifyType.DROP_AND_CREATE == columnModifyType) {
                    dropColumns.addAll(modifyTable.modifyColumns.values());
                    this.appendSqlWithEnd(sql, this.dialect.buildAlterTableDropColumnDDL(table2.getSchema(), table2.getName(), (Column[])CollectionUtils.toArray(dropColumns, Column.class)));
                    ArrayList<Column> addColumns = new ArrayList<Column>();
                    addColumns.addAll(modifyTable.newColumns.values());
                    addColumns.addAll(modifyTable.modifyColumns.values());
                    this.appendSqlWithEnd(sql, this.dialect.buildAlterTableDDL(table2.getSchema(), table2.getName(), (Column[])CollectionUtils.toArray(addColumns, Column.class), new Column[0], (Column[])CollectionUtils.toArray(dropColumns, Column.class)));
                } else {
                    throw new JdbcMappingException("no support ModifyType for columnModifyType -> " + (Object)((Object)columnModifyType));
                }
                for (Index index : modifyTable.addIndexs) {
                    this.appendSqlWithEnd(sql, this.dialect.buildCreateIndexDDL(table2.getSchema(), table2.getName(), index.getName(), index.getColumns()));
                }
                continue;
            }
            if (ModifyType.DROP_AND_CREATE == tableModifyType) {
                this.appendSqlWithEnd(sql, this.createSql(modifyTable.classMapping, true));
                continue;
            }
            throw new JdbcMappingException("no support ModifyType for tableModifyType -> " + (Object)((Object)tableModifyType));
        }
        if (dropNotExistTable) {
            diff.notExistTables.forEach(table -> this.appendSqlWithEnd(sql, this.dialect.buildDropTableDDL(table.getSchema(), table.getName())));
        }
        sql.append(this.dialect.getInitSqlFooter()).append(";").append("\n");
        String result = sql.toString();
        LOGGER.debug("create update sql -> \n{}", (Object)result);
        return result;
    }

    private StringBuilder appendSqlWithEnd(StringBuilder sql, String appendSql) {
        if (Lang.isNotEmpty((String)appendSql)) {
            sql.append(appendSql);
            if (!appendSql.endsWith(";")) {
                sql.append(";");
            }
            return sql.append("\n");
        }
        return sql;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public SqlTypeMappingManager getSqlTypeMappingManager() {
        return this.sqlTypeMappingManager;
    }

    public static enum ModifyType {
        MODIFY,
        DROP_AND_CREATE;

    }
}

