/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping.mappers;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.AbstractJavaSqlTypeMapper;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import org.apache.commons.lang3.StringUtils;

public class ObjectToJsonMapper<E extends Serializable>
extends AbstractJavaSqlTypeMapper<E> {
    private ObjectMapper objectMapper;
    private boolean storeAsString = true;

    public ObjectToJsonMapper(Class<E> type) {
        this((GenericType<E>)new GenericClass(type));
    }

    public ObjectToJsonMapper(Class<E> type, ObjectMapper objectMapper) {
        this(type, objectMapper, true);
    }

    public ObjectToJsonMapper(Class<E> type, ObjectMapper objectMapper, boolean storeAsString) {
        this((GenericType<E>)new GenericClass(type), objectMapper, storeAsString);
    }

    public ObjectToJsonMapper(GenericType<E> type) {
        this(type, new ObjectMapper());
    }

    public ObjectToJsonMapper(GenericType<E> type, ObjectMapper objectMapper) {
        this(type, objectMapper, true);
    }

    public ObjectToJsonMapper(GenericType<E> genericType, ObjectMapper objectMapper, boolean storeAsString) {
        super(genericType);
        this.objectMapper = objectMapper;
        this.storeAsString = storeAsString;
    }

    @Override
    protected boolean support(SQLType sqlType) {
        if (this.storeAsString) {
            return sqlType == JDBCType.VARCHAR || sqlType == JDBCType.NVARCHAR || sqlType == JDBCType.LONGVARCHAR || sqlType == JDBCType.LONGNVARCHAR || sqlType == JDBCType.CLOB || sqlType == JDBCType.NCLOB || sqlType == JDBCType.JAVA_OBJECT;
        }
        return sqlType == JDBCType.BLOB;
    }

    @Override
    public Class<E> getJavaType(SQLType sqlType) {
        return this.getGenericType().getType();
    }

    @Override
    public SQLType getSqlType(GenericType<E> javaType) {
        if (this.storeAsString) {
            return JDBCType.LONGNVARCHAR;
        }
        return JDBCType.BLOB;
    }

    @Override
    public void set(PreparedStatement prep, int columnIndex, E value) {
        try {
            if (value == null) {
                prep.setObject(columnIndex, null);
            }
            if (this.storeAsString) {
                String json = this.objectMapper.writerFor(this.getGenericType().getType()).writeValueAsString(value);
                prep.setString(columnIndex, json);
            } else {
                ByteArrayInputStream is = new ByteArrayInputStream(this.objectMapper.writerFor(this.getGenericType().getType()).writeValueAsBytes(value));
                prep.setBlob(columnIndex, is);
            }
        }
        catch (JsonProcessingException | SQLException e) {
            throw new JdbcException(e);
        }
    }

    @Override
    public E get(ResultSet rs, int columnIndex) {
        try {
            if (this.storeAsString) {
                String json = rs.getString(columnIndex);
                if (StringUtils.isBlank((CharSequence)json)) {
                    return null;
                }
                return (E)((Serializable)this.objectMapper.readerFor(this.getGenericType().getType()).readValue(json));
            }
            Blob blob = rs.getBlob(columnIndex);
            if (blob == null) {
                return null;
            }
            return (E)((Serializable)this.objectMapper.readerFor(this.getGenericType().getType()).readValue(blob.getBinaryStream()));
        }
        catch (IOException | SQLException e) {
            throw new JdbcException(e);
        }
    }
}

