/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.DefaultSqlTypeMapping;
import cn.featherfly.common.db.mapping.JavaSqlTypeMapper;
import cn.featherfly.common.db.mapping.JavaToSqlTypeRegister;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeToJavaRegister;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuples;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTypeMappingManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DefaultSqlTypeMapping defaultSqlTypeMapping = new DefaultSqlTypeMapping();
    private Store globalStore = new Store();
    private Map<GenericType<?>, Store> typeStoreMap = new HashMap();

    public boolean isEnumWithOrdinal() {
        return this.defaultSqlTypeMapping.isEnumWithOrdinal();
    }

    public void setEnumWithOrdinal(boolean enumWithOrdinal) {
        this.defaultSqlTypeMapping.setEnumWithOrdinal(enumWithOrdinal);
    }

    public void setEnumOrdinalType(SQLType enumOrdinalType) {
        this.defaultSqlTypeMapping.setEnumOrdinalType(enumOrdinalType);
    }

    public SQLType getEnumOrdinalType() {
        return this.defaultSqlTypeMapping.getEnumOrdinalType();
    }

    public SqlTypeMappingManager regist(JavaToSqlTypeRegister<? extends Object> register) {
        AssertIllegalArgument.isNotNull(register, (String)"register");
        this.globalStore.put(register);
        return this;
    }

    public SqlTypeMappingManager regist(JavaSqlTypeMapper<? extends Object> mapper) {
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        this.globalStore.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(GenericType<?> entityType, JavaSqlTypeMapper<? extends Object> mapper) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        Store store = this.getStoreForRegist(entityType);
        store.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(SqlTypeToJavaRegister<? extends Object> register) {
        AssertIllegalArgument.isNotNull(register, (String)"register");
        this.globalStore.put(register);
        return this;
    }

    public <E> SQLType getSqlType(Class<E> javaType) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        SQLType sqlType = this.globalStore.getSqlType(javaType);
        if (sqlType == null) {
            sqlType = this.defaultSqlTypeMapping.getSqlType(javaType);
        }
        return sqlType;
    }

    public <E> SQLType getSqlType(Class<E> entityType, Class<E> javaType) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        SQLType sqlType = null;
        Store store = this.typeStoreMap.get(new GenericClass(entityType));
        if (store != null) {
            sqlType = store.getSqlType(javaType);
        }
        if (sqlType == null) {
            sqlType = this.getSqlType(javaType);
        }
        return sqlType;
    }

    public <E> Class<E> getJavaType(SQLType sqlType) {
        AssertIllegalArgument.isNotNull((Object)sqlType, (String)"sqlType");
        Class javaType = this.globalStore.getJavaType(sqlType);
        if (javaType == null) {
            javaType = this.defaultSqlTypeMapping.getJavaType(sqlType);
        }
        return javaType;
    }

    public <E> Class<E> getJavaType(Class<E> entityType, SQLType sqlType) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull((Object)sqlType, (String)"sqlType");
        Class<E> javaType = null;
        Store store = this.typeStoreMap.get(new GenericClass(entityType));
        if (store != null) {
            javaType = store.getJavaType(sqlType);
        }
        if (javaType == null) {
            javaType = this.getJavaType(sqlType);
        }
        return javaType;
    }

    public <E> void set(PreparedStatement prep, int columnIndex, E columnValue) {
        GenericClass gt;
        Store store;
        AssertIllegalArgument.isNotNull((Object)prep, (String)"PreparedStatement");
        if (columnValue != null && (store = this.typeStoreMap.get(gt = new GenericClass(columnValue.getClass()))) != null && store.set(prep, columnIndex, columnValue)) {
            return;
        }
        if (this.globalStore.set(prep, columnIndex, columnValue)) {
            return;
        }
        JdbcUtils.setParameter(prep, columnIndex, columnValue);
    }

    public <E> void set(PreparedStatement prep, int columnIndex, E columnValue, GenericType<E> javaType) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        AssertIllegalArgument.isNotNull((Object)prep, (String)"PreparedStatement");
        Store store = this.getStore(javaType);
        if (store != null && store.set(prep, columnIndex, columnValue, javaType)) {
            return;
        }
        if (this.globalStore.set(prep, columnIndex, columnValue, javaType)) {
            return;
        }
        JdbcUtils.setParameter(prep, columnIndex, columnValue);
    }

    public <E> E get(ResultSet rs, int columnIndex, GenericType<E> javaType) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        AssertIllegalArgument.isNotNull((Object)rs, (String)"ResultSet");
        Store store = this.getStore(javaType);
        E e = null;
        if (store != null) {
            E e2 = store.get(rs, columnIndex, javaType);
            e = e2;
            if (e2 != null) {
                return e;
            }
        }
        E e3 = this.globalStore.get(rs, columnIndex, javaType);
        e = e3;
        if (e3 != null) {
            return e;
        }
        return (E)JdbcUtils.getResultSetValue(rs, columnIndex, javaType.getType());
    }

    public <E> E get(ResultSet rs, String columnName, GenericType<E> javaType) {
        AssertIllegalArgument.isNotEmpty((String)columnName, (String)"name");
        int index = JdbcUtils.getColumnIndex(rs, columnName);
        return this.get(rs, index, javaType);
    }

    private <E> Store getStoreForRegist(GenericType<E> entityType) {
        Store store = this.typeStoreMap.get(entityType);
        if (store == null) {
            store = new Store();
            this.typeStoreMap.put(entityType, store);
        }
        return store;
    }

    private <E> Store getStore(GenericType<E> javaType) {
        return this.typeStoreMap.get(javaType);
    }

    private class Store {
        private Map<GenericType<? extends Object>, JavaToSqlTypeRegister<? extends Object>> javaToSqlTypeRegisterMap = new HashMap<GenericType<? extends Object>, JavaToSqlTypeRegister<? extends Object>>();
        private Map<SQLType, Tuple2<SqlTypeToJavaRegister<? extends Object>, Class<? extends Object>>> sqlTypeToJavaRegisterMap = new HashMap<SQLType, Tuple2<SqlTypeToJavaRegister<? extends Object>, Class<? extends Object>>>();
        private List<JavaSqlTypeMapper<? extends Object>> javaSqlTypeMappers = new ArrayList<JavaSqlTypeMapper<? extends Object>>();

        private Store() {
        }

        private void add(JavaSqlTypeMapper<? extends Object> mapper) {
            this.javaSqlTypeMappers.add(mapper);
        }

        private void put(JavaToSqlTypeRegister<? extends Object> register) {
            GenericClass type = new GenericClass(register.getJavaType());
            JavaToSqlTypeRegister<? extends Object> oldRegister = null;
            oldRegister = this.javaToSqlTypeRegisterMap.get(type);
            if (oldRegister != null) {
                throw new JdbcMappingException("#java.type.registed", new Object[]{type.getType().getName(), oldRegister.getClass().getName(), oldRegister.getSqlType().getName(), register.getClass().getName()});
            }
            this.javaToSqlTypeRegisterMap.put((GenericType<? extends Object>)type, register);
            SqlTypeMappingManager.this.logger.debug("regist java type {} with sql type {}", (Object)type.getType().getName(), (Object)register.getSqlType().getName());
        }

        private void put(SqlTypeToJavaRegister<? extends Object> register) {
            Class type = register.getJavaType();
            Tuple2<SqlTypeToJavaRegister<? extends Object>, Class<? extends Object>> oldRegister = null;
            oldRegister = this.sqlTypeToJavaRegisterMap.get(register.getSqlType());
            if (oldRegister != null) {
                throw new JdbcMappingException("#sql.type.registed", new Object[]{((SqlTypeToJavaRegister)oldRegister.get0()).getSqlType().getName(), ((SqlTypeToJavaRegister)oldRegister.get0()).getClass().getName(), ((Class)oldRegister.get1()).getName(), register.getClass().getName()});
            }
            this.sqlTypeToJavaRegisterMap.put(register.getSqlType(), (Tuple2<SqlTypeToJavaRegister<? extends Object>, Class<? extends Object>>)Tuples.of(register, type));
            SqlTypeMappingManager.this.logger.debug("regist java type {} with sql type {}", (Object)type.getName(), (Object)register.getSqlType().getName());
        }

        private <E> SQLType getSqlType(Class<E> javaType) {
            return this.getSqlType((GenericType<E>)new GenericClass(javaType));
        }

        private <E> SQLType getSqlType(GenericType<E> javaType) {
            for (JavaSqlTypeMapper<? extends Object> javaSqlTypeMapper : this.javaSqlTypeMappers) {
                SQLType sqlType;
                JavaSqlTypeMapper<? extends Object> mapper = javaSqlTypeMapper;
                if (!mapper.support(javaType) || (sqlType = javaSqlTypeMapper.getSqlType(javaType)) == null) continue;
                return sqlType;
            }
            JavaToSqlTypeRegister<? extends Object> register = this.javaToSqlTypeRegisterMap.get(javaType);
            if (register != null) {
                return register.getSqlType();
            }
            return null;
        }

        public <E> boolean set(PreparedStatement prep, int columnIndex, E columnValue) {
            if (columnValue == null) {
                JdbcUtils.setParameter(prep, columnIndex, columnValue);
                return true;
            }
            return this.set(prep, columnIndex, columnValue, (GenericType<E>)new GenericClass(columnValue.getClass()));
        }

        public <E> boolean set(PreparedStatement prep, int columnIndex, E columnValue, GenericType<E> javaType) {
            if (columnValue == null) {
                JdbcUtils.setParameter(prep, columnIndex, columnValue);
                return true;
            }
            for (JavaSqlTypeMapper<? extends Object> javaSqlTypeMapper : this.javaSqlTypeMappers) {
                SQLType sqlType;
                if (!javaSqlTypeMapper.support(javaType) || (sqlType = javaSqlTypeMapper.getSqlType(javaType)) == null) continue;
                SqlTypeMappingManager.this.logger.debug("set value javatype {}[{}]  to sqltype {} with mapper {}", new Object[]{javaType.getClass().getSimpleName(), javaType.getType().getName(), sqlType.toString(), javaSqlTypeMapper.getClass().getName()});
                javaSqlTypeMapper.set(prep, columnIndex, columnValue);
                return true;
            }
            return false;
        }

        public <E> E get(ResultSet rs, int columnIndex, GenericType<E> javaType) {
            SQLType sqlType = JdbcUtils.getResultSQLType(rs, columnIndex);
            for (JavaSqlTypeMapper<? extends Object> sqlTypeToJavaMapper : this.javaSqlTypeMappers) {
                String columnName;
                String tableName;
                JavaSqlTypeMapper<? extends Object> mapper = sqlTypeToJavaMapper;
                if (!mapper.support(sqlType, tableName = JdbcUtils.getTableName(rs, columnIndex), columnName = JdbcUtils.getColumnName(rs, columnIndex)) || !mapper.support(javaType)) continue;
                SqlTypeMappingManager.this.logger.debug("get value from {}.{} [{}] with mapper {}", new Object[]{tableName, columnName, sqlType.toString(), mapper.getClass().getName()});
                return (E)mapper.get(rs, columnIndex);
            }
            return null;
        }

        private <E> Class<E> getJavaType(SQLType sqlType) {
            for (JavaSqlTypeMapper<? extends Object> sqlTypeToJavaMapper : this.javaSqlTypeMappers) {
                Class<? extends Object> type;
                if (!sqlTypeToJavaMapper.support(sqlType, null, null) || (type = sqlTypeToJavaMapper.getJavaType(sqlType)) == null) continue;
                return type;
            }
            Tuple2<SqlTypeToJavaRegister<? extends Object>, Class<? extends Object>> tuple = this.sqlTypeToJavaRegisterMap.get(sqlType);
            if (tuple != null) {
                return (Class)tuple.get1();
            }
            return null;
        }
    }
}

