/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.mapping.JavaSqlTypeMapper;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.policy.WhiteBlackListPolicy;
import java.sql.SQLType;

public abstract class AbstractJavaSqlTypeMapper<E>
implements JavaSqlTypeMapper<E> {
    private GenericType<E> genericType;
    private WhiteBlackListPolicy<String> columnAllowPolicy = new WhiteBlackListPolicy<String>(){

        public boolean isEnableBlackList() {
            return !this.getBlackList().isEmpty();
        }

        public boolean isEnableWhiteList() {
            return !this.getWhiteList().isEmpty();
        }

        protected boolean isEquals(String target1, String target2) {
            return Lang.equals((Object)target1, (Object)target2);
        }
    };

    AbstractJavaSqlTypeMapper() {
    }

    protected AbstractJavaSqlTypeMapper(GenericType<E> genericType) {
        AssertIllegalArgument.isNotNull(genericType, (String)"genericType");
        this.genericType = genericType;
    }

    protected void setGenericType(GenericType<E> genericType) {
        this.genericType = genericType;
    }

    public GenericType<E> getGenericType() {
        return this.genericType;
    }

    public Class<E> getJavaType() {
        return this.genericType.getType();
    }

    @Override
    public Class<E> getJavaType(SQLType sqlType) {
        return this.getJavaType();
    }

    @Override
    public boolean support(GenericType<E> type) {
        return this.genericType.equals(type);
    }

    protected abstract boolean support(SQLType var1);

    @Override
    public boolean support(SQLType sqlType, String tableName, String columnName) {
        if (sqlType != null && this.support(sqlType)) {
            return this.columnAllowPolicy.isAllow((Object)this.toKey(tableName, columnName));
        }
        return false;
    }

    private String toKey(String tableName, String columnName) {
        return tableName + "." + columnName;
    }

    public AbstractJavaSqlTypeMapper<E> addAllow(String tableName, String columnName) {
        this.columnAllowPolicy.addWhite((Object)this.toKey(tableName, columnName));
        return this;
    }

    public AbstractJavaSqlTypeMapper<E> addDeny(String tableName, String columnName) {
        this.columnAllowPolicy.addBlack((Object)this.toKey(tableName, columnName));
        return this;
    }
}

