/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.model;

import cn.featherfly.common.db.builder.model.ParamedColumnElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.operate.QueryOperator;
import java.lang.reflect.Array;
import java.util.Collection;

public class ConditionColumnElement
extends ParamedColumnElement {
    private QueryOperator queryOperator;

    public ConditionColumnElement(Dialect dialect, String name, Object value, QueryOperator queryOperator) {
        this(dialect, name, value, queryOperator, null);
    }

    public ConditionColumnElement(Dialect dialect, String name, Object value, QueryOperator queryOperator, String tableAlias) {
        super(dialect, name, value, tableAlias);
        this.queryOperator = queryOperator;
        if (Lang.isNotEmpty((Object)value)) {
            Object paramValue = null;
            switch (queryOperator) {
                case SW: {
                    paramValue = value + "%";
                    break;
                }
                case CO: {
                    paramValue = "%" + value + "%";
                    break;
                }
                case EW: {
                    paramValue = "%" + value;
                    break;
                }
                default: {
                    paramValue = value;
                }
            }
            this.setParam(paramValue);
        }
    }

    @Override
    public Object getParam() {
        if (QueryOperator.ISN == this.queryOperator || QueryOperator.INN == this.queryOperator) {
            return null;
        }
        return this.param;
    }

    @Override
    public String toSql() {
        if (Lang.isEmpty((String)this.name)) {
            return "";
        }
        StringBuilder condition = new StringBuilder();
        Object value = this.param;
        String name = this.dialect.buildColumnSql(this.name, this.tableAlias);
        if (Lang.isNotEmpty((Object)value)) {
            if (QueryOperator.IN == this.queryOperator || QueryOperator.NIN == this.queryOperator) {
                int length = 1;
                if (value instanceof Collection) {
                    length = ((Collection)value).size();
                } else if (value.getClass().isArray()) {
                    length = Array.getLength(value);
                }
                condition.append(name).append(" ").append(this.toOperator(this.queryOperator)).append(" (");
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        condition.append(",");
                    }
                    condition.append("?");
                }
                condition.append(")");
            } else {
                condition.append(name).append(" ");
                if (QueryOperator.ISN == this.queryOperator) {
                    if (((Boolean)value).booleanValue()) {
                        condition.append(this.toOperator(this.queryOperator));
                    } else {
                        condition.append(this.toOperator(QueryOperator.INN));
                    }
                } else if (QueryOperator.INN == this.queryOperator) {
                    if (((Boolean)value).booleanValue()) {
                        condition.append(this.toOperator(this.queryOperator));
                    } else {
                        condition.append(this.toOperator(QueryOperator.ISN));
                    }
                } else {
                    condition.append(this.toOperator(this.queryOperator)).append(" ").append("?");
                }
            }
        } else {
            return "";
        }
        return condition.toString();
    }

    private String toOperator(QueryOperator queryOperator) {
        switch (queryOperator) {
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
            case EQ: {
                return "=";
            }
            case NE: {
                return "!=";
            }
            case SW: {
                return this.dialect.getKeywords().like();
            }
            case CO: {
                return this.dialect.getKeywords().like();
            }
            case EW: {
                return this.dialect.getKeywords().like();
            }
            case ISN: {
                return this.dialect.getKeywords().isNull();
            }
            case INN: {
                return this.dialect.getKeywords().isNotNull();
            }
            case IN: {
                return this.dialect.getKeywords().in();
            }
            case NIN: {
                return this.dialect.getKeywords().notIn();
            }
            case LK: {
                return this.dialect.getKeywords().like();
            }
        }
        return "=";
    }
}

