
package cn.featherfly.common.db.migration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;

/**
 * <p>
 * VersionManager
 * </p>
 * TODO dir目录生成一个配置文件，读取当前的版本号，全自动生成版本对应sql文件.
 *
 * @author zhongj
 */
public class VersionManager {

    private File dir;

    private String name;

    private Migrator migrator;

    /**
     * Instantiates a new version manager.
     *
     * @param dir      the dir
     * @param name     the file name
     * @param migrator the migrator
     */
    public VersionManager(File dir, String name, Migrator migrator) {
        this.dir = dir;
        if (dir == null) {
            throw new IllegalArgumentException(dir + " not exist");
        }
        this.name = name;
        this.migrator = migrator;
    }

    private String name(String version, String type) {
        String extName = FileUtils.getFileExtName(name);
        if (Lang.isEmpty(extName)) {
            extName = "sql";
        }
        return name + "-" + version + "-" + type + "." + extName;
    }

    /**
     * Creates the init sql file.
     *
     * @param version       the version
     * @param classMappings the class mappings
     * @return the file
     */
    public File createInitSqlFile(String version, Set<ClassMapping<?>> classMappings) {
        File file = new File(dir.getPath() + "/" + name(version, "init"));
        try {
            org.apache.commons.io.FileUtils.write(file, migrator.initSql(classMappings), StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new cn.featherfly.common.exception.IOException(e);
        }
        return file;
    }

    /**
     * Creates the update sql file.
     *
     * @param version       the version
     * @param classMappings the class mappings
     * @return the file
     */
    public File createUpdateSqlFile(String version, Set<ClassMapping<?>> classMappings) {
        File file = new File(dir.getPath() + "/" + name(version, "update"));
        try {
            org.apache.commons.io.FileUtils.write(file, migrator.updateSql(classMappings), StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new cn.featherfly.common.exception.IOException(e);
        }
        return file;
    }

}
