/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Index;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDialect
implements Dialect {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Dialect.Keyworld keyworld;
    protected static final String UPDATE_STRING = " for update";
    private boolean keywordsUppercase = true;
    private Dialect.StringConverter tableAndColumnNameConverter = Dialect.StringConverter.NONE;

    public AbstractDialect() {
        this.keyworld = new Dialect.Keyworld(this);
    }

    @Override
    public boolean isKeywordsUppercase() {
        return this.keywordsUppercase;
    }

    public void setKeywordsUppercase(boolean keywordsUppercase) {
        this.keywordsUppercase = keywordsUppercase;
    }

    @Override
    public Dialect.StringConverter tableAndColumnNameConverter() {
        return this.tableAndColumnNameConverter;
    }

    public void setTableAndColumnNameUppercase(Dialect.StringConverter tableAndColumnNameConverter) {
        this.tableAndColumnNameConverter = tableAndColumnNameConverter;
    }

    @Override
    public String buildAlterTableDDL(String schema, String tableName, Column[] addColumns, Column[] modifyColumns, Column[] dropColumns) {
        if (Lang.isEmpty((Object[])addColumns) && Lang.isEmpty((Object[])modifyColumns) && Lang.isEmpty((Object[])dropColumns)) {
            return "";
        }
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(schema, tableName));
        ddl.append("\n");
        if (Lang.isNotEmpty((Object[])addColumns)) {
            ddl.append(this.buildAddColumnDDL(addColumns)).toString();
            if (Lang.isNotEmpty((Object[])modifyColumns) || Lang.isNotEmpty((Object[])dropColumns)) {
                ddl.append(",");
            }
            ddl.append("\n");
        }
        if (Lang.isNotEmpty((Object[])modifyColumns)) {
            ddl.append(this.buildModifyColumnDDL(modifyColumns)).toString();
            if (Lang.isNotEmpty((Object[])dropColumns)) {
                ddl.append(",");
            }
            ddl.append("\n");
        }
        if (Lang.isNotEmpty((Object[])dropColumns)) {
            ddl.append(this.buildDropColumnDDL(dropColumns)).toString();
            ddl.append("\n");
        }
        return ddl.toString();
    }

    @Override
    public String buildAlterTableAddColumnDDL(String schema, String tableName, Column ... columns) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(schema, tableName));
        return ddl.append("\n").append(this.buildAddColumnDDL(columns)).append(";").toString();
    }

    protected String buildAddColumnDDL(Column ... columns) {
        StringBuilder ddl = new StringBuilder(" ");
        for (Column column : columns) {
            BuilderUtils.link(ddl, this.getKeyword(Keywords.ADD), this.getKeyword(Keywords.COLUMN), this.getColumnDDL(column));
            ddl.append(",");
            ddl.append("\n");
        }
        ddl.deleteCharAt(ddl.length() - 1).deleteCharAt(ddl.length() - 1);
        return ddl.toString();
    }

    @Override
    public String buildAlterTableModifyColumnDDL(String schema, String tableName, Column ... columns) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(schema, tableName));
        return ddl.append("\n").append(this.buildModifyColumnDDL(columns)).append(";").toString();
    }

    protected String buildModifyColumnDDL(Column ... columns) {
        StringBuilder ddl = new StringBuilder(" ");
        for (Column column : columns) {
            BuilderUtils.link(ddl, this.getKeyword(Keywords.MODIFY), this.getKeyword(Keywords.COLUMN), this.getColumnDDL(column));
            ddl.append(",");
            ddl.append("\n");
        }
        ddl.deleteCharAt(ddl.length() - 1).deleteCharAt(ddl.length() - 1);
        return ddl.toString();
    }

    @Override
    public String buildAlterTableDropColumnDDL(String schema, String tableName, Column ... columns) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(schema, tableName));
        return ddl.append("\n").append(this.buildDropColumnDDL(columns)).append(";").toString();
    }

    @Override
    public String buildAlterTableDropColumnDDL(String schema, String tableName, String ... columnNames) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(schema, tableName));
        return ddl.append("\n").append(this.buildDropColumnDDL(columnNames)).append(";").toString();
    }

    protected String buildDropColumnDDL(Column ... columns) {
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].getName();
        }
        return this.buildDropColumnDDL(columnNames);
    }

    protected String buildDropColumnDDL(String ... columnNames) {
        StringBuilder ddl = new StringBuilder(" ");
        for (String columnName : columnNames) {
            BuilderUtils.link(ddl, this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.COLUMN), this.wrapName(columnName));
            ddl.append(",");
            ddl.append("\n");
        }
        ddl.deleteCharAt(ddl.length() - 1).deleteCharAt(ddl.length() - 1);
        return ddl.toString();
    }

    @Override
    public String buildCreateTableDDL(Table table) {
        AssertIllegalArgument.isNotEmpty((Object)table, (String)"table");
        String schema = table.getSchema();
        StringBuilder sql = new StringBuilder();
        String tableName = Lang.isEmpty((String)schema) ? this.wrapName(table.getName()) : this.wrapName(schema) + "." + this.wrapName(table.getName());
        BuilderUtils.link(sql, this.getKeyword(Keywords.CREATE), this.getKeyword(Keywords.TABLE), tableName, "(");
        sql.append("\n");
        BuilderUtils.link(sql, this.getTableColumnsDDL(table));
        sql.append("\n");
        BuilderUtils.link(sql, ")", this.getTableComment(table));
        if (table.getIndexs().size() > 0) {
            sql.append(";").append("\n");
            for (Index index : table.getIndexs()) {
                sql.append(this.buildCreateIndexDDL(schema, table.getName(), index.getName(), index.getColumns(), index.isUnique())).append("\n");
            }
            sql.deleteCharAt(sql.length() - 1);
        } else {
            sql.append(";");
        }
        return sql.toString();
    }

    protected String getTableComment(Table table) {
        return Lang.isEmpty((String)table.getRemark()) ? "" : BuilderUtils.link(this.getKeyword(Keywords.COMMENT), "'" + table.getRemark() + "'");
    }

    protected String getTableColumnsDDL(Table table) {
        StringBuilder ddl = new StringBuilder();
        for (Column column : table.getColumns()) {
            BuilderUtils.link(ddl, this.getColumnDDL(column));
            ddl.append(",");
            ddl.append("\n");
        }
        BuilderUtils.link(ddl, this.getPrimaryKeyDDL(table));
        return ddl.toString();
    }

    protected String getColumnDDL(Column column) {
        return BuilderUtils.link(this.wrapName(column.getName()), this.getColumnTypeDDL(column), this.getColumnNotNull(column), this.getDefaultValue(column), this.getAutoIncrement(column), this.getColumnComment(column));
    }

    protected String getPrimaryKeyDDL(Table table) {
        StringBuilder result = new StringBuilder("(");
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            result.append(this.wrapName(column.getName())).append(",");
        }
        result.deleteCharAt(result.length() - 1);
        result.append(")");
        return BuilderUtils.link(this.getKeyword(Keywords.PRIMARY), this.getKeyword(Keywords.KEY), result.toString());
    }

    protected String getDefaultValue(Column column) {
        if (Lang.isEmpty((String)column.getDefaultValue())) {
            return "";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DEFAULT), "'" + column.getDefaultValue() + "'");
    }

    protected abstract String getAutoIncrement(Column var1);

    protected String getColumnComment(Column column) {
        return Lang.isEmpty((String)column.getRemark()) ? "" : BuilderUtils.link(this.getKeyword(Keywords.COMMENT), "'" + column.getRemark() + "'");
    }

    protected String getColumnNotNull(Column column) {
        if (column.isNullable()) {
            return "";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.NOT), this.getKeyword(Keywords.NULL));
    }

    protected String getColumnTypeDDL(Column column) {
        return this.getColumnTypeDDL(column, null);
    }

    protected String getColumnTypeDDL(Column column, String extra) {
        int size = column.getSize();
        int decimalDigits = column.getDecimalDigits();
        String result = this.getColumnTypeName(column.getSqlType());
        if (this.defineNeedSize(column.getSqlType())) {
            if (size <= 0) {
                throw new JdbcMappingException("#size.not.define", Lang.array((Object[])new Object[]{column.getName()}));
            }
            result = result + "(" + size;
            if (decimalDigits > 0) {
                result = result + "," + decimalDigits;
            }
            result = result + ")";
        }
        if (Lang.isNotEmpty((String)extra)) {
            result = BuilderUtils.link(result, extra);
        }
        return result;
    }

    private boolean defineNeedSize(SQLType sqlType) {
        return sqlType == JDBCType.VARCHAR || sqlType == JDBCType.NVARCHAR || sqlType == JDBCType.CHAR || sqlType == JDBCType.NCHAR || sqlType == JDBCType.LONGVARCHAR || sqlType == JDBCType.LONGNVARCHAR || sqlType == JDBCType.FLOAT || sqlType == JDBCType.DOUBLE || sqlType == JDBCType.DECIMAL || sqlType == JDBCType.NUMERIC;
    }

    @Override
    public Dialect.Keyworld getKeywords() {
        return this.keyworld;
    }

    @Override
    public Object[] getPaginationSqlParameter(Object[] params, int start, int limit) {
        Object[] pagingParams = null;
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            pagingParams = new Object[2];
            pagingParams[0] = start;
        } else {
            this.logger.debug("start < 0 , don't use start");
            pagingParams = new Object[1];
        }
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        pagingParams[pagingParams.length - 1] = limit;
        return (Object[])ArrayUtils.concat((Object)params, (Object)pagingParams);
    }

    @Override
    public Map<String, Object> getPaginationSqlParameter(Map<String, Object> params, int start, int limit) {
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            params.put("dialect_paging_start", start);
        } else {
            this.logger.debug("start < 0 , don't use start");
        }
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        params.put("dialect_paging_limit", limit);
        return params;
    }

    protected boolean isForUpdate(String sql) {
        return sql.toLowerCase().endsWith(UPDATE_STRING);
    }

    @Override
    public String valueToSql(Object value, int sqlType) {
        return this.convertValueToSql(value, sqlType);
    }

    protected abstract String convertValueToSql(Object var1, int var2);
}

