/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.SqlResultSet;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.wrapper.ConnectionWrapper;
import cn.featherfly.common.db.wrapper.DataSourceWrapper;
import cn.featherfly.common.db.wrapper.PreparedStatementWrapper;
import cn.featherfly.common.db.wrapper.ResultSetWrapper;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.common.repository.mapping.ResultSet;
import cn.featherfly.common.repository.mapping.RowMapper;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static ConnectionWrapper getConnection(String driverClassName, String uri, String username, String password) {
        try {
            ClassUtils.forName((String)driverClassName);
            return new ConnectionWrapper(DriverManager.getConnection(uri, username, password));
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static ConnectionWrapper getConnection(String driverClassName, String uri) {
        try {
            ClassUtils.forName((String)driverClassName);
            return new ConnectionWrapper(DriverManager.getConnection(uri));
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
                conn = null;
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    public static void close(java.sql.ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    public static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
                stmt = null;
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeQuietly(Connection conn, Statement stmt, java.sql.ResultSet rs) {
        try {
            JdbcUtils.closeQuietly(rs);
        }
        finally {
            try {
                JdbcUtils.closeQuietly(stmt);
            }
            finally {
                JdbcUtils.closeQuietly(conn);
            }
        }
    }

    public static void closeQuietly(Connection conn) {
        try {
            JdbcUtils.close(conn);
        }
        catch (Exception e) {
            LogUtils.debug((Exception)e, (Logger)LOGGER);
        }
    }

    public static void closeQuietly(java.sql.ResultSet rs) {
        try {
            JdbcUtils.close(rs);
        }
        catch (Exception e) {
            LogUtils.debug((Exception)e, (Logger)LOGGER);
        }
    }

    public static void closeQuietly(Statement stmt) {
        try {
            JdbcUtils.close(stmt);
        }
        catch (Exception e) {
            LogUtils.debug((Exception)e, (Logger)LOGGER);
        }
    }

    public static void commitAndClose(Connection conn) {
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
            finally {
                JdbcUtils.close(conn);
            }
        }
    }

    public static void commitAndCloseQuietly(Connection conn) {
        try {
            JdbcUtils.commitAndClose(conn);
        }
        catch (JdbcException e) {
            LogUtils.debug((Exception)((Object)e), (Logger)LOGGER);
        }
    }

    public static boolean loadDriver(String driverClassName) {
        boolean result = false;
        try {
            Class.forName(driverClassName).newInstance();
            result = true;
        }
        catch (ClassNotFoundException e) {
            result = false;
        }
        catch (IllegalAccessException e) {
            result = true;
        }
        catch (InstantiationException e) {
            result = false;
        }
        catch (Throwable e) {
            result = false;
        }
        return result;
    }

    public static void printStackTrace(SQLException e) {
        JdbcUtils.printStackTrace(e, new PrintWriter(System.err));
    }

    public static void printStackTrace(SQLException e, PrintWriter pw) {
        SQLException next = e;
        while (next != null) {
            next.printStackTrace(pw);
            if ((next = next.getNextException()) == null) continue;
            pw.println("Next SQLException:");
        }
    }

    public static void printWarnings(Connection conn) {
        JdbcUtils.printWarnings(conn, new PrintWriter(System.err));
    }

    public static void printWarnings(Connection conn, PrintWriter pw) {
        if (conn != null) {
            try {
                JdbcUtils.printStackTrace(conn.getWarnings(), pw);
            }
            catch (SQLException e) {
                JdbcUtils.printStackTrace(e, pw);
            }
        }
    }

    public static void rollback(Connection conn) throws SQLException {
        if (conn != null) {
            conn.rollback();
        }
    }

    public static void rollbackAndClose(Connection conn) throws SQLException {
        if (conn != null) {
            try {
                conn.rollback();
            }
            finally {
                conn.close();
            }
        }
    }

    public static void rollbackAndCloseQuietly(Connection conn) {
        try {
            JdbcUtils.rollbackAndClose(conn);
        }
        catch (SQLException e) {
            LogUtils.debug((Exception)e, (Logger)LOGGER);
        }
    }

    public static DataSourceWrapper warpDataSource(DataSource dataSource) {
        return new DataSourceWrapper(dataSource);
    }

    public static ConnectionWrapper warpConnection(Connection connection) {
        return new ConnectionWrapper(connection);
    }

    public static Connection getConnection(DataSource dataSource) {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static ConnectionWrapper getConnectionWrapper(DataSource dataSource) {
        return JdbcUtils.warpConnection(JdbcUtils.getConnection(dataSource));
    }

    public static String getCatalog(DataSource dataSource) {
        String catalog = null;
        Connection conn = JdbcUtils.getConnection(dataSource);
        catalog = JdbcUtils.getCatalog(conn);
        JdbcUtils.close(conn);
        return catalog;
    }

    public static String getCatalog(Connection conn) {
        try {
            return conn.getCatalog();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static void setParameters(PreparedStatementWrapper prep, Object ... values) {
        if (Lang.isNotEmpty((Object[])values)) {
            for (int i = 0; i < values.length; ++i) {
                JdbcUtils.setParameter(prep, i + 1, values[i]);
            }
        }
    }

    public static void setParameters(PreparedStatement prep, Object ... values) {
        if (Lang.isNotEmpty((Object[])values)) {
            for (int i = 0; i < values.length; ++i) {
                JdbcUtils.setParameter(prep, i + 1, values[i]);
            }
        }
    }

    public static void setParameter(PreparedStatementWrapper prep, int position, Object value) {
        JdbcUtils.setParameter(prep, position, value, true);
    }

    public static void setParameter(PreparedStatementWrapper prep, int position, Object value, boolean enumWithOridinal) {
        JdbcUtils.setParameter(prep.getPreparedStatement(), position, value, enumWithOridinal);
    }

    public static void setParameter(PreparedStatement prep, int position, Object value) {
        JdbcUtils.setParameter(prep, position, value, true);
    }

    public static void setParameter(PreparedStatement prep, int position, Object value, boolean enumWithOridinal) {
        try {
            if (value == null) {
                prep.setObject(position, value);
            } else if (value instanceof Boolean) {
                prep.setBoolean(position, (Boolean)value);
            } else if (value instanceof String) {
                prep.setString(position, (String)value);
            } else if (value instanceof Integer) {
                prep.setInt(position, (Integer)value);
            } else if (value instanceof Long) {
                prep.setLong(position, (Long)value);
            } else if (value instanceof Float) {
                prep.setFloat(position, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                prep.setDouble(position, (Double)value);
            } else if (value instanceof BigDecimal) {
                prep.setBigDecimal(position, (BigDecimal)value);
            } else if (value instanceof BigInteger) {
                prep.setLong(position, ((BigInteger)value).longValue());
            } else if (value instanceof Byte) {
                prep.setByte(position, (Byte)value);
            } else if (value instanceof Character) {
                prep.setString(position, ((Character)value).toString());
            } else if (value instanceof Short) {
                prep.setShort(position, (Short)value);
            } else if (value instanceof Date) {
                prep.setDate(position, (Date)value);
            } else if (value instanceof Time) {
                prep.setTime(position, (Time)value);
            } else if (value instanceof LocalTime) {
                prep.setTime(position, Time.valueOf((LocalTime)value));
            } else if (value instanceof LocalDate) {
                prep.setDate(position, Date.valueOf((LocalDate)value));
            } else if (value instanceof LocalDateTime) {
                prep.setTimestamp(position, Timestamp.valueOf((LocalDateTime)value));
            } else if (value instanceof java.util.Date) {
                prep.setTimestamp(position, new Timestamp(((java.util.Date)value).getTime()));
            } else if (value instanceof Timestamp) {
                prep.setTimestamp(position, (Timestamp)value);
            } else if (value.getClass().isEnum()) {
                if (enumWithOridinal) {
                    prep.setInt(position, ((Enum)value).ordinal());
                } else {
                    prep.setString(position, ((Enum)value).name());
                }
            } else if (value instanceof Optional) {
                JdbcUtils.setParameter(prep, position, ((Optional)value).orElse(null));
            } else if (value instanceof AtomicInteger) {
                prep.setInt(position, ((AtomicInteger)value).get());
            } else if (value instanceof AtomicLong) {
                prep.setLong(position, ((AtomicLong)value).get());
            } else if (value instanceof AtomicBoolean) {
                prep.setBoolean(position, ((AtomicBoolean)value).get());
            } else {
                prep.setObject(position, value);
            }
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static int getColumnIndex(java.sql.ResultSet rs, String name) {
        try {
            return JdbcUtils.getColumnIndex(rs.getMetaData(), name);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static int getColumnIndex(ResultSetMetaData metaData, String name) {
        try {
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                String n = JdbcUtils.lookupColumnName(metaData, i);
                if (!n.equals(name)) continue;
                return i;
            }
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
        throw new JdbcException(String.format("column named [%s] not found in ResultSet", name));
    }

    public static SQLType getResultSQLType(ResultSetWrapper rs, int index) {
        return JdbcUtils.getResultSQLType(rs.getResultSet(), index);
    }

    public static SQLType getResultSQLType(java.sql.ResultSet rs, int index) {
        try {
            return JDBCType.valueOf(rs.getMetaData().getColumnType(index));
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static Object getResultSetValue(java.sql.ResultSet rs, int index, Class<?> requiredType) {
        if (requiredType == null) {
            return JdbcUtils.getResultSetValue(rs, index);
        }
        try {
            Object value = null;
            boolean wasNullCheck = false;
            if (String.class.equals(requiredType)) {
                value = rs.getString(index);
            } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
                value = rs.getBoolean(index);
                wasNullCheck = true;
            } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
                value = new Byte(rs.getByte(index));
                wasNullCheck = true;
            } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
                value = new Short(rs.getShort(index));
                wasNullCheck = true;
            } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
                value = new Integer(rs.getInt(index));
                wasNullCheck = true;
            } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
                value = new Long(rs.getLong(index));
                wasNullCheck = true;
            } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
                value = new Float(rs.getFloat(index));
                wasNullCheck = true;
            } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
                value = new Double(rs.getDouble(index));
                wasNullCheck = true;
            } else if (byte[].class.equals(requiredType)) {
                value = rs.getBytes(index);
            } else if (Date.class.equals(requiredType)) {
                value = rs.getDate(index);
            } else if (Time.class.equals(requiredType)) {
                value = rs.getTime(index);
            } else if (Timestamp.class.equals(requiredType) || java.util.Date.class.equals(requiredType)) {
                value = rs.getTimestamp(index);
            } else if (LocalDate.class.equals(requiredType)) {
                value = rs.getDate(index);
                if (value != null) {
                    value = Dates.toLocalDate((java.util.Date)new java.util.Date(((Date)value).getTime()));
                }
            } else if (LocalTime.class.equals(requiredType)) {
                value = rs.getTime(index);
                if (value != null) {
                    value = Dates.toLocalTime((java.util.Date)new java.util.Date(((Time)value).getTime()));
                }
            } else if (LocalDateTime.class.equals(requiredType)) {
                value = rs.getTimestamp(index);
                if (value != null) {
                    value = Dates.toLocalDateTime((java.util.Date)new java.util.Date(((Timestamp)value).getTime()));
                }
            } else if (BigDecimal.class.equals(requiredType)) {
                value = rs.getBigDecimal(index);
            } else if (Blob.class.equals(requiredType)) {
                value = rs.getBlob(index);
            } else if (Clob.class.equals(requiredType)) {
                value = rs.getClob(index);
            } else if (requiredType.isEnum()) {
                ResultSetMetaData meta = rs.getMetaData();
                switch (meta.getColumnType(index)) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        value = Lang.toEnum(requiredType, (Object)rs.getInt(index));
                        break;
                    }
                    default: {
                        value = Lang.toEnum(requiredType, (Object)rs.getString(index));
                        break;
                    }
                }
            } else {
                value = JdbcUtils.getResultSetValue(rs, index);
            }
            if (wasNullCheck && value != null && rs.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static Object getResultSetValue(java.sql.ResultSet rs, int index) {
        try {
            Object obj = rs.getObject(index);
            String className = null;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (obj instanceof Blob) {
                obj = rs.getBytes(index);
            } else if (obj instanceof Clob) {
                obj = rs.getString(index);
            } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
                obj = rs.getTimestamp(index);
            } else if (className != null && className.startsWith("oracle.sql.DATE")) {
                String metaDataClassName = rs.getMetaData().getColumnClassName(index);
                obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
            } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
                obj = rs.getTimestamp(index);
            }
            return obj;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    private static Map<String, Object> getResultSetMap(java.sql.ResultSet rs) {
        try {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                Object value = JdbcUtils.getResultSetValue(rs, i);
                String name = JdbcUtils.lookupColumnName(metaData, i);
                resultMap.put(name, value);
            }
            return resultMap;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    private static Map<String, Object> getResultSetMap(java.sql.ResultSet rs, SqlTypeMappingManager manager) {
        try {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                Class type = manager.getJavaType(JDBCType.valueOf(metaData.getColumnType(i)));
                Object value = null;
                value = type != null ? manager.get(rs, i, new GenericClass(type)) : JdbcUtils.getResultSetValue(rs, i);
                String name = metaData.getColumnLabel(i);
                if (Lang.isEmpty((String)name)) {
                    name = metaData.getColumnName(i);
                    name = WordUtils.parseToUpperFirst((String)name.toLowerCase(), (char)'_');
                }
                resultMap.put(name, value);
            }
            return resultMap;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static <E> List<E> getResultSetObjects(ResultSetWrapper rs, RowMapper<E> mapper) {
        return JdbcUtils.getResultSetObjects(rs.getResultSet(), mapper);
    }

    public static <E> List<E> getResultSetObjects(java.sql.ResultSet rs, RowMapper<E> mapper) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            int index = 1;
            while (rs.next()) {
                list.add(mapper.mapRow((ResultSet)new SqlResultSet(rs), index));
                ++index;
            }
            return list;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static List<Map<String, Object>> getResultSetMaps(ResultSetWrapper rs) {
        return JdbcUtils.getResultSetMaps(rs.getResultSet());
    }

    public static List<Map<String, Object>> getResultSetMaps(java.sql.ResultSet rs) {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                list.add(JdbcUtils.getResultSetMap(rs));
            }
            return list;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static List<Map<String, Object>> getResultSetMaps(java.sql.ResultSet rs, SqlTypeMappingManager manager) {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                list.add(JdbcUtils.getResultSetMap(rs, manager));
            }
            return list;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    private static Object[] getResultSetArray(java.sql.ResultSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            Object[] result = new Object[metaData.getColumnCount()];
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                result[i] = JdbcUtils.getResultSetValue(rs, i);
            }
            return result;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static List<Object[]> getResultSetArrays(ResultSetWrapper rs) {
        return JdbcUtils.getResultSetArrays(rs.getResultSet());
    }

    public static List<Object[]> getResultSetArrays(java.sql.ResultSet rs) {
        try {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            while (rs.next()) {
                list.add(JdbcUtils.getResultSetArray(rs));
            }
            return list;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) {
        try {
            String name = resultSetMetaData.getColumnLabel(columnIndex);
            if (Lang.isEmpty((String)name)) {
                name = resultSetMetaData.getColumnName(columnIndex);
            }
            return name;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }
}

