/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.wrapper;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.wrapper.ConnectionWrapper;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceWrapper {
    private DataSource dataSource;

    public DataSourceWrapper(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ConnectionWrapper getConnection() {
        try {
            return new ConnectionWrapper(this.dataSource.getConnection());
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public ConnectionWrapper getConnection(String username, String password) {
        try {
            return new ConnectionWrapper(this.dataSource.getConnection(username, password));
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PrintWriter getLogWriter() {
        try {
            return this.dataSource.getLogWriter();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public int getLoginTimeout() {
        try {
            return this.dataSource.getLoginTimeout();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setLogWriter(PrintWriter out) {
        try {
            this.dataSource.setLogWriter(out);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setLoginTimeout(int seconds) {
        try {
            this.dataSource.setLoginTimeout(seconds);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isWrapperFor(Class<?> iface) {
        try {
            return this.dataSource.isWrapperFor(iface);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public <T> T unwrap(Class<T> iface) {
        try {
            return this.dataSource.unwrap(iface);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

