/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.model;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Index;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTable<C extends Column>
implements Table {
    protected String type;
    protected String name;
    protected String remark;
    protected String catalog;
    protected String schema;
    protected List<Column> primaryColumns = new ArrayList<Column>(1);
    protected Map<String, Column> columnMap = new LinkedHashMap<String, Column>(0);
    protected Map<String, Index> indexMap = new LinkedHashMap<String, Index>();

    protected void add(C column) {
        if (column.isPrimaryKey()) {
            this.primaryColumns.add((Column)column);
        }
        this.columnMap.put(column.getName().toUpperCase(), (Column)column);
    }

    protected void add(Index index) {
        this.indexMap.put(index.getName().toUpperCase(), index);
    }

    @Override
    public boolean hasColumn(String columnName) {
        if (Lang.isEmpty((String)columnName)) {
            return false;
        }
        return this.columnMap.containsKey(columnName.toUpperCase());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.remark == null ? 0 : this.remark.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.columnMap == null ? 0 : this.columnMap.hashCode());
        result = 31 * result + (this.indexMap == null ? 0 : this.indexMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        if (!Lang.equals((Object)this.catalog, (Object)other.getCatalog())) {
            return false;
        }
        if (!Lang.equals((Object)this.schema, (Object)other.getSchema())) {
            return false;
        }
        if (!Lang.equals(this.columnMap, other.getColumnMap())) {
            return false;
        }
        if (!Lang.equals((Object)this.name, (Object)other.getName())) {
            return false;
        }
        if (!Lang.equals((Object)this.remark, (Object)other.getRemark())) {
            return false;
        }
        if (!Lang.equals((Object)this.type, (Object)other.getType())) {
            return false;
        }
        return Lang.equals(this.indexMap, other.getColumnMap());
    }

    public String toString() {
        return "Table [type=" + this.type + ", name=" + this.name + ", remark=" + this.remark + ", catalog=" + this.catalog + ", schema=" + this.schema + ", columns=" + this.columnMap + ", indexs=" + this.indexMap + "]";
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public Column getColumn(String columnName) {
        return Lang.isEmpty((String)columnName) ? null : this.columnMap.get(columnName.toUpperCase());
    }

    @Override
    public Collection<Column> getColumns() {
        return new ArrayList<Column>(this.columnMap.values());
    }

    @Override
    public Map<String, Column> getColumnMap() {
        return new LinkedHashMap<String, Column>(this.columnMap);
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return new ArrayList<Column>(this.primaryColumns);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<Index> getIndexs() {
        return new ArrayList<Index>(this.indexMap.values());
    }

    @Override
    public Map<String, Index> getIndexMap() {
        return new LinkedHashMap<String, Index>(this.indexMap);
    }

    @Override
    public Index getIndex(String indexName) {
        return Lang.isEmpty((String)indexName) ? null : this.indexMap.get(indexName.toUpperCase());
    }

    @Override
    public boolean hasIndex(String indexName) {
        return Lang.isEmpty((String)indexName) ? false : this.indexMap.containsKey(indexName.toUpperCase());
    }
}

