/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.structure.HashChainMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RecordModel {
    private Map<String, ValueModel> valueModels = new HashMap<String, ValueModel>();
    private String tableName;

    public RecordModel(String tableName) {
        this.tableName = tableName;
    }

    public void add(ValueModel valueModel) {
        if (valueModel != null) {
            this.valueModels.put(valueModel.getColumnName(), valueModel);
        }
    }

    public ValueModel getValueMode(String columnName) {
        return this.valueModels.get(columnName);
    }

    public Collection<ValueModel> getValueModes() {
        return new ArrayList<ValueModel>(this.valueModels.values());
    }

    public boolean isColumnExist(String columnName) {
        return this.valueModels.containsKey(columnName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return new HashChainMap().putChain((Object)"tableName", (Object)this.tableName).putChain((Object)"values", this.getValueModes()).toString();
    }

    public static class ValueModel {
        private String columnName;
        private String value;
        private int type;

        public ValueModel(String columnName, int type, String value) {
            this.columnName = columnName;
            this.value = value;
            this.type = type;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return BeanUtils.toMap((Object)this).toString();
        }
    }
}

