/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml;

import cn.featherfly.common.db.builder.dml.AbstractSqlSelectBuilder;
import cn.featherfly.common.db.builder.dml.SelectBuilder;
import cn.featherfly.common.db.builder.dml.SqlConditionBuilder;
import cn.featherfly.common.db.builder.dml.SqlConditionGroup;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.operate.AggregateFunction;
import java.util.Collection;
import java.util.Map;

public class SqlSelectBuilder
extends AbstractSqlSelectBuilder
implements SelectBuilder {
    public SqlSelectBuilder(Dialect dialect, SqlConditionGroup conditionBuilder) {
        this(dialect, null, null, conditionBuilder);
    }

    public SqlSelectBuilder(Dialect dialect, String tableName, SqlConditionGroup conditionBuilder) {
        this(dialect, tableName, null, conditionBuilder);
    }

    public SqlSelectBuilder(Dialect dialect, String tableName, String alias, SqlConditionGroup conditionBuilder) {
        super(dialect, tableName, alias, conditionBuilder);
    }

    @Override
    public SelectBuilder select(String columnName, AggregateFunction aggregateFunction) {
        this.addSelectColumn(columnName, aggregateFunction);
        return this;
    }

    @Override
    public SelectBuilder select(String columnName, AggregateFunction aggregateFunction, String asName) {
        this.addSelectColumn(columnName, aggregateFunction, asName);
        return this;
    }

    @Override
    public SelectBuilder select(Map<String, String> columnNames) {
        this.addSelectColumn(columnNames);
        return this;
    }

    @Override
    public SelectBuilder select(String columnName) {
        this.addSelectColumn(columnName, null, null);
        return this;
    }

    @Override
    public SelectBuilder select(String columnName, String asName) {
        this.addSelectColumn(columnName, asName);
        return this;
    }

    @Override
    public SelectBuilder select(String[] columnNames) {
        if (Lang.isNotEmpty((Object[])columnNames)) {
            for (String columnName : columnNames) {
                this.select(columnName);
            }
        }
        return this;
    }

    @Override
    public SelectBuilder select(Collection<String> columnNames) {
        if (Lang.isNotEmpty(columnNames)) {
            for (String columnName : columnNames) {
                this.select(columnName);
            }
        }
        return this;
    }

    @Override
    public SqlConditionBuilder from(String tableName) {
        return this.from(tableName, null);
    }

    @Override
    public SqlConditionBuilder from(String tableName, String alias) {
        this.setTableName(tableName);
        this.setTableAlias(alias);
        this.conditionBuilder.setQueryAlias(alias);
        return this.conditionBuilder;
    }
}

