/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.model.TableElement;
import cn.featherfly.common.db.dialect.DialectException;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.operate.AggregateFunction;
import cn.featherfly.common.repository.operate.Function;
import cn.featherfly.common.repository.operate.LogicOperator;
import cn.featherfly.common.repository.operate.SortOperator;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.Map;

public interface Dialect {
    public static final String START_PARAM_NAME = "dialect_paging_start";
    public static final String LIMIT_PARAM_NAME = "dialect_paging_limit";
    public static final String PRIMARY_KEY_INDEX_NAME = "PRIMARY";
    public static final char PARAM_NAME_START_SYMBOL = ':';
    public static final int DEFAULT_LIMIT = 10;

    public String getPaginationSql(String var1, int var2, int var3);

    public Object[] getPaginationSqlParameter(Object[] var1, int var2, int var3);

    public Map<String, Object> getPaginationSqlParameter(Map<String, Object> var1, int var2, int var3);

    public String getParamNamedPaginationSql(String var1, int var2, int var3);

    public String getParamNamedPaginationSql(String var1, int var2, int var3, char var4);

    public String valueToSql(Object var1, int var2);

    public String wrapName(String var1);

    default public boolean isAutoGenerateKeyBatch() {
        return true;
    }

    default public boolean isInsertBatch() {
        return true;
    }

    public String getInitSqlHeader();

    public String getInitSqlFooter();

    default public String buildInsertBatchSql(String tableName, String[] columnNames, int insertAmount) {
        String sql = BuilderUtils.link(this.getKeyword(Keywords.INSERT), this.getKeyword(Keywords.INTO), this.wrapName(tableName), "(");
        StringBuilder names = new StringBuilder();
        for (String column : columnNames) {
            BuilderUtils.link(names, this.wrapName(column) + ",");
        }
        names.deleteCharAt(names.length() - 1).append(")");
        sql = sql + names.toString();
        sql = BuilderUtils.link(sql, this.getKeyword(Keywords.VALUES), "(");
        StringBuilder ques = new StringBuilder();
        for (int i = 0; i < columnNames.length; ++i) {
            BuilderUtils.link(ques, "?,");
        }
        ques.deleteCharAt(ques.length() - 1).append(")");
        sql = sql + ques.toString();
        for (int index = 1; index < insertAmount; ++index) {
            ques = new StringBuilder();
            for (int j = 0; j < columnNames.length; ++j) {
                BuilderUtils.link(ques, "?,");
            }
            ques.deleteCharAt(ques.length() - 1).append(")");
            sql = sql + ",(" + ques.toString();
        }
        return sql;
    }

    default public boolean isKeywordsUppercase() {
        return true;
    }

    default public boolean isTableAndColumnNameUppercase() {
        return false;
    }

    default public Keyworld getKeywords() {
        return new Keyworld(this);
    }

    default public String getKeyword(SortOperator keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getKeyword(LogicOperator keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getKeyword(Keywords keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getFunction(Function function) {
        if (this.isKeywordsUppercase()) {
            return function.toString().toUpperCase();
        }
        return function.toString().toLowerCase();
    }

    default public String buildColumnSql(String columnName, Function function) {
        return this.buildColumnSql(columnName, null, function);
    }

    default public String buildColumnSql(String columnName, AggregateFunction aggregateFunction) {
        return this.buildColumnSql(columnName, null, aggregateFunction);
    }

    default public String buildColumnSql(String columnName, String tableAlias) {
        return this.buildColumnSql(columnName, tableAlias, null, null);
    }

    default public String buildColumnSql(String columnName, String tableAlias, String asName) {
        return this.buildColumnSql(columnName, tableAlias, null, asName);
    }

    default public String buildColumnSql(String columnName, String tableAlias, AggregateFunction aggregateFunction) {
        return this.buildColumnSql(columnName, tableAlias, aggregateFunction, null);
    }

    default public String buildColumnSql(String columnName, String tableAlias, AggregateFunction aggregateFunction, String asName) {
        String column = columnName;
        if (!"*".equals(columnName)) {
            column = this.wrapName(this.convertTableOrColumnName(columnName));
        }
        if (Lang.isNotEmpty((String)tableAlias) && !"*".equals(columnName)) {
            column = tableAlias + "." + column;
        }
        if (aggregateFunction != null) {
            switch (aggregateFunction) {
                case DISTINCT: {
                    column = this.getFunction((Function)aggregateFunction) + " " + column;
                    break;
                }
                default: {
                    column = this.getFunction((Function)aggregateFunction) + "(" + column + ")";
                }
            }
        }
        if (Lang.isNotEmpty((String)asName)) {
            column = column + " " + this.wrapName(asName);
        }
        return column;
    }

    default public String buildColumnSql(String columnName, String tableAlias, Function function) {
        if (function instanceof AggregateFunction) {
            return this.buildColumnSql(columnName, tableAlias, (AggregateFunction)function);
        }
        throw new DialectException("\u53ea\u5b9e\u73b0\u4e86 AggregateFunction\uff0c\u672a\u5b9e\u73b0\u7684 function" + function.getClass().getName());
    }

    default public String convertTableOrColumnName(String tableOrColumnName) {
        if (Lang.isEmpty((String)tableOrColumnName)) {
            return tableOrColumnName;
        }
        String result = tableOrColumnName;
        result = this.isTableAndColumnNameUppercase() ? result.toUpperCase() : result.toLowerCase();
        return result;
    }

    default public String buildTableSql(TableElement table) {
        return this.buildTableSql(table.getName(), table.getAlias());
    }

    default public String buildTableSql(String tableName) {
        return this.buildTableSql(tableName, null);
    }

    default public String buildTableSql(String tableName, String tableAlias) {
        String result = this.wrapName(this.convertTableOrColumnName(tableName));
        if (Lang.isNotEmpty((String)tableAlias)) {
            result = result + " " + tableAlias;
        }
        return result;
    }

    default public String buildCreateDataBaseDDL(String dataBaseName) {
        AssertIllegalArgument.isNotEmpty((String)dataBaseName, (String)"dataBaseName");
        return BuilderUtils.link(this.getKeyword(Keywords.CREATE), this.getKeyword(Keywords.DATABASE), this.wrapName(dataBaseName)) + ";";
    }

    default public String buildDropDataBaseDDL(String dataBaseName) {
        return this.buildDropDataBaseDDL(dataBaseName, false);
    }

    default public String buildDropDataBaseDDL(String dataBaseName, boolean ifExists) {
        AssertIllegalArgument.isNotEmpty((String)dataBaseName, (String)"dataBaseName");
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.DATABASE), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), this.wrapName(dataBaseName)) + ";";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.DATABASE), this.wrapName(dataBaseName)) + ";";
    }

    default public String buildCreateSchemaDDL(String schemaName) {
        AssertIllegalArgument.isNotEmpty((String)schemaName, (String)"schemaName");
        return BuilderUtils.link(this.getKeyword(Keywords.CREATE), this.getKeyword(Keywords.SCHEMA), this.wrapName(schemaName)) + ";";
    }

    default public String buildDropSchemaDDL(String schemaName) {
        return this.buildDropSchemaDDL(schemaName, false);
    }

    default public String buildDropSchemaDDL(String schemaName, boolean ifExists) {
        AssertIllegalArgument.isNotEmpty((String)schemaName, (String)"dataBaseName");
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.SCHEMA), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), this.wrapName(schemaName)) + ";";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.SCHEMA), this.wrapName(schemaName)) + ";";
    }

    public String buildCreateTableDDL(Table var1);

    default public String buildDropTableDDL(String tableName) {
        return this.buildDropTableDDL(null, tableName);
    }

    default public String buildDropTableDDL(String tableName, boolean ifExists) {
        return this.buildDropTableDDL(null, tableName, ifExists);
    }

    default public String buildDropTableDDL(String schema, String tableName) {
        return this.buildDropTableDDL(schema, tableName, false);
    }

    default public String buildDropTableDDL(String schema, String tableName, boolean ifExists) {
        return this.buildDropTableDDL(schema, tableName, ifExists, false);
    }

    default public String buildDropTableDDL(String schema, String tableName, boolean ifExists, boolean cascade) {
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        String tn = Lang.isEmpty((String)schema) ? this.wrapName(tableName) : this.wrapName(schema) + "." + this.wrapName(tableName);
        String ddl = "";
        ddl = ifExists ? BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.TABLE), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), tn) : BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.TABLE), tn);
        if (cascade) {
            ddl = ddl + " " + (Object)((Object)Keywords.CASCADE);
        }
        return ddl + ";";
    }

    default public String buildAlterTableDDL(String tableName) {
        return this.buildAlterTableDDL(null, tableName);
    }

    default public String buildAlterTableDDL(String schema, String tableName) {
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        if (Lang.isEmpty((String)schema)) {
            return BuilderUtils.link(this.getKeyword(Keywords.ALTER), this.getKeyword(Keywords.TABLE), this.wrapName(tableName));
        }
        return BuilderUtils.link(this.getKeyword(Keywords.ALTER), this.getKeyword(Keywords.TABLE), this.wrapName(schema) + "." + this.wrapName(tableName));
    }

    public String buildAlterTableDDL(String var1, String var2, Column[] var3, Column[] var4, Column[] var5);

    default public String buildAlterTableAddColumnDDL(String tableName, Column ... columns) {
        return this.buildAlterTableAddColumnDDL(null, tableName, columns);
    }

    public String buildAlterTableAddColumnDDL(String var1, String var2, Column ... var3);

    default public String buildAlterTableModifyColumnDDL(String tableName, Column ... columns) {
        return this.buildAlterTableModifyColumnDDL(null, tableName, columns);
    }

    public String buildAlterTableModifyColumnDDL(String var1, String var2, Column ... var3);

    default public String buildAlterTableDropColumnDDL(Column column) {
        return this.buildAlterTableDropColumnDDL(null, column.getName(), column);
    }

    default public String buildAlterTableDropColumnDDL(String tableName, Column ... columns) {
        return this.buildAlterTableDropColumnDDL(null, tableName, columns);
    }

    public String buildAlterTableDropColumnDDL(String var1, String var2, Column ... var3);

    public String buildAlterTableDropColumnDDL(String var1, String var2, String ... var3);

    default public String buildDropViewDDL(String viewName) {
        return this.buildDropViewDDL(null, viewName);
    }

    default public String buildDropViewDDL(String schema, String viewName) {
        return this.buildDropViewDDL(schema, viewName, false);
    }

    default public String buildDropViewDDL(String schema, String viewName, boolean ifExists) {
        AssertIllegalArgument.isNotEmpty((String)viewName, (String)"viewName");
        return this.buildDropDDL(schema, viewName, Keywords.VIEW, ifExists);
    }

    default public String buildDropDDL(String schema, String name, Keywords type, boolean ifExists) {
        String tn;
        AssertIllegalArgument.isNotEmpty((String)name, (String)"name");
        AssertIllegalArgument.isNotEmpty((Object)((Object)type), (String)"type");
        String string = tn = Lang.isEmpty((String)schema) ? this.wrapName(name) : this.wrapName(schema) + "." + this.wrapName(name);
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(type), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), tn) + ";";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(type), tn) + ";";
    }

    default public String buildCreateIndexDDL(String tableName, String indexName, String[] columns) {
        return this.buildCreateIndexDDL(tableName, indexName, columns, false);
    }

    default public String buildCreateIndexDDL(String tableName, String indexName, String[] columns, boolean unique) {
        return this.buildCreateIndexDDL(null, tableName, indexName, columns, unique);
    }

    default public String buildCreateIndexDDL(String schema, String tableName, String indexName, String[] columns) {
        return this.buildCreateIndexDDL(schema, tableName, indexName, columns, false);
    }

    default public String buildCreateIndexDDL(String schema, String tableName, String indexName, String[] columns, boolean unique) {
        AssertIllegalArgument.isNotEmpty((Object[])columns, (String)"columns");
        StringBuilder ddl = new StringBuilder();
        String tn = Lang.isEmpty((String)schema) ? this.wrapName(tableName) : this.wrapName(schema) + "." + this.wrapName(tableName);
        StringBuilder cols = new StringBuilder();
        cols.append("(");
        for (String column : columns) {
            cols.append(this.wrapName(column)).append(",");
        }
        cols.deleteCharAt(cols.length() - 1);
        cols.append(")");
        String indexKeyWords = unique ? this.getKeyword(Keywords.UNIQUE) + " " + this.getKeyword(Keywords.INDEX) : this.getKeyword(Keywords.INDEX);
        BuilderUtils.link(ddl, this.getKeyword(Keywords.CREATE), indexKeyWords, indexName, this.getKeyword(Keywords.ON), tn + cols.toString());
        return ddl.toString() + ";";
    }

    default public String buildDropIndexDDL(String tableName, String indexName) {
        return this.buildDropIndexDDL(null, tableName, indexName);
    }

    default public String buildDropIndexDDL(String tableName, String indexName, boolean ifExists) {
        return this.buildDropIndexDDL(null, tableName, indexName, ifExists);
    }

    default public String buildDropIndexDDL(String schema, String tableName, String indexName) {
        return this.buildDropIndexDDL(schema, tableName, indexName, false);
    }

    default public String buildDropIndexDDL(String schema, String tableName, String indexName, boolean ifExists) {
        String name;
        AssertIllegalArgument.isNotEmpty((String)indexName, (String)"indexName");
        String string = name = Lang.isEmpty((String)schema) ? this.wrapName(indexName) : this.wrapName(schema) + "." + this.wrapName(indexName);
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.INDEX), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), name) + ";";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.INDEX), name) + ";";
    }

    default public String getColumnTypeName(SQLType sqlType) {
        return sqlType.getName();
    }

    default public String getDefaultSchema(String catalog) {
        return "public";
    }

    default public int getDefaultSize(SQLType sqlType) {
        if (sqlType == JDBCType.BIGINT) {
            return 19;
        }
        if (sqlType == JDBCType.INTEGER) {
            return 10;
        }
        if (sqlType == JDBCType.SMALLINT) {
            return 5;
        }
        if (sqlType == JDBCType.TINYINT) {
            return 3;
        }
        if (sqlType == JDBCType.TIMESTAMP) {
            return 19;
        }
        if (sqlType == JDBCType.DATE) {
            return 10;
        }
        if (sqlType == JDBCType.TIME) {
            return 8;
        }
        return 0;
    }

    default public String getPrimaryKeyIndexName() {
        return PRIMARY_KEY_INDEX_NAME;
    }

    public String getWrapSign();

    public static class Keyworld {
        private Dialect dialect;

        Keyworld(Dialect dialect) {
            this.dialect = dialect;
        }

        public String select() {
            return this.dialect.getKeyword(Keywords.SELECT);
        }

        public String from() {
            return this.dialect.getKeyword(Keywords.FROM);
        }

        public String where() {
            return this.dialect.getKeyword(Keywords.WHERE);
        }

        public String update() {
            return this.dialect.getKeyword(Keywords.UPDATE);
        }

        public String set() {
            return this.dialect.getKeyword(Keywords.SET);
        }

        public String delete() {
            return this.dialect.getKeyword(Keywords.DELETE);
        }

        public String deleteFrom() {
            return this.delete() + " " + this.from();
        }

        public String insert() {
            return this.dialect.getKeyword(Keywords.INSERT);
        }

        public String into() {
            return this.dialect.getKeyword(Keywords.INTO);
        }

        public String values() {
            return this.dialect.getKeyword(Keywords.VALUES);
        }

        public String join() {
            return this.dialect.getKeyword(Keywords.JOIN);
        }

        public String join(Join join) {
            switch (join) {
                case INNER_JOIN: {
                    return this.join();
                }
                case LEFT_JOIN: {
                    return this.left() + " " + this.join();
                }
                case RIGHT_JOIN: {
                    return this.right() + " " + this.join();
                }
                case FULL_JOIN: {
                    return this.full() + " " + this.join();
                }
            }
            return this.join();
        }

        public String on() {
            return this.dialect.getKeyword(Keywords.ON);
        }

        public String inner() {
            return this.dialect.getKeyword(Keywords.INNER);
        }

        public String left() {
            return this.dialect.getKeyword(Keywords.LEFT);
        }

        public String right() {
            return this.dialect.getKeyword(Keywords.RIGHT);
        }

        public String create() {
            return this.dialect.getKeyword(Keywords.CREATE);
        }

        public String drop() {
            return this.dialect.getKeyword(Keywords.DROP);
        }

        public String after() {
            return this.dialect.getKeyword(Keywords.AFTER);
        }

        public String table() {
            return this.dialect.getKeyword(Keywords.TABLE);
        }

        public String add() {
            return this.dialect.getKeyword(Keywords.ADD);
        }

        public String truncate() {
            return this.dialect.getKeyword(Keywords.TRUNCATE);
        }

        public String outer() {
            return this.dialect.getKeyword(Keywords.OUTER);
        }

        public String full() {
            return this.dialect.getKeyword(Keywords.FULL);
        }

        public String cross() {
            return this.dialect.getKeyword(Keywords.CORSS);
        }

        public String order() {
            return this.dialect.getKeyword(Keywords.ORDER);
        }

        public String by() {
            return this.dialect.getKeyword(Keywords.BY);
        }

        public String orderBy() {
            return this.order() + " " + this.by();
        }

        public String desc() {
            return this.dialect.getKeyword(Keywords.DESC);
        }

        public String asc() {
            return this.dialect.getKeyword(Keywords.ASC);
        }

        public String in() {
            return this.dialect.getKeyword(Keywords.IN);
        }

        public String is() {
            return this.dialect.getKeyword(Keywords.IS);
        }

        public String isNull() {
            return this.is() + " " + this.nullText();
        }

        public String isNotNull() {
            return this.is() + " " + this.not() + " " + this.nullText();
        }

        public String like() {
            return this.dialect.getKeyword(Keywords.LIKE);
        }

        public String nullText() {
            return this.dialect.getKeyword(Keywords.NULL);
        }

        public String not() {
            return this.dialect.getKeyword(Keywords.NOT);
        }

        public String notIn() {
            return this.not() + " " + this.in();
        }

        public String between() {
            return this.dialect.getKeyword(Keywords.BETWEEN);
        }

        public String union() {
            return this.dialect.getKeyword(Keywords.UNION);
        }

        public String intersect() {
            return this.dialect.getKeyword(Keywords.INTERSECT);
        }

        public String except() {
            return this.dialect.getKeyword(Keywords.EXCEPT);
        }

        public String and() {
            return this.dialect.getKeyword(Keywords.AND);
        }

        public String or() {
            return this.dialect.getKeyword(Keywords.OR);
        }

        public String all() {
            return this.dialect.getKeyword(Keywords.ALL);
        }

        public String as() {
            return this.dialect.getKeyword(Keywords.AS);
        }

        public String count() {
            return this.dialect.getKeyword(Keywords.COUNT);
        }

        public String sum() {
            return this.dialect.getKeyword(Keywords.SUM);
        }

        public String max() {
            return this.dialect.getKeyword(Keywords.MAX);
        }

        public String min() {
            return this.dialect.getKeyword(Keywords.MIN);
        }

        public String avg() {
            return this.dialect.getKeyword(Keywords.AVG);
        }

        public String distinct() {
            return this.dialect.getKeyword(Keywords.DISTINCT);
        }

        public String view() {
            return this.dialect.getKeyword(Keywords.VIEW);
        }

        public String index() {
            return this.dialect.getKeyword(Keywords.INDEX);
        }

        public String default_() {
            return this.dialect.getKeyword(Keywords.DEFAULT);
        }

        public String alter() {
            return this.dialect.getKeyword(Keywords.ALTER);
        }

        public String column() {
            return this.dialect.getKeyword(Keywords.COLUMN);
        }

        public String if_() {
            return this.dialect.getKeyword(Keywords.IF);
        }

        public String exists() {
            return this.dialect.getKeyword(Keywords.EXISTS);
        }

        public String comment() {
            return this.dialect.getKeyword(Keywords.COMMENT);
        }

        public String primary() {
            return this.dialect.getKeyword(Keywords.PRIMARY);
        }

        public String key() {
            return this.dialect.getKeyword(Keywords.KEY);
        }

        public String constraint() {
            return this.dialect.getKeyword(Keywords.CONSTRAINT);
        }

        public String cascade() {
            return this.dialect.getKeyword(Keywords.CASCADE);
        }
    }
}

