/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml.basic;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.model.ColumnElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.repository.operate.SortOperator;
import java.util.ArrayList;
import java.util.List;

public class SqlOrderByBasicBuilder
implements SqlBuilder {
    private Dialect dialect;
    private List<Order> orderParams = new ArrayList<Order>();

    public SqlOrderByBasicBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public SqlOrderByBasicBuilder addOrder(String name, String tableAlias, SortOperator operator) {
        this.addOrderBy(name, tableAlias, operator);
        return this;
    }

    public SqlOrderByBasicBuilder addAsc(String name, String tableAlias) {
        return this.addOrder(name, tableAlias, SortOperator.ASC);
    }

    public SqlOrderByBasicBuilder addDesc(String name, String tableAlias) {
        return this.addOrder(name, tableAlias, SortOperator.DESC);
    }

    public SqlOrderByBasicBuilder addAsc(String name) {
        return this.addAsc(name, null);
    }

    public SqlOrderByBasicBuilder addDesc(String name) {
        return this.addDesc(name, null);
    }

    public SqlOrderByBasicBuilder clear() {
        this.orderParams.clear();
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        if (this.orderParams.size() > 0) {
            sb.append(" ").append(this.dialect.getKeywords().orderBy());
        }
        for (Order orderParam : this.orderParams) {
            sb.append(orderParam).append(",");
        }
        if (this.orderParams.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getName() + " : " + this.build();
    }

    private void addOrderBy(String columnName, String tableAlias, SortOperator orderOperator) {
        Order orderParam = null;
        if (this.orderParams.isEmpty()) {
            orderParam = new Order(this.dialect, orderOperator);
            this.orderParams.add(orderParam);
        } else {
            orderParam = this.orderParams.get(this.orderParams.size() - 1);
            if (!orderParam.isOrderOperator(orderOperator)) {
                orderParam = new Order(this.dialect, orderOperator);
                this.orderParams.add(orderParam);
            }
        }
        orderParam.addParam(new ColumnElement(this.dialect, columnName, tableAlias));
    }

    public static class Order {
        private SortOperator sortOrerator;
        private Dialect dialect;
        private List<ColumnElement> params = new ArrayList<ColumnElement>();

        public Order(Dialect dialect, SortOperator sortOperator) {
            this.sortOrerator = sortOperator;
            this.dialect = dialect;
        }

        public void addParam(String param) {
            this.params.add(new ColumnElement(this.dialect, param));
        }

        public void addParam(ColumnElement param) {
            this.params.add(param);
        }

        public boolean isOrderOperator(SortOperator orderOperator) {
            return this.sortOrerator == orderOperator;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ColumnElement column : this.params) {
                sb.append(" ").append(column.toSql()).append(",");
            }
            if (this.params.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(" ").append(this.dialect.getKeyword(this.sortOrerator));
            }
            return sb.toString();
        }
    }
}

