/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.model;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.lang.Lang;
import java.sql.SQLType;

public abstract class AbstractColumn
implements Column {
    protected String name;
    protected SQLType sqlType;
    protected int type;
    protected String typeName;
    protected int size;
    protected String remark = "";
    protected String defaultValue;
    protected boolean nullable = true;
    protected int columnIndex;
    protected boolean primaryKey;
    protected int decimalDigits;
    protected boolean autoincrement;
    protected Table table;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoincrement ? 1231 : 1237);
        result = 31 * result + this.decimalDigits;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + (this.primaryKey ? 1231 : 1237);
        result = 31 * result + (this.remark == null ? 0 : this.remark.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + (this.sqlType == null ? 0 : this.sqlType.hashCode());
        result = 31 * result + this.type;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        if (this.table != null && Lang.isNotEmpty((String)this.table.getName())) {
            result = 31 * result + this.table.getName().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column other = (Column)obj;
        if (this.autoincrement != other.isAutoincrement()) {
            return false;
        }
        if (this.decimalDigits != other.getDecimalDigits()) {
            return false;
        }
        if (!Lang.equals((Object)this.defaultValue, (Object)other.getDefaultValue())) {
            return false;
        }
        if (!Lang.equals((Object)this.name, (Object)other.getName())) {
            return false;
        }
        if (this.nullable != other.isNullable()) {
            return false;
        }
        if (this.primaryKey != other.isPrimaryKey()) {
            return false;
        }
        if (!Lang.equals((Object)this.remark, (Object)other.getRemark())) {
            return false;
        }
        if (this.size != other.getSize()) {
            return false;
        }
        if (!Lang.equals((Object)this.sqlType, (Object)other.getSqlType())) {
            return false;
        }
        if (this.type != other.getType()) {
            return false;
        }
        if (!Lang.equals((Object)this.typeName, (Object)other.getTypeName())) {
            return false;
        }
        return this.table == null || !Lang.isNotEmpty((String)this.table.getName()) || Lang.equals((Object)this.table.getName(), (Object)other.getTable().getName());
    }

    public String toString() {
        return "Column [name=" + this.name + ", sqlType=" + this.sqlType + ", type=" + this.type + ", typeName=" + this.typeName + ", size=" + this.size + ", remark=" + this.remark + ", defaultValue=" + this.defaultValue + ", nullable=" + this.nullable + ", columnIndex=" + this.columnIndex + ", primaryKey=" + this.primaryKey + ", decimalDigits=" + this.decimalDigits + ", autoincrement=" + this.autoincrement + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    @Override
    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    @Override
    public SQLType getSqlType() {
        return this.sqlType;
    }

    @Override
    public Table getTable() {
        return this.table;
    }
}

