/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.migration;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.SqlExecutor;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.db.migration.ModifyTable;
import cn.featherfly.common.db.migration.UpdateMapping;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Index;
import cn.featherfly.common.repository.mapping.ClassMapping;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrator.class);
    private Dialect dialect;
    private SqlExecutor sqlExecutor;
    private SqlTypeMappingManager sqlTypeMappingManager;
    private String schema;

    public Migrator(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(dataSource, dialect, sqlTypeMappingManager, true);
    }

    public Migrator(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, boolean generateSchema) {
        this(dataSource, dialect, sqlTypeMappingManager, generateSchema, dialect.getDefaultSchema(JdbcUtils.getCatalog(dataSource)));
    }

    public Migrator(DataSource dataSource, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, boolean generateSchema, String schema) {
        this.dialect = dialect;
        this.sqlTypeMappingManager = sqlTypeMappingManager;
        this.sqlExecutor = new SqlExecutor(dataSource);
        if (generateSchema) {
            this.schema = schema;
        }
    }

    public String initSql(Set<ClassMapping<?>> classMappings) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.dialect.getInitSqlHeader()).append(";").append("\n");
        for (ClassMapping<?> classMapping : classMappings) {
            sql.append(this.createSql(classMapping, true)).append(";").append("\n");
        }
        sql.append(this.dialect.getInitSqlFooter()).append(";").append("\n");
        String result = sql.toString();
        if (Lang.isEmpty((String)this.schema)) {
            LOGGER.debug("create init sql -> \n{}", (Object)result);
        } else {
            LOGGER.debug("create init sql for {} -> \n{}", (Object)this.schema, (Object)result);
        }
        return result;
    }

    public String createSql(ClassMapping<?> classMapping) {
        return this.createSql(classMapping, false);
    }

    public String createSql(ClassMapping<?> classMapping, boolean dropIfExists) {
        return this.createSql(ClassMappingUtils.createTable(classMapping, this.dialect, this.sqlTypeMappingManager), dropIfExists, classMapping.getType());
    }

    private String createSql(Table table, boolean dropIfExists, Class<?> type) {
        StringBuilder sql = new StringBuilder();
        if (dropIfExists) {
            this.appendSqlWithEnd(sql, this.dialect.buildDropTableDDL(this.schema, table.getName(), true));
        }
        String result = sql.append(this.dialect.buildCreateTableDDL(table)).toString();
        LOGGER.debug("create sql for entity {} -> \n{}", (Object)type.getName(), (Object)result);
        return result;
    }

    public void create(Set<ClassMapping<?>> classMappings) {
        this.sqlExecutor.execute(this.initSql(classMappings));
    }

    public String updateSql(Set<ClassMapping<?>> classMappings) {
        return this.updateSql(classMappings, ModifyType.MODIFY, false);
    }

    public String updateSql(Set<ClassMapping<?>> classMappings, ModifyType modifyType, boolean dropNoMapping) {
        return this.updateSql(classMappings, modifyType, dropNoMapping, modifyType, dropNoMapping, dropNoMapping);
    }

    public String updateSql(Set<ClassMapping<?>> classMappings, ModifyType tableModifyType, boolean dropNoMappingTable, ModifyType columnModifyType, boolean dropNoMappingColumn, boolean dropNoMappingIndex, DatabaseMetadata databaseMetadata) {
        ModifyTable modifyTable;
        UpdateMapping updateMapping = new UpdateMapping();
        HashSet<String> tableNameSet = new HashSet<String>();
        for (ClassMapping<?> classMapping2 : classMappings) {
            Table table2 = databaseMetadata.getTable(classMapping2.getRepositoryName());
            Table table22 = ClassMappingUtils.createTable(classMapping2, this.dialect, this.sqlTypeMappingManager);
            tableNameSet.add(table22.getName());
            if (table2 == null) {
                updateMapping.newClassMappings.put(classMapping2, table22);
                continue;
            }
            if (table2.equals(table22)) continue;
            modifyTable = updateMapping.modifyTables.getModifyTable(table22);
            if (modifyTable == null) {
                modifyTable = new ModifyTable(table22, classMapping2);
                updateMapping.modifyTables.put(modifyTable);
            }
            for (Column column : table22.getColumns()) {
                Column columnMetadata = table2.getColumn(column.getName());
                if (columnMetadata == null) {
                    modifyTable.newColumns.put(classMapping2.getPropertyMappingByPersitField(column.getName()), column);
                    continue;
                }
                if (columnMetadata.equals(column)) continue;
                modifyTable.modifyColumns.put(classMapping2.getPropertyMappingByPersitField(column.getName()), column);
            }
            for (Column columnMetadata : table2.getColumns()) {
                if (table22.getColumn(columnMetadata.getName()) != null) continue;
                modifyTable.noMappingColumns.add(columnMetadata);
            }
            for (Index index : table22.getIndexs()) {
                Index indexMetadata = table2.getIndex(index.getName());
                if (indexMetadata == null) {
                    modifyTable.addIndexs.add(index);
                    continue;
                }
                if (indexMetadata.equals((Object)index)) continue;
                modifyTable.dropIndexs.add(indexMetadata);
                modifyTable.addIndexs.add(index);
            }
            for (Index indexMetadata : table2.getIndexs()) {
                if (table22.hasIndex(indexMetadata.getName())) continue;
                modifyTable.noMappingIndexs.add(indexMetadata);
            }
        }
        for (Table table3 : databaseMetadata.getTables()) {
            if (tableNameSet.contains(table3.getName())) continue;
            updateMapping.noMappingTables.add(table3);
        }
        StringBuilder sql = new StringBuilder();
        sql.append(this.dialect.getInitSqlHeader()).append(";").append("\n");
        updateMapping.newClassMappings.forEach((classMapping, table) -> this.appendSqlWithEnd(sql, this.createSql((Table)table, true, classMapping.getType())));
        for (Map.Entry<Table, ModifyTable> entry : updateMapping.modifyTables.modifyTableMap.entrySet()) {
            Table table4 = entry.getKey();
            modifyTable = entry.getValue();
            if (ModifyType.MODIFY == tableModifyType) {
                ArrayList<Column> dropColumns = new ArrayList<Column>();
                ArrayList<Index> dropIndex = new ArrayList<Index>();
                if (dropNoMappingColumn) {
                    dropColumns.addAll(modifyTable.noMappingColumns);
                }
                dropIndex.addAll(modifyTable.dropIndexs);
                if (dropNoMappingIndex) {
                    dropIndex.addAll(modifyTable.noMappingIndexs);
                }
                for (Index index : dropIndex) {
                    this.appendSqlWithEnd(sql, this.dialect.buildDropIndexDDL(table4.getSchema(), table4.getName(), index.getName()));
                }
                if (ModifyType.MODIFY == columnModifyType) {
                    this.appendSqlWithEnd(sql, this.dialect.buildAlterTableDDL(this.schema, table4.getName(), (Column[])CollectionUtils.toArray(modifyTable.newColumns.values(), Column.class), (Column[])CollectionUtils.toArray(modifyTable.modifyColumns.values(), Column.class), (Column[])CollectionUtils.toArray(dropColumns, Column.class)));
                } else if (ModifyType.DROP_AND_CREATE == columnModifyType) {
                    dropColumns.addAll(modifyTable.modifyColumns.values());
                    this.appendSqlWithEnd(sql, this.dialect.buildAlterTableDropColumnDDL(this.schema, table4.getName(), (Column[])CollectionUtils.toArray(dropColumns, Column.class)));
                    ArrayList<Column> addColumns = new ArrayList<Column>();
                    addColumns.addAll(modifyTable.newColumns.values());
                    addColumns.addAll(modifyTable.modifyColumns.values());
                    this.appendSqlWithEnd(sql, this.dialect.buildAlterTableDDL(this.schema, table4.getName(), (Column[])CollectionUtils.toArray(addColumns, Column.class), new Column[0], (Column[])CollectionUtils.toArray(dropColumns, Column.class)));
                } else {
                    throw new JdbcMappingException("no support ModifyType for columnModifyType -> " + columnModifyType);
                }
                for (Index index : modifyTable.addIndexs) {
                    this.appendSqlWithEnd(sql, this.dialect.buildCreateIndexDDL(table4.getSchema(), table4.getName(), index.getName(), index.getColumns()));
                }
                continue;
            }
            if (ModifyType.DROP_AND_CREATE == tableModifyType) {
                this.appendSqlWithEnd(sql, this.createSql(modifyTable.classMapping, true));
                continue;
            }
            throw new JdbcMappingException("no support ModifyType for tableModifyType -> " + tableModifyType);
        }
        if (dropNoMappingTable) {
            updateMapping.noMappingTables.forEach(table -> this.appendSqlWithEnd(sql, this.dialect.buildDropTableDDL(this.schema, table.getName())));
        }
        sql.append(this.dialect.getInitSqlFooter()).append(";").append("\n");
        String string = sql.toString();
        if (Lang.isEmpty((String)this.schema)) {
            LOGGER.debug("create update sql -> \n{}", (Object)string);
        } else {
            LOGGER.debug("create update sql for {} -> \n{}", (Object)this.schema, (Object)string);
        }
        return string;
    }

    public String updateSql(Set<ClassMapping<?>> classMappings, ModifyType tableModifyType, boolean dropNoMappingTable, ModifyType columnModifyType, boolean dropNoMappingColumn, boolean dropNoMappingIndex) {
        return this.updateSql(classMappings, tableModifyType, dropNoMappingTable, columnModifyType, dropNoMappingColumn, dropNoMappingIndex, DatabaseMetadataManager.getDefaultManager().create(this.sqlExecutor.getDataSource()));
    }

    public void update(Set<ClassMapping<?>> classMappings) {
        this.sqlExecutor.execute(this.updateSql(classMappings));
    }

    public void update(Set<ClassMapping<?>> classMappings, ModifyType tableModifyType, boolean dropTableNotMapping, ModifyType columnModifyType, boolean dropColumnNotMapping, boolean dropIndexNotMapping) {
        this.sqlExecutor.execute(this.updateSql(classMappings, tableModifyType, dropTableNotMapping, columnModifyType, dropColumnNotMapping, dropIndexNotMapping));
    }

    private StringBuilder appendSqlWithEnd(StringBuilder sql, String appendSql) {
        if (Lang.isNotEmpty((String)appendSql)) {
            sql.append(appendSql);
            if (!appendSql.endsWith(";")) {
                sql.append(";");
            }
            return sql.append("\n");
        }
        return sql;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public SqlTypeMappingManager getSqlTypeMappingManager() {
        return this.sqlTypeMappingManager;
    }

    public String getSchema() {
        return this.schema;
    }

    public static enum ModifyType {
        MODIFY,
        DROP_AND_CREATE;

    }
}

