/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping.mappers;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.AbstractJavaSqlTypeMapper;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;

public class ObjectToJsonMapper<E extends Serializable>
extends AbstractJavaSqlTypeMapper<E> {
    private ObjectMapper objectMapper;

    public ObjectToJsonMapper(Class<E> type) {
        this((GenericType<E>)new GenericClass(type));
    }

    public ObjectToJsonMapper(Class<E> type, ObjectMapper objectMapper) {
        this((GenericType<E>)new GenericClass(type), objectMapper);
    }

    public ObjectToJsonMapper(GenericType<E> type) {
        this(type, new ObjectMapper());
    }

    public ObjectToJsonMapper(GenericType<E> type, ObjectMapper objectMapper) {
        super(type);
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean support(SQLType sqlType) {
        return sqlType == JDBCType.VARCHAR || sqlType == JDBCType.NVARCHAR || sqlType == JDBCType.LONGVARBINARY || sqlType == JDBCType.LONGNVARCHAR || sqlType == JDBCType.CLOB || sqlType == JDBCType.BLOB || sqlType == JDBCType.NCLOB || sqlType == JDBCType.JAVA_OBJECT;
    }

    @Override
    public Class<E> getJavaType(SQLType sqlType) {
        return this.getGenericType().getType();
    }

    @Override
    public SQLType getSqlType(GenericType<E> javaType) {
        return JDBCType.VARCHAR;
    }

    @Override
    public void set(PreparedStatement prep, int columnIndex, E value) {
        try {
            String json = this.objectMapper.writerFor(this.getGenericType().getClass()).writeValueAsString(value);
            prep.setString(columnIndex, json);
        }
        catch (JsonProcessingException | SQLException e) {
            throw new JdbcException(e);
        }
    }

    @Override
    public E get(ResultSet rs, int columnIndex) {
        try {
            String json = rs.getString(columnIndex);
            return (E)((Serializable)this.objectMapper.readerFor(this.getGenericType().getClass()).readValue(json));
        }
        catch (JsonProcessingException | SQLException e) {
            throw new JdbcException(e);
        }
    }
}

