/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ObjectDbMixedMappingFactory;
import cn.featherfly.common.db.mapping.ObjectToDbMappingFactory;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.ClassNameConversion;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyNameConversion;
import java.util.List;

public class JdbcMappingFactory
implements MappingFactory {
    private MappingFactory factory;

    public JdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect) {
        this(metadata, dialect, new SqlTypeMappingManager());
    }

    public JdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(metadata, dialect, sqlTypeMappingManager, null, null);
    }

    public JdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(metadata, dialect, new SqlTypeMappingManager(), classNameConversions, propertyNameConversions);
    }

    public JdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(MappingMode.OBJ_DB_MIXED, metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions);
    }

    public JdbcMappingFactory(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect) {
        this(mappingMode, metadata, dialect, new SqlTypeMappingManager());
    }

    public JdbcMappingFactory(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        this(mappingMode, metadata, dialect, sqlTypeMappingManager, null, null);
    }

    public JdbcMappingFactory(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this(mappingMode, metadata, dialect, new SqlTypeMappingManager(), classNameConversions, propertyNameConversions);
    }

    public JdbcMappingFactory(MappingMode mappingMode, DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this.factory = mappingMode == MappingMode.OBJ_TO_DB ? new ObjectToDbMappingFactory(metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions) : new ObjectDbMixedMappingFactory(metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions);
    }

    public <T> ClassMapping<T> getClassMapping(Class<T> type) {
        return this.factory.getClassMapping(type);
    }

    public static enum MappingMode {
        OBJ_DB_MIXED,
        OBJ_TO_DB;

    }
}

