/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.mapping.JdbcMappingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class DefaultSqlTypeMapping {
    private static final Map<Class<? extends Object>, SQLType> JAVA_TO_SQL_MAP = new HashMap<Class<? extends Object>, SQLType>();
    private static final Map<SQLType, Class<? extends Object>> SQL_TO_JAVA_MAP = new HashMap<SQLType, Class<? extends Object>>();
    private boolean enumWithOrdinal;
    private SQLType enumOrdinalType = JDBCType.TINYINT;

    public <E> SQLType getSqlType(Class<E> javaType) {
        if (javaType.isEnum()) {
            if (this.enumWithOrdinal) {
                return this.enumOrdinalType;
            }
            return JDBCType.VARCHAR;
        }
        return JAVA_TO_SQL_MAP.get(javaType);
    }

    public <E> Class<E> getJavaType(SQLType sqlType) {
        return SQL_TO_JAVA_MAP.get(sqlType);
    }

    public boolean isEnumWithOrdinal() {
        return this.enumWithOrdinal;
    }

    public void setEnumWithOrdinal(boolean enumWithOrdinal) {
        this.enumWithOrdinal = enumWithOrdinal;
    }

    public SQLType getEnumOrdinalType() {
        return this.enumOrdinalType;
    }

    public void setEnumOrdinalType(SQLType enumOrdinalType) {
        if (enumOrdinalType != JDBCType.TINYINT && enumOrdinalType != JDBCType.SMALLINT && enumOrdinalType != JDBCType.INTEGER) {
            throw new JdbcMappingException("enumWithOrdinal only can be JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER");
        }
        this.enumOrdinalType = enumOrdinalType;
    }

    static {
        JAVA_TO_SQL_MAP.put(Boolean.TYPE, JDBCType.BOOLEAN);
        JAVA_TO_SQL_MAP.put(Boolean.class, JDBCType.BOOLEAN);
        JAVA_TO_SQL_MAP.put(Character.TYPE, JDBCType.CHAR);
        JAVA_TO_SQL_MAP.put(Character.class, JDBCType.CHAR);
        JAVA_TO_SQL_MAP.put(Byte.TYPE, JDBCType.TINYINT);
        JAVA_TO_SQL_MAP.put(Byte.class, JDBCType.TINYINT);
        JAVA_TO_SQL_MAP.put(Short.TYPE, JDBCType.SMALLINT);
        JAVA_TO_SQL_MAP.put(Short.class, JDBCType.SMALLINT);
        JAVA_TO_SQL_MAP.put(Integer.TYPE, JDBCType.INTEGER);
        JAVA_TO_SQL_MAP.put(Integer.class, JDBCType.INTEGER);
        JAVA_TO_SQL_MAP.put(Long.TYPE, JDBCType.BIGINT);
        JAVA_TO_SQL_MAP.put(Long.class, JDBCType.BIGINT);
        JAVA_TO_SQL_MAP.put(BigInteger.class, JDBCType.BIGINT);
        JAVA_TO_SQL_MAP.put(Float.TYPE, JDBCType.DECIMAL);
        JAVA_TO_SQL_MAP.put(Float.class, JDBCType.DECIMAL);
        JAVA_TO_SQL_MAP.put(Double.TYPE, JDBCType.DECIMAL);
        JAVA_TO_SQL_MAP.put(Double.class, JDBCType.DECIMAL);
        JAVA_TO_SQL_MAP.put(BigDecimal.class, JDBCType.DECIMAL);
        JAVA_TO_SQL_MAP.put(String.class, JDBCType.VARCHAR);
        JAVA_TO_SQL_MAP.put(java.util.Date.class, JDBCType.TIMESTAMP);
        JAVA_TO_SQL_MAP.put(LocalDate.class, JDBCType.DATE);
        JAVA_TO_SQL_MAP.put(LocalTime.class, JDBCType.TIME);
        JAVA_TO_SQL_MAP.put(LocalDateTime.class, JDBCType.TIMESTAMP);
        JAVA_TO_SQL_MAP.put(Date.class, JDBCType.DATE);
        JAVA_TO_SQL_MAP.put(Time.class, JDBCType.TIME);
        JAVA_TO_SQL_MAP.put(Timestamp.class, JDBCType.TIMESTAMP);
        JAVA_TO_SQL_MAP.put(byte[].class, JDBCType.VARBINARY);
        JAVA_TO_SQL_MAP.put(Byte[].class, JDBCType.VARBINARY);
        SQL_TO_JAVA_MAP.put(JDBCType.BOOLEAN, Boolean.TYPE);
        SQL_TO_JAVA_MAP.put(JDBCType.CHAR, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.NCHAR, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.VARCHAR, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.NVARCHAR, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.LONGVARCHAR, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.LONGNVARCHAR, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.CLOB, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.NCLOB, String.class);
        SQL_TO_JAVA_MAP.put(JDBCType.TINYINT, Integer.class);
        SQL_TO_JAVA_MAP.put(JDBCType.SMALLINT, Integer.class);
        SQL_TO_JAVA_MAP.put(JDBCType.INTEGER, Integer.class);
        SQL_TO_JAVA_MAP.put(JDBCType.BIGINT, Long.class);
        SQL_TO_JAVA_MAP.put(JDBCType.FLOAT, BigDecimal.class);
        SQL_TO_JAVA_MAP.put(JDBCType.DOUBLE, BigDecimal.class);
        SQL_TO_JAVA_MAP.put(JDBCType.REAL, BigDecimal.class);
        SQL_TO_JAVA_MAP.put(JDBCType.NUMERIC, BigDecimal.class);
        SQL_TO_JAVA_MAP.put(JDBCType.DECIMAL, BigDecimal.class);
        SQL_TO_JAVA_MAP.put(JDBCType.DATE, java.util.Date.class);
        SQL_TO_JAVA_MAP.put(JDBCType.TIME, java.util.Date.class);
        SQL_TO_JAVA_MAP.put(JDBCType.TIMESTAMP, java.util.Date.class);
        SQL_TO_JAVA_MAP.put(JDBCType.TIME_WITH_TIMEZONE, LocalTime.class);
        SQL_TO_JAVA_MAP.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, LocalDateTime.class);
        SQL_TO_JAVA_MAP.put(JDBCType.BLOB, byte[].class);
        SQL_TO_JAVA_MAP.put(JDBCType.BINARY, byte[].class);
        SQL_TO_JAVA_MAP.put(JDBCType.LONGVARBINARY, byte[].class);
        SQL_TO_JAVA_MAP.put(JDBCType.VARBINARY, byte[].class);
        SQL_TO_JAVA_MAP.put(JDBCType.BIT, Boolean.class);
    }
}

