/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.AbstractDialect;
import cn.featherfly.common.db.dialect.DialectException;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.Date;

public class PostgreSQLDialect
extends AbstractDialect {
    public PostgreSQLDialect() {
        this.setTableAndColumnNameUppercase(false);
    }

    @Override
    public String getPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, false, ':');
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit) {
        return this.getParamNamedPaginationSql(sql, start, limit, ':');
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit, char startSymbol) {
        return this.getPaginationSql(sql, start, true, startSymbol);
    }

    @Override
    public Object[] getPaginationSqlParameter(Object[] params, int start, int limit) {
        Object[] pagingParams = null;
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            pagingParams = new Object[]{limit, start};
        } else {
            this.logger.debug("start < 0 , don't use start");
            pagingParams = new Object[]{limit};
        }
        return (Object[])ArrayUtils.concat((Object)params, (Object)pagingParams);
    }

    private String getPaginationSql(String sql, int start, boolean isParamNamed, char startSymbol) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (this.isForUpdate(sql)) {
            sql = sql.substring(0, sql.length() - " for update".length());
            isForUpdate = true;
        }
        int sqlLengthOffset = 50;
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 50);
        pagingSelect.append(sql);
        if (isParamNamed) {
            if (start > 0) {
                pagingSelect.append(Strings.format((String)" LIMIT {0}{1} OFFSET {0}{2}", (Object[])Lang.array((Object[])new Object[]{Character.valueOf(startSymbol), "dialect_paging_limit", "dialect_paging_start"})));
            } else {
                pagingSelect.append(Strings.format((String)" LIMIT {0}{1}", (Object[])Lang.array((Object[])new Object[]{Character.valueOf(startSymbol), "dialect_paging_limit"})));
            }
        } else if (start > 0) {
            pagingSelect.append(" LIMIT ? OFFSET ?");
        } else {
            pagingSelect.append(" LIMIT ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        this.logger.debug("\u539f\u59cbSql\uff1a{}", (Object)sql);
        this.logger.debug("\u5206\u9875Sql\uff1a{}", (Object)pagingSelect);
        return pagingSelect.toString();
    }

    @Override
    public String convertValueToSql(Object value, int sqlType) {
        StringBuilder sqlPart = new StringBuilder();
        if (value == null) {
            sqlPart.append("null");
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    sqlPart.append(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        sqlPart.append("'").append(Dates.formatTime((Date)((Date)value))).append("'");
                        break;
                    }
                    sqlPart.append("'").append(value).append("'");
                    break;
                }
                default: {
                    sqlPart.append("'").append(SqlUtils.transferStringForSql(value.toString())).append("'");
                }
            }
        }
        return sqlPart.toString();
    }

    @Override
    public String wrapName(String name) {
        if (Lang.isNotEmpty((String)name)) {
            return this.getWrapSign() + name + this.getWrapSign();
        }
        return name;
    }

    @Override
    public String getWrapSign() {
        return "\"";
    }

    @Override
    public String buildCreateTableDDL(Table table) {
        StringBuilder comments = new StringBuilder();
        for (Column column : table.getColumns()) {
            if (!Lang.isNotEmpty((String)column.getRemark())) continue;
            StringBuilder comment = new StringBuilder();
            String columnName = this.wrapName(table.getName()) + "." + this.wrapName(column.getName());
            if (Lang.isNotEmpty((String)table.getSchema())) {
                columnName = this.wrapName(table.getSchema()) + "." + columnName;
            }
            BuilderUtils.link(comment, this.getKeyword(Keywords.COMMENT), this.getKeyword(Keywords.ON), this.getKeyword(Keywords.COLUMN), columnName, this.getKeyword(Keywords.IS), "'" + column.getRemark() + "'");
            comment.append(";").append("\n");
            comments.append((CharSequence)comment);
        }
        Object result = super.buildCreateTableDDL(table);
        if (comments.length() > 0) {
            comments.deleteCharAt(comments.length() - 1);
            result = (String)result + ";\n" + comments.toString();
        }
        return result;
    }

    @Override
    protected String getTableComment(Table table) {
        return Lang.isEmpty((String)table.getRemark()) ? "" : BuilderUtils.link(";\n" + this.getKeyword(Keywords.COMMENT), this.getKeyword(Keywords.ON), this.getKeyword(Keywords.TABLE), (String)Lang.ifEmpty((Object)table.getSchema(), () -> this.wrapName(table.getName()), () -> this.wrapName(table.getSchema()) + "." + this.wrapName(table.getName())), this.getKeyword(Keywords.IS), "'" + table.getRemark() + "'");
    }

    @Override
    protected String getPrimaryKeyDDL(Table table) {
        StringBuilder result = new StringBuilder("(");
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            result.append(this.wrapName(column.getName())).append(".");
        }
        result.deleteCharAt(result.length() - 1);
        result.append(")");
        return BuilderUtils.link(this.getKeyword(Keywords.CONSTRAINT), this.wrapName(table.getName() + "_pkey"), this.getKeyword(Keywords.PRIMARY), this.getKeyword(Keywords.KEY), result.toString());
    }

    @Override
    protected String getColumnDDL(Column column) {
        if (column.isAutoincrement()) {
            return BuilderUtils.link(this.wrapName(column.getName()), this.getSerial(column.getSqlType()), this.getColumnNotNull(column));
        }
        return BuilderUtils.link(this.wrapName(column.getName()), this.getColumnTypeDDL(column), this.getColumnNotNull(column), this.getDefaultValue(column));
    }

    private String getSerial(SQLType sqlType) {
        JDBCType type = JDBCType.valueOf(sqlType.getVendorTypeNumber());
        switch (type) {
            case SMALLINT: {
                return "SERIAL2";
            }
            case INTEGER: {
                return "SERIAL4";
            }
            case BIGINT: {
                return "SERIAL8";
            }
        }
        throw new DialectException("serial only support for JDBCType.BIGINT, JDBCType.INTEGER, JDBCType.SMALLINT");
    }

    @Override
    public String getColumnTypeName(SQLType sqlType) {
        JDBCType type = JDBCType.valueOf(sqlType.getVendorTypeNumber());
        switch (type) {
            case TINYINT: {
                return "INT2";
            }
            case SMALLINT: {
                return "INT2";
            }
            case INTEGER: {
                return "INT4";
            }
            case BIGINT: {
                return "INT8";
            }
            case FLOAT: {
                return "FLOAT4";
            }
            case DOUBLE: {
                return "FLOAT8";
            }
        }
        return super.getColumnTypeName(sqlType);
    }

    @Override
    protected String getAutoIncrement(Column column) {
        throw new UnsupportedException();
    }

    @Override
    public String getInitSqlHeader() {
        throw new UnsupportedException();
    }

    @Override
    public String getInitSqlFooter() {
        throw new UnsupportedException();
    }
}

