/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml.basic;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.dialect.Join;

public class SqlJoinOnBasicBuilder
implements SqlBuilder {
    protected String tableAlias;
    protected String tableName;
    protected String columnName;
    protected String conditionTableAlias;
    protected String conditionColumn;
    protected Dialect dialect;
    protected Join join;

    public SqlJoinOnBasicBuilder(Dialect dialect, String tableName, String columnName, String conditionColumn) {
        this(dialect, null, tableName, columnName, conditionColumn);
    }

    public SqlJoinOnBasicBuilder(Dialect dialect, Join join, String tableName, String columnName, String conditionColumn) {
        this(dialect, join, tableName, null, columnName, null, conditionColumn);
    }

    public SqlJoinOnBasicBuilder(Dialect dialect, String tableName, String tableAlias, String columnName, String conditionTableAlias, String conditionColumn) {
        this(dialect, null, tableName, tableAlias, columnName, conditionTableAlias, conditionColumn);
    }

    public SqlJoinOnBasicBuilder(Dialect dialect, Join join, String tableName, String tableAlias, String columnName, String conditionTableAlias, String conditionColumn) {
        this.dialect = dialect;
        this.join = join == null ? Join.INNER_JOIN : join;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
        this.columnName = columnName;
        this.conditionTableAlias = conditionTableAlias;
        this.conditionColumn = conditionColumn;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String build() {
        StringBuilder joinSql = new StringBuilder();
        joinSql.append(this.dialect.getKeywords().join(this.join)).append(" ").append(this.dialect.buildTableSql(this.tableName, this.tableAlias)).append(" ").append(this.dialect.getKeywords().on()).append(" ").append(this.dialect.buildColumnSql(this.columnName, this.tableAlias)).append(" ").append("=").append(" ").append(this.dialect.buildColumnSql(this.conditionColumn, this.conditionTableAlias));
        return joinSql.toString();
    }
}

