/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.SimpleExecution;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SqlUtils {
    public static final char PARAM_NAME_START_SYMBOL = ':';
    private static final Pattern SELECT_PATTERN = Pattern.compile("((select )(distinct [\\w-_.]+)?,?.+)(from .+)", 34);

    private SqlUtils() {
    }

    public static String convertSelectToCount(String sql) {
        Matcher m = SELECT_PATTERN.matcher(sql = sql.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("[" + sql + "] \u4e0d\u662f\u67e5\u8be2SQL , \u67e5\u8be2SQL\u5e94\u8be5\u662f\u8fd9\u6837?[select xx from xxx ...]");
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(");
        String fromSql = sql.substring(m.group(1).length());
        String distinctColumn = null;
        int groupThree = 3;
        if (m.group(groupThree) != null) {
            distinctColumn = sql.substring(m.group(2).length(), m.group(2).length() + m.group(groupThree).length());
        }
        if (Lang.isEmpty(distinctColumn)) {
            countSql.append("*");
        } else {
            countSql.append(distinctColumn);
        }
        return countSql.append(") ").append(fromSql).toString();
    }

    public static String transferStringForSql(String str) {
        if (Lang.isEmpty((String)str)) {
            return str;
        }
        return str.replaceAll("[\\\\'\"]", "\\\\$0");
    }

    public static Execution convertNamedParamSql(String namedParamSql, Map<String, Object> params) {
        return SqlUtils.convertNamedParamSql(namedParamSql, params, ':');
    }

    public static Execution convertNamedParamSql(String namedParamSql, Map<String, Object> params, char startSymbol) {
        return SqlUtils.convertNamedParamSql(namedParamSql, params, startSymbol, null);
    }

    public static Execution convertNamedParamSql(String namedParamSql, Map<String, Object> params, char startSymbol, Character endSymbol) {
        AssertIllegalArgument.isNotEmpty((String)namedParamSql, (String)"namedParamSql");
        AssertIllegalArgument.isNotEmpty((Object)Character.valueOf(startSymbol), (String)"startSymbol");
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder(namedParamSql);
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        boolean emptySymbol = Lang.isEmpty((Object)endSymbol);
        char end = emptySymbol ? (char)' ' : (char)endSymbol.charValue();
        boolean isEnd = false;
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (startSymbol == c) {
                nameStartIndex = index;
            }
            if (nameStartIndex <= 0) continue;
            boolean bl = isEnd = index == sql.length() - 1;
            if (c != end && !isEnd) continue;
            nameEndIndex = index;
            if (isEnd && emptySymbol) {
                ++nameEndIndex;
            }
            String name = sql.substring(nameStartIndex + 1, nameEndIndex);
            Object param = SqlUtils.getNamedParam(params, name);
            list.add(param);
            if (!emptySymbol) {
                ++nameEndIndex;
            }
            sql.insert(nameEndIndex, '?');
            sql.delete(nameStartIndex, nameEndIndex);
            index -= nameEndIndex - nameStartIndex - 1;
            nameStartIndex = -1;
            nameEndIndex = -1;
        }
        return new SimpleExecution(sql.toString(), list.toArray());
    }

    private static Object getNamedParam(Map<String, Object> params, String name) {
        Object param = params.get(name);
        if (param == null) {
            throw new JdbcException("no param found for name -> " + name);
        }
        return param;
    }
}

