/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.DefaultSqlTypeMapping;
import cn.featherfly.common.db.mapping.JavaSqlTypeMapper;
import cn.featherfly.common.db.mapping.JavaToSqlTypeRegister;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeToJavaRegister;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.reflect.GenericClass;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuples;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTypeMappingManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DefaultSqlTypeMapping defaultSqlTypeMapping = new DefaultSqlTypeMapping();
    private Store globalStore = new Store();
    private Map<Class<?>, Store> typeStoreMap = new HashMap();

    public SqlTypeMappingManager regist(JavaToSqlTypeRegister<? extends Serializable> register) {
        AssertIllegalArgument.isNotNull(register, (String)"register");
        this.globalStore.put(register);
        return this;
    }

    public SqlTypeMappingManager regist(JavaSqlTypeMapper<? extends Serializable> mapper) {
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        this.globalStore.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(Class<?> entityType, JavaSqlTypeMapper<? extends Serializable> mapper) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        Store store = this.getStore(entityType);
        store.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(SqlTypeToJavaRegister<? extends Serializable> register) {
        AssertIllegalArgument.isNotNull(register, (String)"register");
        this.globalStore.put(register);
        return this;
    }

    public <E extends Serializable> SQLType getSqlType(Class<E> javaType) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        SQLType sqlType = this.globalStore.getSqlType(javaType);
        if (sqlType == null) {
            sqlType = this.defaultSqlTypeMapping.getSqlType(javaType);
        }
        return sqlType;
    }

    public <E extends Serializable> SQLType getSqlType(Class<E> entityType, Class<E> javaType) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        SQLType sqlType = null;
        Store store = this.typeStoreMap.get(entityType);
        if (store != null) {
            sqlType = store.getSqlType(javaType);
        }
        if (sqlType == null) {
            sqlType = this.getSqlType(javaType);
        }
        return sqlType;
    }

    public <E extends Serializable> Class<E> getJavaType(SQLType sqlType) {
        AssertIllegalArgument.isNotNull((Object)sqlType, (String)"sqlType");
        Class javaType = this.globalStore.getJavaType(sqlType);
        if (javaType == null) {
            javaType = this.defaultSqlTypeMapping.getJavaType(sqlType);
        }
        return javaType;
    }

    public <E extends Serializable> Class<E> getJavaType(Class<E> entityType, SQLType sqlType) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull((Object)sqlType, (String)"sqlType");
        Class<E> javaType = null;
        Store store = this.typeStoreMap.get(entityType);
        if (store != null) {
            javaType = store.getJavaType(sqlType);
        }
        if (javaType == null) {
            javaType = this.getJavaType(sqlType);
        }
        return javaType;
    }

    public <E extends Serializable> void set(PreparedStatement prep, int columnIndex, E columnValue) {
        Store store;
        AssertIllegalArgument.isNotNull((Object)prep, (String)"PreparedStatement");
        if (columnValue != null && (store = this.typeStoreMap.get(columnValue.getClass())) != null && store.set(prep, columnIndex, columnValue)) {
            return;
        }
        if (this.globalStore.set(prep, columnIndex, columnValue)) {
            return;
        }
        JdbcUtils.setParameter(prep, columnIndex, columnValue);
    }

    public <E extends Serializable> void set(E columnValue, int columnIndex, GenericType<E> javaType, PreparedStatement prep) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        AssertIllegalArgument.isNotNull((Object)prep, (String)"PreparedStatement");
        Store store = this.typeStoreMap.get(javaType.getType());
        if (store != null && store.set(prep, columnIndex, columnValue, javaType)) {
            return;
        }
        if (this.globalStore.set(prep, columnIndex, columnValue, javaType)) {
            return;
        }
        JdbcUtils.setParameter(prep, columnIndex, columnValue);
    }

    public <E extends Serializable> E get(ResultSet rs, int columnIndex, GenericType<E> javaType) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        AssertIllegalArgument.isNotNull((Object)rs, (String)"ResultSet");
        Store store = this.typeStoreMap.get(javaType.getType());
        E e = null;
        if (store != null) {
            E e2 = store.get(rs, columnIndex, javaType);
            e = e2;
            if (e2 != null) {
                return e;
            }
        }
        E e3 = this.globalStore.get(rs, columnIndex, javaType);
        e = e3;
        if (e3 != null) {
            return e;
        }
        return (E)((Serializable)JdbcUtils.getResultSetValue(rs, columnIndex, javaType.getType()));
    }

    public <E extends Serializable> E get(ResultSet rs, String columnName, GenericType<E> javaType) {
        AssertIllegalArgument.isNotEmpty((String)columnName, (String)"name");
        int index = JdbcUtils.getColumnIndex(rs, columnName);
        return this.get(rs, index, javaType);
    }

    private Store getStore(Class<?> entityType) {
        Store store = this.typeStoreMap.get(entityType);
        if (store == null) {
            store = new Store();
            this.typeStoreMap.put(entityType, store);
        }
        return store;
    }

    private class Store {
        private Map<GenericType<? extends Serializable>, JavaToSqlTypeRegister<? extends Serializable>> javaToSqlTypeRegisterMap = new HashMap<GenericType<? extends Serializable>, JavaToSqlTypeRegister<? extends Serializable>>();
        private Map<SQLType, Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>>> sqlTypeToJavaRegisterMap = new HashMap<SQLType, Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>>>();
        private List<JavaSqlTypeMapper<? extends Serializable>> javaSqlTypeMappers = new ArrayList<JavaSqlTypeMapper<? extends Serializable>>();

        private Store() {
        }

        private void add(JavaSqlTypeMapper<? extends Serializable> mapper) {
            this.javaSqlTypeMappers.add(mapper);
        }

        private void put(JavaToSqlTypeRegister<? extends Serializable> register) {
            GenericClass type = new GenericClass(register.getJavaType());
            JavaToSqlTypeRegister<? extends Serializable> oldRegister = null;
            oldRegister = this.javaToSqlTypeRegisterMap.get(type);
            if (oldRegister != null) {
                throw new JdbcMappingException("#java.type.registed", new Object[]{type.getType().getName(), oldRegister.getClass().getName(), oldRegister.getSqlType().getName()});
            }
            this.javaToSqlTypeRegisterMap.put((GenericType<? extends Serializable>)type, register);
            SqlTypeMappingManager.this.logger.debug("regist java type {} with sql type {}", (Object)type.getType().getName(), (Object)register.getSqlType().getName());
        }

        private void put(SqlTypeToJavaRegister<? extends Serializable> register) {
            Class type = register.getJavaType();
            Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>> oldRegister = null;
            oldRegister = this.sqlTypeToJavaRegisterMap.get(register.getSqlType());
            if (oldRegister != null) {
                throw new JdbcMappingException("#sql.type.registed", new Object[]{((SqlTypeToJavaRegister)oldRegister.get0()).getSqlType().getName(), ((SqlTypeToJavaRegister)oldRegister.get0()).getClass().getName(), ((Class)oldRegister.get1()).getName()});
            }
            this.sqlTypeToJavaRegisterMap.put(register.getSqlType(), (Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>>)Tuples.of(register, type));
            SqlTypeMappingManager.this.logger.debug("regist java type {} with sql type {}", (Object)type.getName(), (Object)register.getSqlType().getName());
        }

        private <E extends Serializable> SQLType getSqlType(Class<E> javaType) {
            return this.getSqlType((GenericType<E>)new GenericClass(javaType));
        }

        private <E extends Serializable> SQLType getSqlType(GenericType<E> javaType) {
            for (JavaSqlTypeMapper<? extends Serializable> javaSqlTypeMapper : this.javaSqlTypeMappers) {
                SQLType sqlType;
                JavaSqlTypeMapper<? extends Serializable> mapper = javaSqlTypeMapper;
                if (!mapper.support(javaType) || (sqlType = javaSqlTypeMapper.getSqlType(javaType)) == null) continue;
                return sqlType;
            }
            JavaToSqlTypeRegister<? extends Serializable> register = this.javaToSqlTypeRegisterMap.get(javaType);
            if (register != null) {
                return register.getSqlType();
            }
            return null;
        }

        public <E extends Serializable> boolean set(PreparedStatement prep, int columnIndex, E columnValue) {
            if (columnValue == null) {
                JdbcUtils.setParameter(prep, columnIndex, columnValue);
                return true;
            }
            return this.set(prep, columnIndex, columnValue, (GenericType<E>)new GenericClass(columnValue.getClass()));
        }

        public <E extends Serializable> boolean set(PreparedStatement prep, int columnIndex, E columnValue, GenericType<E> javaType) {
            if (columnValue == null) {
                JdbcUtils.setParameter(prep, columnIndex, columnValue);
                return true;
            }
            for (JavaSqlTypeMapper<? extends Serializable> javaSqlTypeMapper : this.javaSqlTypeMappers) {
                SQLType sqlType;
                if (!javaSqlTypeMapper.support(javaType) || (sqlType = javaSqlTypeMapper.getSqlType(javaType)) == null) continue;
                javaSqlTypeMapper.set(prep, columnIndex, columnValue);
                return true;
            }
            return false;
        }

        public <E extends Serializable> E get(ResultSet rs, int columnIndex, GenericType<E> javaType) {
            SQLType sqlType = JdbcUtils.getResultSQLType(rs, columnIndex);
            for (JavaSqlTypeMapper<? extends Serializable> sqlTypeToJavaMapper : this.javaSqlTypeMappers) {
                JavaSqlTypeMapper<? extends Serializable> mapper = sqlTypeToJavaMapper;
                if (!mapper.support(sqlType) || !mapper.support(javaType)) continue;
                return (E)mapper.get(rs, columnIndex);
            }
            return null;
        }

        private <E extends Serializable> Class<E> getJavaType(SQLType sqlType) {
            for (JavaSqlTypeMapper<? extends Serializable> sqlTypeToJavaMapper : this.javaSqlTypeMappers) {
                Class<? extends Serializable> type;
                if (!sqlTypeToJavaMapper.support(sqlType) || (type = sqlTypeToJavaMapper.getJavaType(sqlType)) == null) continue;
                return type;
            }
            Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>> tuple = this.sqlTypeToJavaRegisterMap.get(sqlType);
            if (tuple != null) {
                return (Class)tuple.get1();
            }
            return null;
        }
    }
}

