/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.AbstractDialect;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.Date;

public class SQLiteDialect
extends AbstractDialect {
    public static final String TEXT_TYPE = "TEXT";

    @Override
    public String getPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, false);
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, true);
    }

    private String getPaginationSql(String sql, int start, boolean isParamNamed) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (this.isForUpdate(sql)) {
            sql = sql.substring(0, sql.length() - " for update".length());
            isForUpdate = true;
        }
        int sqlLengthOffset = 50;
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 50);
        pagingSelect.append(sql);
        if (isParamNamed) {
            if (start > 0) {
                pagingSelect.append(String.format(" LIMIT :%s,:%s", "dialect_paging_start", "dialect_paging_limit"));
            } else {
                pagingSelect.append(String.format(" LIMIT :%s", "dialect_paging_limit"));
            }
        } else if (start > 0) {
            pagingSelect.append(" LIMIT ?,?");
        } else {
            pagingSelect.append(" LIMIT ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        this.logger.debug("\u539f\u59cbSql\uff1a{}", (Object)sql);
        this.logger.debug("\u5206\u9875Sql\uff1a{}", (Object)pagingSelect);
        return pagingSelect.toString();
    }

    @Override
    public String convertValueToSql(Object value, int sqlType) {
        StringBuilder sqlPart = new StringBuilder();
        if (value == null) {
            sqlPart.append("null");
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    sqlPart.append(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        sqlPart.append("'").append(Dates.formatTime((Date)((Date)value))).append("'");
                        break;
                    }
                    sqlPart.append("'").append(value).append("'");
                    break;
                }
                default: {
                    sqlPart.append("'").append(SqlUtils.transferStringForSql(value.toString())).append("'");
                }
            }
        }
        return sqlPart.toString();
    }

    @Override
    public String wrapName(String name) {
        if (Lang.isNotEmpty((String)name)) {
            return this.getWrapSign() + name + this.getWrapSign();
        }
        return name;
    }

    @Override
    public String getWrapSign() {
        return "`";
    }

    @Override
    public String getFkCheck(boolean check) {
        throw new UnsupportedException();
    }

    @Override
    protected String getTableColumnsDDL(Table table) {
        StringBuilder ddl = new StringBuilder();
        int pkNo = 0;
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            ++pkNo;
        }
        boolean mulityPk = pkNo > 1;
        int i = 0;
        int size = table.getColumns().size();
        for (Column column : table.getColumns()) {
            ++i;
            if (mulityPk) {
                BuilderUtils.link(ddl, this.getColumnDDL(column));
                ddl.append(",");
            } else {
                BuilderUtils.link(ddl, this.wrapName(column.getName()), this.getColumnTypeDDL(column), this.getColumnNotNull(column), this.getDefaultValue(column), this.getAutoIncrement(column));
                if (i < size) {
                    ddl.append(",");
                }
            }
            BuilderUtils.link(ddl, this.getColumnComment(column));
            ddl.append("\n");
        }
        if (mulityPk) {
            BuilderUtils.link(ddl, this.getPrimaryKeyDDL(table));
        }
        return ddl.toString();
    }

    @Override
    protected String getTableComment(Table table) {
        return Lang.isEmpty((String)table.getRemark()) ? "" : BuilderUtils.link("--", table.getRemark());
    }

    @Override
    protected String getColumnComment(Column column) {
        return Lang.isEmpty((String)column.getRemark()) ? "" : BuilderUtils.link("--", column.getRemark());
    }

    @Override
    protected String getColumnDDL(Column column) {
        return BuilderUtils.link(this.wrapName(column.getName()), this.getColumnTypeDDL(column), this.getColumnNotNull(column), this.getDefaultValue(column), this.getAutoIncrement(column));
    }

    @Override
    protected String getAutoIncrement(Column column) {
        if (column.isAutoincrement()) {
            return "PRIMARY KEY AUTOINCREMENT";
        }
        return "";
    }

    @Override
    protected String getColumnTypeDDL(Column column, String extra) {
        int size = column.getSize();
        int decimalDigits = column.getDecimalDigits();
        String result = this.getColumnTypeName(column.getSqlType());
        if (size > 0 && (result.equals(JDBCType.REAL.getName()) || result.equals(TEXT_TYPE))) {
            result = result + "(" + size;
            if (decimalDigits > 0) {
                result = result + "," + decimalDigits;
            }
            result = result + ")";
        }
        if (Lang.isNotEmpty((String)extra)) {
            result = BuilderUtils.link(result, extra);
        }
        return result;
    }

    @Override
    protected String getColumnTypeName(SQLType sqlType) {
        JDBCType type = JDBCType.valueOf(sqlType.getVendorTypeNumber());
        switch (type) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return JDBCType.INTEGER.getName();
            }
            case CHAR: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return TEXT_TYPE;
            }
            case BLOB: {
                return JDBCType.BLOB.getName();
            }
            case FLOAT: 
            case DOUBLE: 
            case NUMERIC: 
            case DECIMAL: 
            case REAL: {
                return JDBCType.REAL.getName();
            }
        }
        throw new JdbcException(this.getClass().getSimpleName() + " not support type " + type.toString());
    }

    @Override
    public String buildInsertBatchSql(String tableName, String[] columnNames, int insertAmount) {
        StringBuilder sql = new StringBuilder();
        BuilderUtils.link(sql, this.getKeyword(Keywords.INSERT), this.getKeyword(Keywords.INTO), this.wrapName(tableName), this.getKeyword(Keywords.SELECT));
        for (String column : columnNames) {
            BuilderUtils.link(sql, "?", this.getKeyword(Keywords.AS), this.wrapName(column) + ",");
        }
        sql.deleteCharAt(sql.length() - 1);
        for (int index = 1; index < insertAmount; ++index) {
            BuilderUtils.link(sql, this.getKeyword(Keywords.UNION), this.getKeyword(Keywords.SELECT));
            for (int j = 0; j < columnNames.length; ++j) {
                BuilderUtils.link(sql, "?,");
            }
            sql.deleteCharAt(sql.length() - 1);
        }
        return sql.toString();
    }

    @Override
    public boolean isAutoGenerateKeyBatch() {
        return false;
    }

    @Override
    public String buildAlterTableAddColumnDDL(String databaseName, String tableName, Column ... columns) {
        throw new UnsupportedException();
    }

    @Override
    public String buildAlterTableDropColumnDDL(String databaseName, String tableName, String ... columnNames) {
        throw new UnsupportedException();
    }

    @Override
    public String buildAlterTableModifyColumnDDL(String databaseName, String tableName, Column ... columns) {
        throw new UnsupportedException();
    }
}

