/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.dialect.AbstractDialect;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import java.util.Date;

public class OracleDialect
extends AbstractDialect {
    @Override
    public Object[] getPaginationSqlParameter(Object[] params, int start, int limit) {
        Object[] pagingParams = null;
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            pagingParams = new Object[2];
            pagingParams[0] = start;
        } else {
            this.logger.debug("start < 0 , don't use start");
            pagingParams = new Object[1];
        }
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        pagingParams[pagingParams.length - 1] = start + limit;
        return (Object[])ArrayUtils.concat((Object)params, (Object)pagingParams);
    }

    @Override
    public String getPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, false);
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, true);
    }

    private String getPaginationSql(String sql, int start, boolean isParamNamed) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (this.isForUpdate(sql)) {
            sql = sql.substring(0, sql.length() - " for update".length());
            isForUpdate = true;
        }
        int sqlLengthOffset = 50;
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 50);
        if (start > 0) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (isParamNamed) {
            if (start > 0) {
                pagingSelect.append(String.format(" ) row_ ) where rownum_ > :%s and rownum_ <= :%s ", "dialect_paging_start", "dialect_paging_limit"));
            } else {
                pagingSelect.append(String.format(") where rownum <= :%s", "dialect_paging_limit"));
            }
        } else {
            if (start > 0) {
                pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (start > 0) {
                pagingSelect.append(" ) row_ ) where rownum_ > ? and rownum_ <= ?");
            } else {
                pagingSelect.append(" ) where rownum <= ?");
            }
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        this.logger.debug("\u539f\u59cbSql\uff1a{}", (Object)sql);
        this.logger.debug("\u5206\u9875Sql\uff1a{}", (Object)pagingSelect);
        return pagingSelect.toString();
    }

    @Override
    public String convertValueToSql(Object value, int sqlType) {
        StringBuilder sqlPart = new StringBuilder();
        if (value == null) {
            sqlPart.append("null");
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    sqlPart.append(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        sqlPart.append("to_date('").append(Dates.formatTime((Date)((Date)value))).append("' , 'yyyy-mm-dd hh24:mi:ss')");
                        break;
                    }
                    sqlPart.append("to_date('").append(value).append("' , 'yyyy-mm-dd hh24:mi:ss')");
                    break;
                }
                default: {
                    sqlPart.append("'").append(SqlUtils.transferStringForSql(value.toString())).append("'");
                }
            }
        }
        return sqlPart.toString();
    }

    @Override
    public String wrapName(String name) {
        if (Lang.isNotEmpty((String)name)) {
            return this.getWrapSign() + name + this.getWrapSign();
        }
        return name;
    }

    @Override
    public String getFkCheck(boolean check) {
        throw new UnsupportedException();
    }

    @Override
    public String getWrapSign() {
        return "'";
    }

    @Override
    protected String getPrimaryKeyDDL(Table table) {
        throw new UnsupportedException();
    }

    @Override
    public String buildInsertBatchSql(String tableName, String[] columnNames, int insertAmount) {
        throw new UnsupportedException();
    }
}

