/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.dialect.AbstractDialect;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import java.util.Date;

public class MySQLDialect
extends AbstractDialect {
    @Override
    public String getPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, false);
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, true);
    }

    private String getPaginationSql(String sql, int start, boolean isParamNamed) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (this.isForUpdate(sql)) {
            sql = sql.substring(0, sql.length() - " for update".length());
            isForUpdate = true;
        }
        int sqlLengthOffset = 50;
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 50);
        pagingSelect.append(sql);
        if (isParamNamed) {
            if (start > 0) {
                pagingSelect.append(String.format(" LIMIT :%s,:%s", "dialect_paging_start", "dialect_paging_limit"));
            } else {
                pagingSelect.append(String.format(" LIMIT :%s", "dialect_paging_limit"));
            }
        } else if (start > 0) {
            pagingSelect.append(" LIMIT ?,?");
        } else {
            pagingSelect.append(" LIMIT ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        this.logger.debug("\u539f\u59cbSql\uff1a{}", (Object)sql);
        this.logger.debug("\u5206\u9875Sql\uff1a{}", (Object)pagingSelect);
        return pagingSelect.toString();
    }

    @Override
    public String convertValueToSql(Object value, int sqlType) {
        StringBuilder sqlPart = new StringBuilder();
        if (value == null) {
            sqlPart.append("null");
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    sqlPart.append(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        sqlPart.append("'").append(Dates.formatTime((Date)((Date)value))).append("'");
                        break;
                    }
                    sqlPart.append("'").append(value).append("'");
                    break;
                }
                default: {
                    sqlPart.append("'").append(SqlUtils.transferStringForSql(value.toString())).append("'");
                }
            }
        }
        return sqlPart.toString();
    }

    @Override
    public String wrapName(String name) {
        if (Lang.isNotEmpty((String)name)) {
            return this.getWrapSign() + name + this.getWrapSign();
        }
        return name;
    }

    @Override
    public String getWrapSign() {
        return "`";
    }

    @Override
    public String getFkCheck(boolean check) {
        return "SET FOREIGN_KEY_CHECKS=" + (check ? 1 : 0);
    }

    @Override
    protected String getAutoIncrement(Column column) {
        if (column.isAutoincrement()) {
            return "AUTO_INCREMENT";
        }
        return "";
    }
}

