/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.model;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTable<T extends Table>
implements Table {
    protected String type;
    protected String name;
    protected String remark;
    protected String catalog;
    protected List<Column> primaryColumns = new ArrayList<Column>(1);
    protected Map<String, Column> columnMap = new LinkedHashMap<String, Column>(0);

    protected void add(Column column) {
        if (column.isPrimaryKey()) {
            this.primaryColumns.add(column);
        }
        this.columnMap.put(column.getName().toUpperCase(), column);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public T setType(String type) {
        this.type = type;
        return (T)this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    public T setRemark(String remark) {
        this.remark = remark;
        return (T)this;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public T setCatalog(String catalog) {
        this.catalog = catalog;
        return (T)this;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.columnMap.get(columnName.toUpperCase());
    }

    @Override
    public Collection<Column> getColumns() {
        return new ArrayList<Column>(this.columnMap.values());
    }

    @Override
    public Map<String, Column> getColumnMap() {
        return new LinkedHashMap<String, Column>(this.columnMap);
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return new ArrayList<Column>(this.primaryColumns);
    }
}

