/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.model;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.metadata.SqlType;

public abstract class AbstractColumn<T extends Column>
implements Column {
    protected String name;
    protected SqlType sqlType;
    protected int type;
    protected String typeName;
    protected int size;
    protected String remark;
    protected String defaultValue;
    protected boolean nullable;
    protected int columnIndex;
    protected boolean primaryKey;
    protected int decimalDigits;
    protected boolean autoincrement;

    @Override
    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public T setType(int type) {
        this.type = type;
        this.sqlType = SqlType.value(type);
        return (T)this;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public T setTypeName(String typeName) {
        this.typeName = typeName;
        return (T)this;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public T setSize(int size) {
        this.size = size;
        return (T)this;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    public T setRemark(String remark) {
        this.remark = remark;
        return (T)this;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public T setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return (T)this;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public T setNullable(boolean nullable) {
        this.nullable = nullable;
        return (T)this;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    public T setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
        return (T)this;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public T setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
        if (primaryKey) {
            this.nullable = false;
        }
        return (T)this;
    }

    @Override
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public T setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
        return (T)this;
    }

    @Override
    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public T setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
        return (T)this;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public T setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
        this.type = sqlType.getValue();
        return (T)this;
    }
}

