/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.metadata;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.metadata.ColumnMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableMetadata
implements Table {
    private String type;
    private String name;
    private String remark;
    private String catalog;
    private DatabaseMetadata databaseMetadata;
    private List<Column> primaryColumns = new ArrayList<Column>(1);
    private Map<String, Column> columnMap = new HashMap<String, Column>(0);

    public TableMetadata(DatabaseMetadata databaseMetadata) {
        this.databaseMetadata = databaseMetadata;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.columnMap.get(columnName.toUpperCase());
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columnMap.values();
    }

    @Override
    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return this.primaryColumns;
    }

    public void addColumn(ColumnMetadata columnMetadata) {
        if (columnMetadata.isPrimaryKey()) {
            this.primaryColumns.add(columnMetadata);
        }
        this.columnMap.put(columnMetadata.getName().toUpperCase(), columnMetadata);
    }

    public void addColumn(ColumnMetadata ... columnMetadatas) {
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            this.addColumn(columnMetadata);
        }
    }

    public void addColumn(Collection<ColumnMetadata> columnMetadatas) {
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            this.addColumn(columnMetadata);
        }
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getName() != null && this.getName().length() > 0) {
            byte[] bs;
            for (byte b : bs = this.getName().getBytes()) {
                hashCode += b;
            }
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            TableMetadata tm = (TableMetadata)obj;
            if (this.getCatalog() == null) {
                return this.getName().equals(tm.getName());
            }
            return this.getName().equals(tm.getName()) && this.getCatalog().equals(tm.getCatalog());
        }
        return false;
    }

    public DatabaseMetadata getDatabaseMetadata() {
        return this.databaseMetadata;
    }

    @Override
    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    void setCatalog(String catalog) {
        this.catalog = catalog;
    }
}

