/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.mapping.DefaultSqlTypeMapping;
import cn.featherfly.common.db.mapping.JavaToSqlTypeMapper;
import cn.featherfly.common.db.mapping.JavaToSqlTypeRegister;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeToJavaMapper;
import cn.featherfly.common.db.mapping.SqlTypeToJavaRegister;
import cn.featherfly.common.db.metadata.SqlType;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuples;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTypeMappingManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DefaultSqlTypeMapping defaultSqlTypeMapping = new DefaultSqlTypeMapping();
    private Store globalStore = new Store();
    private Map<Class<?>, Store> typeStoreMap = new HashMap();

    public SqlTypeMappingManager regist(JavaToSqlTypeRegister<? extends Serializable> register) {
        AssertIllegalArgument.isNotNull(register, (String)"register");
        this.globalStore.put(register);
        return this;
    }

    public SqlTypeMappingManager regist(Class<?> entityType, JavaToSqlTypeRegister<? extends Serializable> register) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(register, (String)"register");
        Store store = this.getStore(entityType);
        store.put(register);
        return this;
    }

    public SqlTypeMappingManager regist(JavaToSqlTypeMapper<? extends Serializable> mapper) {
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        this.globalStore.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(Class<?> entityType, JavaToSqlTypeMapper<? extends Serializable> mapper) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        Store store = this.getStore(entityType);
        store.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(SqlTypeToJavaRegister<? extends Serializable> register) {
        AssertIllegalArgument.isNotNull(register, (String)"register");
        this.globalStore.put(register);
        return this;
    }

    public SqlTypeMappingManager regist(Class<?> entityType, SqlTypeToJavaRegister<? extends Serializable> register) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(register, (String)"register");
        Store store = this.getStore(entityType);
        store.put(register);
        return this;
    }

    public SqlTypeMappingManager regist(SqlTypeToJavaMapper<? extends Serializable> mapper) {
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        this.globalStore.add(mapper);
        return this;
    }

    public SqlTypeMappingManager regist(Class<?> entityType, SqlTypeToJavaMapper<? extends Serializable> mapper) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(mapper, (String)"mapper");
        Store store = this.getStore(entityType);
        store.add(mapper);
        return this;
    }

    public <E extends Serializable> SqlType getSqlType(Class<E> javaType) {
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        SqlType sqlType = this.globalStore.getSqlType(javaType);
        if (sqlType == null) {
            sqlType = this.defaultSqlTypeMapping.getSqlType(javaType);
        }
        return sqlType;
    }

    public <E extends Serializable> SqlType getSqlType(Class<E> entityType, Class<E> javaType) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull(javaType, (String)"javaType");
        SqlType sqlType = null;
        Store store = this.typeStoreMap.get(entityType);
        if (store != null) {
            sqlType = store.getSqlType(javaType);
        }
        if (sqlType == null) {
            sqlType = this.getSqlType(javaType);
        }
        return sqlType;
    }

    public <E extends Serializable> Class<E> getJavaType(SqlType sqlType) {
        AssertIllegalArgument.isNotNull((Object)((Object)sqlType), (String)"sqlType");
        Class javaType = this.globalStore.getJavaType(sqlType);
        if (javaType == null) {
            javaType = this.defaultSqlTypeMapping.getJavaType(sqlType);
        }
        return javaType;
    }

    public <E extends Serializable> Class<E> getJavaType(Class<E> entityType, SqlType sqlType) {
        AssertIllegalArgument.isNotNull(entityType, (String)"entityType");
        AssertIllegalArgument.isNotNull((Object)((Object)sqlType), (String)"sqlType");
        Class<E> javaType = null;
        Store store = this.typeStoreMap.get(entityType);
        if (store != null) {
            javaType = store.getJavaType(sqlType);
        }
        if (javaType == null) {
            javaType = this.getJavaType(sqlType);
        }
        return javaType;
    }

    private Store getStore(Class<?> entityType) {
        Store store = this.typeStoreMap.get(entityType);
        if (store == null) {
            store = new Store();
            this.typeStoreMap.put(entityType, store);
        }
        return store;
    }

    private class Store {
        private Map<Class<? extends Serializable>, JavaToSqlTypeRegister<? extends Serializable>> javaToSqlTypeMap = new HashMap<Class<? extends Serializable>, JavaToSqlTypeRegister<? extends Serializable>>();
        private List<JavaToSqlTypeMapper<? extends Serializable>> javaToSqlTypeMappers = new ArrayList<JavaToSqlTypeMapper<? extends Serializable>>();
        private Map<SqlType, Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>>> sqlTypeToJavaMap = new HashMap<SqlType, Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>>>();
        private List<SqlTypeToJavaMapper<? extends Serializable>> sqlTypeToJavaMappers = new ArrayList<SqlTypeToJavaMapper<? extends Serializable>>();

        private Store() {
        }

        private void add(JavaToSqlTypeMapper<? extends Serializable> mapper) {
            this.javaToSqlTypeMappers.add(mapper);
        }

        private void add(SqlTypeToJavaMapper<? extends Serializable> mapper) {
            this.sqlTypeToJavaMappers.add(mapper);
        }

        private void put(JavaToSqlTypeRegister<? extends Serializable> register) {
            Class type = ClassUtils.getSuperClassGenricType(register.getClass());
            JavaToSqlTypeRegister<? extends Serializable> oldRegister = null;
            oldRegister = this.javaToSqlTypeMap.get(type);
            if (oldRegister != null) {
                throw new JdbcMappingException("#java.type.registed", new Object[]{type.getName(), oldRegister.getClass().getName(), oldRegister.getSqlType().name()});
            }
            this.javaToSqlTypeMap.put(type, register);
            SqlTypeMappingManager.this.logger.debug("regist java type {} with sql type {}", (Object)type.getName(), (Object)register.getSqlType().name());
        }

        private void put(SqlTypeToJavaRegister<? extends Serializable> register) {
            Class type = ClassUtils.getSuperClassGenricType(register.getClass());
            Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>> oldRegister = null;
            oldRegister = this.sqlTypeToJavaMap.get((Object)register.getSqlType());
            if (oldRegister != null) {
                throw new JdbcMappingException("#sql.type.registed", new Object[]{((SqlTypeToJavaRegister)oldRegister.get0()).getSqlType().name(), ((SqlTypeToJavaRegister)oldRegister.get0()).getClass().getName(), ((Class)oldRegister.get1()).getName()});
            }
            this.sqlTypeToJavaMap.put(register.getSqlType(), (Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>>)Tuples.of(register, (Object)type));
            SqlTypeMappingManager.this.logger.debug("regist java type {} with sql type {}", (Object)type.getName(), (Object)register.getSqlType().name());
        }

        private <E extends Serializable> SqlType getSqlType(Class<E> javaType) {
            JavaToSqlTypeRegister<? extends Serializable> register = this.javaToSqlTypeMap.get(javaType);
            if (register != null) {
                return register.getSqlType();
            }
            for (JavaToSqlTypeMapper<? extends Serializable> javaToSqlTypeMapper : this.javaToSqlTypeMappers) {
                SqlType sqlType = javaToSqlTypeMapper.getSqlType(javaType);
                if (sqlType == null) continue;
                return sqlType;
            }
            return null;
        }

        private <E extends Serializable> Class<E> getJavaType(SqlType sqlType) {
            Tuple2<SqlTypeToJavaRegister<? extends Serializable>, Class<? extends Serializable>> tuple = this.sqlTypeToJavaMap.get((Object)sqlType);
            if (tuple != null) {
                return (Class)tuple.get1();
            }
            for (SqlTypeToJavaMapper<? extends Serializable> sqlTypeToJavaMapper : this.sqlTypeToJavaMappers) {
                Class type = sqlTypeToJavaMapper.getJavaType(sqlType);
                if (type == null) continue;
                return type;
            }
            return null;
        }
    }
}

