/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.ColumnModel;
import cn.featherfly.common.db.builder.TableModel;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuples;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassMappingUtils {
    public static Table createTable(ClassMapping<?> classMapping, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        TableModel table = new TableModel();
        table.setName(classMapping.getRepositoryName());
        table.setRemark(classMapping.getRemark());
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                table.addColumn(ClassMappingUtils.createColumn(propertyMapping, sqlTypeMappingManager));
                continue;
            }
            for (PropertyMapping pm : propertyMapping.getPropertyMappings()) {
                table.addColumn(ClassMappingUtils.createColumn(pm, sqlTypeMappingManager));
            }
        }
        return table;
    }

    public static String getCreateTableSql(ClassMapping<?> classMapping, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        return dialect.buildCreateTableDDL(ClassMappingUtils.createTable(classMapping, dialect, sqlTypeMappingManager));
    }

    private static Column createColumn(PropertyMapping propertyMapping, SqlTypeMappingManager sqlTypeMappingManager) {
        ColumnModel column = new ColumnModel();
        column.setName(propertyMapping.getRepositoryFieldName());
        column.setPrimaryKey(propertyMapping.isPrimaryKey());
        column.setAutoincrement(propertyMapping.isAutoincrement());
        column.setDecimalDigits(propertyMapping.getDecimalDigits());
        column.setDefaultValue(propertyMapping.getDefaultValue());
        column.setNullable(propertyMapping.isNullable());
        column.setRemark(propertyMapping.getRemark());
        column.setSize(propertyMapping.getSize());
        column.setSqlType(sqlTypeMappingManager.getSqlType(propertyMapping.getPropertyType()));
        return column;
    }

    public static Tuple2<String, Map<Integer, String>> getInsertBatchSqlAndParamPositions(int insertAmount, ClassMapping<?> classMapping, Dialect dialect) {
        Tuple2<String, Map<Integer, String>> tuple = ClassMappingUtils.getInsertSqlAndParamPositions(classMapping, dialect);
        String sql = dialect.buildInsertBatchSql(classMapping.getRepositoryName(), ((Map)tuple.get1()).values().toArray(new String[0]), insertAmount);
        return Tuples.of((Object)sql, (Object)tuple.get1());
    }

    public static Tuple2<String, Map<Integer, String>> getInsertSqlAndParamPositions(ClassMapping<?> classMapping, Dialect dialect) {
        LinkedHashMap<Integer, String> propertyPositions = new LinkedHashMap<Integer, String>();
        StringBuilder insertSql = new StringBuilder();
        insertSql.append(dialect.getKeywords().insert()).append(" ").append(dialect.getKeywords().into()).append(" ").append(dialect.wrapName(classMapping.getRepositoryName())).append(" (");
        ArrayList<PropertyMapping> pms = new ArrayList<PropertyMapping>();
        for (PropertyMapping pm : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)pm.getPropertyMappings())) {
                if (!pm.isInsertable()) continue;
                insertSql.append(dialect.wrapName(pm.getRepositoryFieldName())).append(",");
                pms.add(pm);
                continue;
            }
            for (PropertyMapping pm2 : pm.getPropertyMappings()) {
                if (!pm.isInsertable()) continue;
                insertSql.append(dialect.wrapName(pm2.getRepositoryFieldName())).append(",");
                pms.add(pm2);
            }
        }
        if (pms.size() > 0) {
            insertSql.deleteCharAt(insertSql.length() - 1);
        }
        insertSql.append(") ").append(dialect.getKeywords().values()).append(ClassMappingUtils.getInsertValuesSqlPart(pms, propertyPositions));
        return Tuples.of((Object)insertSql.toString(), propertyPositions);
    }

    private static String getInsertValuesSqlPart(List<PropertyMapping> pms, Map<Integer, String> propertyPositions) {
        StringBuilder insertSqlPart = new StringBuilder(" (");
        int paramNum = 0;
        for (int i = 0; i < pms.size(); ++i) {
            PropertyMapping pm = pms.get(i);
            if (pm.isPrimaryKey() && pm.getDefaultValue() != null && !"null".equalsIgnoreCase(pm.getDefaultValue())) {
                insertSqlPart.append(pm.getDefaultValue()).append(",");
                continue;
            }
            ++paramNum;
            insertSqlPart.append("?").append(",");
            if (pm.getParent() == null) {
                propertyPositions.put(paramNum, pm.getPropertyName());
                continue;
            }
            propertyPositions.put(paramNum, pm.getParent().getPropertyName() + "." + pm.getPropertyName());
        }
        if (pms.size() > 0) {
            insertSqlPart.deleteCharAt(insertSqlPart.length() - 1);
        }
        insertSqlPart.append(")");
        return insertSqlPart.toString();
    }

    public static Tuple2<String, Map<Integer, String>> getUpdateSqlAndParamPositions(ClassMapping<?> classMapping, Dialect dialect) {
        LinkedHashMap<Integer, String> propertyPositions = new LinkedHashMap<Integer, String>();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(dialect.getKeywords().update()).append(" ").append(dialect.wrapName(classMapping.getRepositoryName())).append(" ").append(dialect.getKeywords().set()).append(" ");
        int columnNum = 0;
        ArrayList<PropertyMapping> pms = new ArrayList<PropertyMapping>();
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                if (propertyMapping.isPrimaryKey()) {
                    pms.add(propertyMapping);
                    continue;
                }
                if (!propertyMapping.isUpdatable()) continue;
                updateSql.append(dialect.wrapName(propertyMapping.getRepositoryFieldName())).append(" = ?, ");
                propertyPositions.put(++columnNum, propertyMapping.getPropertyName());
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                if (subPropertyMapping.isPrimaryKey()) {
                    pms.add(subPropertyMapping);
                    continue;
                }
                if (!propertyMapping.isUpdatable()) continue;
                updateSql.append(dialect.wrapName(subPropertyMapping.getRepositoryFieldName())).append(" = ?, ");
                propertyPositions.put(++columnNum, propertyMapping.getPropertyName() + "." + subPropertyMapping.getPropertyName());
            }
        }
        if (columnNum > 0) {
            updateSql.deleteCharAt(updateSql.length() - 1).deleteCharAt(updateSql.length() - 1);
        }
        int pkNum = 0;
        updateSql.append(" ").append(dialect.getKeywords().where()).append(" ");
        for (PropertyMapping pm : pms) {
            if (pkNum > 0) {
                updateSql.append(dialect.getKeywords().and()).append(" ");
            }
            updateSql.append(dialect.wrapName(pm.getRepositoryFieldName())).append(" = ? ");
            ++pkNum;
            if (pm.getParent() == null) {
                propertyPositions.put(columnNum + pkNum, pm.getPropertyName());
                continue;
            }
            propertyPositions.put(columnNum + pkNum, pm.getParent().getPropertyName() + "." + pm.getPropertyName());
        }
        return Tuples.of((Object)updateSql.toString().trim(), propertyPositions);
    }

    public static Tuple2<String, Map<Integer, String>> getDeleteSqlAndParamPositions(ClassMapping<?> classMapping, Dialect dialect) {
        LinkedHashMap<Integer, String> propertyPositions = new LinkedHashMap<Integer, String>();
        StringBuilder deleteSql = new StringBuilder();
        deleteSql.append(dialect.getKeywords().delete()).append(" ").append(dialect.getKeywords().from()).append(" ").append(dialect.wrapName(classMapping.getRepositoryName())).append(" ").append(dialect.getKeywords().where()).append(" ");
        int columnNum = 0;
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                if (!propertyMapping.isPrimaryKey()) continue;
                if (columnNum > 0) {
                    deleteSql.append(dialect.getKeywords().and()).append(" ");
                }
                deleteSql.append(dialect.wrapName(propertyMapping.getRepositoryFieldName())).append(" = ? ");
                propertyPositions.put(++columnNum, propertyMapping.getPropertyName());
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                if (!subPropertyMapping.isPrimaryKey()) continue;
                if (columnNum > 0) {
                    deleteSql.append(dialect.getKeywords().and()).append(" ");
                }
                deleteSql.append(dialect.wrapName(subPropertyMapping.getRepositoryFieldName())).append(" = ? ");
                propertyPositions.put(++columnNum, propertyMapping.getPropertyName() + "." + subPropertyMapping.getPropertyName());
            }
        }
        return Tuples.of((Object)deleteSql.toString().trim(), propertyPositions);
    }

    public static <T> Tuple2<String, Map<Integer, String>> getMergeSqlAndParamPositions(T entity, ClassMapping<?> classMapping, boolean onlyNull, Dialect dialect) {
        LinkedHashMap<Integer, String> propertyPositions = new LinkedHashMap<Integer, String>();
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(dialect.getKeywords().update()).append(" ").append(dialect.wrapName(classMapping.getRepositoryName())).append(" ").append(dialect.getKeywords().set()).append(" ");
        int columnNum = 0;
        ArrayList<PropertyMapping> pkms = new ArrayList<PropertyMapping>();
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                if (ClassMappingUtils.checkNullOrEmpty(entity, propertyMapping, onlyNull)) continue;
                if (propertyMapping.isPrimaryKey()) {
                    pkms.add(propertyMapping);
                    continue;
                }
                if (!propertyMapping.isUpdatable()) continue;
                columnNum = ClassMappingUtils.set(entity, propertyMapping, updateSql, propertyPositions, columnNum, dialect);
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                if (ClassMappingUtils.checkNullOrEmpty(entity, subPropertyMapping, onlyNull)) continue;
                if (subPropertyMapping.isPrimaryKey()) {
                    pkms.add(subPropertyMapping);
                    continue;
                }
                if (!propertyMapping.isUpdatable()) continue;
                columnNum = ClassMappingUtils.set(entity, subPropertyMapping, updateSql, propertyPositions, columnNum, dialect);
            }
        }
        if (columnNum > 0) {
            updateSql.deleteCharAt(updateSql.length() - 1);
        }
        int pkNum = 0;
        updateSql.append(" ").append(dialect.getKeywords().where()).append(" ");
        for (PropertyMapping pm : pkms) {
            if (pkNum > 0) {
                updateSql.append(dialect.getKeywords().and()).append(" ");
            }
            updateSql.append(dialect.wrapName(pm.getRepositoryFieldName())).append(" = ? ");
            propertyPositions.put(columnNum + ++pkNum, ClassMappingUtils.getPropertyAliasName(pm));
        }
        return Tuples.of((Object)updateSql.toString().trim(), propertyPositions);
    }

    private static <T> boolean checkNullOrEmpty(T entity, PropertyMapping propertyMapping, boolean onlyNull) {
        String pn = ClassMappingUtils.getPropertyAliasName(propertyMapping);
        if (onlyNull) {
            return BeanUtils.getProperty(entity, (String)pn) == null;
        }
        return LangUtils.isEmpty((Object)BeanUtils.getProperty(entity, (String)pn));
    }

    private static <T> int set(T entity, PropertyMapping propertyMapping, StringBuilder updateSql, LinkedHashMap<Integer, String> propertyPositions, int columnNum, Dialect dialect) {
        BuilderUtils.link(updateSql, dialect.wrapName(propertyMapping.getRepositoryFieldName()), " = ?,");
        propertyPositions.put(++columnNum, ClassMappingUtils.getPropertyAliasName(propertyMapping));
        return columnNum;
    }

    public static String getSelectByIdSql(ClassMapping<?> classMapping, Dialect dialect) {
        return ClassMappingUtils.getSelectByIdSql(classMapping, null, dialect);
    }

    public static String getSelectByIdSql(ClassMapping<?> classMapping, String alias, Dialect dialect) {
        StringBuilder getSql = new StringBuilder();
        LinkedHashMap<Integer, String> propertyPositions = new LinkedHashMap<Integer, String>();
        getSql.append(ClassMappingUtils.getSelectSql(classMapping, alias, dialect));
        ArrayList<PropertyMapping> pkPms = new ArrayList<PropertyMapping>();
        StringBuilder condition = new StringBuilder();
        int columnNum = 0;
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().isEmpty()) {
                columnNum = ClassMappingUtils.setPk(condition, columnNum, propertyMapping, propertyPositions, pkPms, dialect);
                continue;
            }
            for (PropertyMapping subPropertyMapping : propertyMapping.getPropertyMappings()) {
                columnNum = ClassMappingUtils.setPk(condition, columnNum, subPropertyMapping, propertyPositions, pkPms, dialect);
            }
        }
        BuilderUtils.link(getSql, dialect.getKeywords().where(), condition.toString());
        return getSql.toString();
    }

    private static int setPk(StringBuilder condition, int columnNum, PropertyMapping pm, Map<Integer, String> propertyPositions, List<PropertyMapping> pkPms, Dialect dialect) {
        if (pm.isPrimaryKey()) {
            if (columnNum > 0) {
                condition.append(dialect.getKeywords().and()).append(" ");
            }
            condition.append(dialect.wrapName(pm.getRepositoryFieldName())).append(" = ? ");
            propertyPositions.put(++columnNum, ClassMappingUtils.getPropertyAliasName(pm));
            pkPms.add(pm);
        }
        return columnNum;
    }

    public static String getSelectSql(ClassMapping<?> classMapping, Dialect dialect) {
        return ClassMappingUtils.getSelectSql(classMapping, null, dialect);
    }

    public static String getSelectSql(ClassMapping<?> classMapping, String alias, Dialect dialect) {
        StringBuilder selectSql = new StringBuilder();
        BuilderUtils.link(selectSql, dialect.getKeywords().select(), ClassMappingUtils.getSelectColumnsSql(classMapping, alias, dialect), dialect.getKeywords().from(), dialect.wrapName(classMapping.getRepositoryName()));
        return selectSql.toString();
    }

    public static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, Dialect dialect) {
        return ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, "", dialect);
    }

    public static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, String prefixPropertyName, Dialect dialect) {
        return ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, prefixPropertyName, dialect, null, new HashMap<String, String>(0));
    }

    public static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, Dialect dialect, MappingFactory mappingFactory, Map<String, String> fetchProperties) {
        return ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, null, dialect, mappingFactory, fetchProperties);
    }

    private static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, String prefixPropertyName, Dialect dialect, MappingFactory mappingFactory, Map<String, String> fetchProperties) {
        StringBuilder selectSql = new StringBuilder();
        int columnNum = 0;
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, propertyMapping, prefixPropertyName, dialect));
                ++columnNum;
                continue;
            }
            boolean fetchAble = false;
            String fetchPropertyTableAlia = null;
            if (LangUtils.isNotEmpty(fetchProperties)) {
                for (Map.Entry<String, String> entry : fetchProperties.entrySet()) {
                    fetchPropertyTableAlia = entry.getValue();
                    if (!propertyMapping.getPropertyName().equals(entry.getKey())) continue;
                    fetchAble = true;
                    break;
                }
            }
            if (fetchAble) {
                ClassMapping pcm = mappingFactory.getClassMapping(propertyMapping.getPropertyType());
                for (PropertyMapping pm : pcm.getPropertyMappings()) {
                    selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, fetchPropertyTableAlia, pm, propertyMapping, dialect));
                    ++columnNum;
                }
            } else {
                for (PropertyMapping propertyMapping2 : propertyMapping.getPropertyMappings()) {
                    selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, propertyMapping2, prefixPropertyName, dialect));
                    ++columnNum;
                }
            }
            fetchAble = false;
        }
        if (columnNum > 0) {
            selectSql.delete(selectSql.length() - 2, selectSql.length());
        }
        return selectSql.toString();
    }

    private static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, PropertyMapping propertyMapping, String prefixPropertyName, Dialect dialect) {
        StringBuilder selectSql = new StringBuilder();
        if (StringUtils.isNotBlank((String)tableAlias)) {
            selectSql.append(tableAlias).append(".");
        }
        selectSql.append(dialect.wrapName(propertyMapping.getRepositoryFieldName())).append(" ").append(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, prefixPropertyName, dialect)).append(",").append(" ");
        return selectSql.toString();
    }

    private static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, PropertyMapping propertyMapping, PropertyMapping nestedPropertyMapping, Dialect dialect) {
        StringBuilder selectSql = new StringBuilder();
        if (StringUtils.isNotBlank((String)tableAlias)) {
            selectSql.append(tableAlias).append(".");
        }
        selectSql.append(dialect.wrapName(propertyMapping.getRepositoryFieldName())).append(" ").append(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, nestedPropertyMapping, dialect)).append(",").append(" ");
        return selectSql.toString();
    }

    public static String getPropertyAliasName(PropertyMapping propertyMapping) {
        return ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, "");
    }

    private static String getNestedPropertyAliasName(PropertyMapping propertyMapping, PropertyMapping nestedPropertyMapping) {
        String prefixPropertyName = null;
        if (nestedPropertyMapping != null) {
            prefixPropertyName = nestedPropertyMapping.getPropertyName();
        }
        return ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, prefixPropertyName);
    }

    private static String getNestedPropertyAliasName(PropertyMapping pm, String prefixPropertyName) {
        PropertyMapping propertyMapping = pm;
        if (!propertyMapping.getPropertyMappings().isEmpty()) {
            propertyMapping = (PropertyMapping)propertyMapping.getPropertyMappings().get(0);
        }
        String propertyName = propertyMapping.getPropertyName();
        if (propertyMapping.getParent() != null) {
            propertyName = propertyMapping.getParent().getPropertyName() + "." + propertyMapping.getPropertyName();
        }
        if (LangUtils.isNotEmpty((String)prefixPropertyName)) {
            propertyName = prefixPropertyName + "." + propertyName;
        }
        return propertyName;
    }

    public static String getPropertyAliasName(PropertyMapping propertyMapping, Dialect dialect) {
        return dialect.wrapName(ClassMappingUtils.getPropertyAliasName(propertyMapping));
    }

    private static String getNestedPropertyAliasName(PropertyMapping propertyMapping, String prefixPropertyName, Dialect dialect) {
        return dialect.wrapName(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, prefixPropertyName));
    }

    private static String getNestedPropertyAliasName(PropertyMapping propertyMapping, PropertyMapping nestedPropertyMapping, Dialect dialect) {
        return dialect.wrapName(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, nestedPropertyMapping));
    }

    public static Map<String, String> getSelectColumns(ClassMapping<?> classMapping) {
        HashMap<String, String> columns = new HashMap<String, String>();
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                columns.put(propertyMapping.getRepositoryFieldName(), propertyMapping.getPropertyName());
                continue;
            }
            for (PropertyMapping pm : propertyMapping.getPropertyMappings()) {
                columns.put(pm.getRepositoryFieldName(), propertyMapping.getPropertyName() + "." + pm.getPropertyName());
            }
        }
        return columns;
    }

    public static Tuple2<String, String> getColumnAndPropertyName(String name, ClassMapping<?> classMapping) {
        PropertyMapping propertyMapping = null;
        if (classMapping != null && LangUtils.isNotEmpty((String)name)) {
            if (name.contains(".")) {
                String[] names = name.split("\\.");
                propertyMapping = ClassMappingUtils.getNestedMapping(names, classMapping);
            } else {
                propertyMapping = ClassMappingUtils.getSimpleMapping(name, classMapping);
            }
        }
        if (propertyMapping != null) {
            return Tuples.of((Object)propertyMapping.getRepositoryFieldName(), (Object)propertyMapping.getPropertyName());
        }
        return Tuples.of((Object)name, (Object)"");
    }

    public static String getColumnName(String name, ClassMapping<?> classMapping) {
        if (classMapping != null && LangUtils.isNotEmpty((String)name)) {
            if (name.contains(".")) {
                String[] names = name.split("\\.");
                return ClassMappingUtils.getNestedColumnName(names, classMapping);
            }
            return ClassMappingUtils.getSimpleColumnName(name, classMapping);
        }
        return name;
    }

    private static PropertyMapping getSimpleMapping(String name, ClassMapping<?> classMapping) {
        PropertyMapping pm = classMapping.getPropertyMapping(name);
        return pm;
    }

    private static String getSimpleColumnName(String name, ClassMapping<?> classMapping) {
        PropertyMapping pm = ClassMappingUtils.getSimpleMapping(name, classMapping);
        if (pm != null) {
            return pm.getRepositoryFieldName();
        }
        return name;
    }

    private static PropertyMapping getNestedMapping(String[] names, ClassMapping<?> classMapping) {
        PropertyMapping pm = null;
        for (String n : names) {
            pm = pm == null ? classMapping.getPropertyMapping(n) : pm.getPropertyMapping(n);
        }
        return pm;
    }

    private static String getNestedColumnName(String[] names, ClassMapping<?> classMapping) {
        PropertyMapping pm = ClassMappingUtils.getNestedMapping(names, classMapping);
        if (pm != null) {
            return pm.getRepositoryFieldName();
        }
        return null;
    }

    public static String[] getColumnNames(ClassMapping<?> classMapping, String ... names) {
        if (classMapping != null) {
            ArrayList<String> newNames = new ArrayList<String>();
            for (String name : names) {
                newNames.add(ClassMappingUtils.getColumnName(name, classMapping));
            }
            return newNames.toArray(new String[0]);
        }
        return names;
    }

    public static String[] getColumnNames(ClassMapping<?> classMapping, Collection<String> names) {
        if (names == null) {
            names = new ArrayList<String>();
        }
        return ClassMappingUtils.getColumnNames(classMapping, names.toArray(new String[0]));
    }
}

