/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data.format;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.data.DataFormat;
import cn.featherfly.common.db.data.ExportException;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.DateUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;

public class JsonDataFormat
implements DataFormat {
    private JsonGenerator generator;

    public JsonDataFormat(Writer writer) {
        this.generator = this.createJsonGenerator(writer);
    }

    @Override
    public void writeDataStart(DatabaseMetadata databaseMetadata) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField("name", databaseMetadata.getName());
        this.generator.writeArrayFieldStart("tables");
    }

    @Override
    public void writeDataEnd(DatabaseMetadata databaseMetadata) throws IOException {
        this.generator.writeEndArray();
        this.generator.writeEndObject();
        this.generator.close();
    }

    @Override
    public void writeTableStart(Table tableMetadata) throws Exception {
        this.generator.writeStartObject();
        this.generator.writeStringField("name", tableMetadata.getName());
        StringBuilder pkMapping = new StringBuilder();
        for (Column column : tableMetadata.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            pkMapping.append(column.getName()).append(",");
        }
        if (pkMapping.length() > 0) {
            pkMapping.deleteCharAt(pkMapping.length() - 1);
        }
        this.generator.writeStringField("pkMapping", pkMapping.toString());
        this.generator.writeArrayFieldStart("rows");
    }

    @Override
    public void writeTableEnd(Table tableMetadata) throws Exception {
        this.generator.writeEndArray();
        this.generator.writeEndObject();
    }

    @Override
    public void writeRow(Table tableMetadata, ResultSet res) throws Exception {
        ResultSetMetaData rsmd = res.getMetaData();
        int columnTotal = rsmd.getColumnCount();
        this.generator.writeStartObject();
        for (int i = 1; i <= columnTotal; ++i) {
            String columnName = rsmd.getColumnName(i);
            int type = rsmd.getColumnType(i);
            Object value = res.getObject(columnName);
            this.generator.writeObjectFieldStart(columnName);
            this.generator.writeStringField("type", type + "");
            if (value != null) {
                this.generator.writeStringField("null", "0");
                switch (type) {
                    case 93: {
                        this.generator.writeStringField("value", DateUtils.formartTime((Date)res.getTimestamp(columnName)));
                        break;
                    }
                    default: {
                        this.generator.writeStringField("value", value.toString());
                        break;
                    }
                }
            } else {
                this.generator.writeStringField("null", "1");
            }
            this.generator.writeEndObject();
        }
        this.generator.writeEndObject();
    }

    private JsonGenerator createJsonGenerator(Writer writer) {
        try {
            return new JsonFactory().createGenerator(writer);
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
    }
}

