/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data;

import cn.featherfly.common.db.data.AbstractDataImpExp;
import cn.featherfly.common.db.data.DataFilter;
import cn.featherfly.common.db.data.DataImportor;
import cn.featherfly.common.db.data.DataTransformer;
import cn.featherfly.common.db.data.RecordModel;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.LangUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDataImportor
extends AbstractDataImpExp
implements DataImportor {
    private boolean fkCheck;
    private DataImportor.ExistPolicy existPolicy = DataImportor.ExistPolicy.exception;
    private DataImportor.TransactionPolicy transactionPolicy = DataImportor.TransactionPolicy.all;
    private List<String> prepareSqls = new ArrayList<String>();
    private List<DataFilter> filters = new ArrayList<DataFilter>();
    private List<DataTransformer> transformers = new ArrayList<DataTransformer>();

    protected AbstractDataImportor(Dialect dialect) {
        super(dialect);
    }

    public void addPrepareSql(String prepareSql) {
        if (LangUtils.isNotEmpty((String)prepareSql)) {
            this.prepareSqls.add(prepareSql);
        }
    }

    public void addPrepareSql(String ... prepareSqls) {
        if (LangUtils.isNotEmpty((Object[])prepareSqls)) {
            for (String prepareSql : prepareSqls) {
                this.prepareSqls.add(prepareSql);
            }
        }
    }

    public void addFilter(DataFilter filter) {
        if (LangUtils.isNotEmpty((Object)filter)) {
            this.filters.add(filter);
        }
    }

    public void addFilter(DataFilter ... filters) {
        if (LangUtils.isNotEmpty((Object[])filters)) {
            for (DataFilter filter : filters) {
                this.filters.add(filter);
            }
        }
    }

    public void addTransformers(DataTransformer transformer) {
        if (LangUtils.isNotEmpty((Object)transformer)) {
            this.transformers.add(transformer);
        }
    }

    public void addTransformers(DataTransformer ... transformers) {
        if (LangUtils.isNotEmpty(this.filters)) {
            for (DataTransformer transformer : transformers) {
                this.transformers.add(transformer);
            }
        }
    }

    protected boolean filtdate(RecordModel recordModel, Connection conn) {
        if (LangUtils.isNotEmpty(this.filters)) {
            for (DataFilter filter : this.filters) {
                if (!filter.filter(recordModel, conn)) continue;
                this.logger.debug("\u8fc7\u6ee4\u8be5\u6761\u6570\u636e\uff0c {}", (Object)recordModel);
                return true;
            }
        }
        return false;
    }

    protected RecordModel transform(RecordModel recordModel) {
        if (LangUtils.isNotEmpty(this.transformers)) {
            for (DataTransformer transformer : this.transformers) {
                recordModel = transformer.transform(recordModel);
            }
        }
        return recordModel;
    }

    public List<String> getPrepareSqls() {
        return this.prepareSqls;
    }

    public void setPrepareSqls(List<String> prepareSqls) {
        this.prepareSqls = prepareSqls;
    }

    public List<DataTransformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<DataTransformer> transformers) {
        this.transformers = transformers;
    }

    public DataImportor.ExistPolicy getExistPolicy() {
        return this.existPolicy;
    }

    public void setExistPolicy(DataImportor.ExistPolicy existPolicy) {
        this.existPolicy = existPolicy;
    }

    public DataImportor.TransactionPolicy getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public void setTransactionPolicy(DataImportor.TransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
    }

    public boolean isFkCheck() {
        return this.fkCheck;
    }

    public void setFkCheck(boolean fkCheck) {
        this.fkCheck = fkCheck;
    }
}

