/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data;

import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.data.AbstractDataImpExp;
import cn.featherfly.common.db.data.DataExportor;
import cn.featherfly.common.db.data.query.SimpleQuery;
import cn.featherfly.common.db.data.query.TableQuery;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.repository.Query;
import cn.featherfly.common.repository.builder.dml.ConditionBuilder;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractDataExportor
extends AbstractDataImpExp
implements DataExportor {
    protected AbstractDataExportor(Dialect dialect) {
        super(dialect);
    }

    @Override
    public void exportDatabase(Writer writer) {
        ArrayList<TableQuery> tableQuerys = new ArrayList<TableQuery>();
        DatabaseMetadata databaseMetadata = this.getDatabaseMetadata();
        Collection<Table> tableMetadatas = databaseMetadata.getTables();
        for (Table tableMetadata : tableMetadatas) {
            tableQuerys.add(new TableQuery(this.getDialect(), tableMetadata.getName()));
        }
        this.exportTables(writer, tableQuerys);
    }

    @Override
    public void exportTable(String tableName, Writer writer) {
        this.exportTable(new TableQuery(this.getDialect(), tableName), writer);
    }

    @Override
    public void exportTable(Writer writer, Collection<String> tableNames) {
        ArrayList<TableQuery> tableQuerys = new ArrayList<TableQuery>();
        if (LangUtils.isEmpty(tableNames)) {
            tableNames = new ArrayList<String>();
        }
        for (String tableName : tableNames) {
            tableQuerys.add(new TableQuery(this.getDialect(), tableName));
        }
        this.exportTables(writer, tableQuerys);
    }

    @Override
    public void exportTable(Writer writer, String ... tableNames) {
        this.exportTable(writer, Arrays.asList(tableNames));
    }

    @Override
    public void exportTable(TableQuery tableQuery, Writer writer) {
        this.exportTables(writer, tableQuery);
    }

    @Override
    public void exportTables(Writer writer, TableQuery ... querys) {
        this.exportData(writer, querys);
    }

    @Override
    public void exportTables(Writer writer, Collection<TableQuery> querys) {
        this.exportTables(writer, querys.toArray(new TableQuery[0]));
    }

    @Override
    public void exportData(String querySql, Writer writer) {
        this.exportData(writer, new SimpleQuery(querySql, new Object[0]));
    }

    @Override
    public void exportData(Collection<String> querySqls, Writer writer) {
        this.exportData(writer, querySqls.toArray(new String[0]));
    }

    @Override
    public void exportData(Writer writer, String ... querySqls) {
        ArrayList<Query> querys = new ArrayList<Query>();
        if (LangUtils.isNotEmpty((Object[])querySqls)) {
            for (String querySql : querySqls) {
                querys.add(new SimpleQuery(querySql, new Object[0]));
            }
        }
        this.exportData(writer, querys);
    }

    @Override
    public void exportData(String tableName, ConditionBuilder conditionBuilder, Writer os) {
        String querySql = this.getTableQuerySql(tableName);
        if (conditionBuilder != null) {
            querySql = querySql + " " + conditionBuilder.build();
        }
        this.exportData(querySql, os);
    }

    @Override
    public void exportData(Writer writer, Query ... querys) {
        this.exportData(writer, Arrays.asList(querys));
    }

    @Override
    public void exportData(Query query, Writer writer) {
        this.exportData(writer, query);
    }
}

