/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml.basic;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.model.ParamedColumnElement;
import cn.featherfly.common.db.builder.model.UpdateColumnElement;
import cn.featherfly.common.db.dialect.Dialect;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SqlUpdateSetBasicBuilder
implements SqlBuilder {
    private String tableName;
    private String alias;
    private List<ParamedColumnElement> params = new ArrayList<ParamedColumnElement>();
    private Dialect dialect;

    public SqlUpdateSetBasicBuilder(Dialect dialect, String tableName) {
        this(dialect, tableName, null);
    }

    public SqlUpdateSetBasicBuilder(Dialect dialect, String tableName, String alias) {
        this.tableName = tableName;
        this.alias = alias;
        this.dialect = dialect;
    }

    public SqlUpdateSetBasicBuilder setValue(String columnName, Object value) {
        this.params.add(new UpdateColumnElement(this.dialect, columnName, value, this.alias));
        return this;
    }

    public SqlUpdateSetBasicBuilder setValue(String columnName, Object value, UpdateColumnElement.SetType setType) {
        this.params.add(new UpdateColumnElement(this.dialect, columnName, value, this.alias, setType));
        return this;
    }

    public List<Object> getParams() {
        return this.params.stream().map(ParamedColumnElement::getParam).collect(Collectors.toList());
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String build() {
        StringBuilder select = new StringBuilder();
        Dialect.Keyworld keyworld = this.dialect.getKeywords();
        select.append(keyworld.update()).append(" ").append(this.dialect.buildTableSql(this.tableName, this.alias)).append(" ").append(keyworld.set());
        this.params.forEach(c -> select.append(" ").append(c.toSql()).append(","));
        select.deleteCharAt(select.length() - 1);
        return select.toString();
    }
}

