/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.wrapper;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.wrapper.CallableStatementWrapper;
import cn.featherfly.common.db.wrapper.PreparedStatementWrapper;
import cn.featherfly.common.db.wrapper.StatementWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class ConnectionWrapper
implements AutoCloseable {
    private Connection connection;

    public ConnectionWrapper(Connection connection) {
        this.connection = connection;
    }

    public void clearWarnings() {
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.connection.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Blob createBlob() {
        try {
            return this.connection.createBlob();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Clob createClob() {
        try {
            return this.connection.createClob();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public NClob createNClob() {
        try {
            return this.connection.createNClob();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public SQLXML createSQLXML() {
        try {
            return this.connection.createSQLXML();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public StatementWrapper createStatement() {
        try {
            return new StatementWrapper(this.connection.createStatement(), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public StatementWrapper createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return new StatementWrapper(this.connection.createStatement(resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public StatementWrapper createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return new StatementWrapper(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.connection.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean getAutoCommit() {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public String getCatalog() {
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Properties getClientInfo() {
        try {
            return this.connection.getClientInfo();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public String getClientInfo(String name) {
        try {
            return this.connection.getClientInfo(name);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public int getHoldability() {
        try {
            return this.connection.getHoldability();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public DatabaseMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public int getTransactionIsolation() {
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Map<String, Class<?>> getTypeMap() {
        try {
            return this.connection.getTypeMap();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public SQLWarning getWarnings() {
        try {
            return this.connection.getWarnings();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isReadOnly() {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isValid(int timeout) {
        try {
            return this.connection.isValid(timeout);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public String nativeSQL(String sql) {
        try {
            return this.connection.nativeSQL(sql);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public CallableStatementWrapper prepareCall(String sql) {
        try {
            return new CallableStatementWrapper(this.connection.prepareCall(sql), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public CallableStatementWrapper prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return new CallableStatementWrapper(this.connection.prepareCall(sql, resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public CallableStatementWrapper prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            return new CallableStatementWrapper(this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PreparedStatementWrapper prepareStatement(String sql) {
        try {
            return new PreparedStatementWrapper(this.connection.prepareStatement(sql), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PreparedStatementWrapper prepareStatement(String sql, int autoGeneratedKeys) {
        try {
            return new PreparedStatementWrapper(this.connection.prepareStatement(sql, autoGeneratedKeys), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PreparedStatementWrapper prepareStatement(String sql, int[] columnIndexes) {
        try {
            return new PreparedStatementWrapper(this.connection.prepareStatement(sql, columnIndexes), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PreparedStatementWrapper prepareStatement(String sql, String[] columnNames) {
        try {
            return new PreparedStatementWrapper(this.connection.prepareStatement(sql, columnNames), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PreparedStatementWrapper prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return new PreparedStatementWrapper(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public PreparedStatementWrapper prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        try {
            return new PreparedStatementWrapper(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) {
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void rollback(Savepoint savepoint) {
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setCatalog(String catalog) {
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setClientInfo(Properties properties) {
        try {
            this.connection.setClientInfo(properties);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.connection.setClientInfo(name, value);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setHoldability(int holdability) {
        try {
            this.connection.setHoldability(holdability);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setReadOnly(boolean readOnly) {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Savepoint setSavepoint() {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public Savepoint setSavepoint(String name) {
        try {
            return this.connection.setSavepoint(name);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setTransactionIsolation(int level) {
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public void setTypeMap(Map<String, Class<?>> map) {
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public boolean isWrapperFor(Class<?> iface) {
        try {
            return this.connection.isWrapperFor(iface);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public <T> T unwrap(Class<T> iface) {
        try {
            return this.connection.unwrap(iface);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public ConnectionWrapper getConnection() {
        return new ConnectionWrapper(this.connection);
    }
}

