/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.matcher.BeanPropertyAnnotationMatcher;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import cn.featherfly.common.bean.matcher.BeanPropertyNameRegexMatcher;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.enums.Logic;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.SystemPropertyUtils;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.ClassNameConversion;
import cn.featherfly.common.repository.mapping.ClassNameJpaConversion;
import cn.featherfly.common.repository.mapping.ClassNameUnderlineConversion;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.repository.mapping.PropertyNameConversion;
import cn.featherfly.common.repository.mapping.PropertyNameJpaConversion;
import cn.featherfly.common.repository.mapping.PropertyNameUnderlineConversion;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMappingFactory
implements MappingFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcMappingFactory.class);
    private final Map<Class<?>, ClassMapping<?>> mappedTypes = new HashMap();
    private DatabaseMetadata metadata;
    private Dialect dialect;
    private List<ClassNameConversion> classNameConversions = new ArrayList<ClassNameConversion>();
    private List<PropertyNameConversion> propertyNameConversions = new ArrayList<PropertyNameConversion>();
    private SqlTypeMappingManager sqlTypeMappingManager;

    public JdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect) {
        this.metadata = metadata;
        this.dialect = dialect;
        this.getClassNameConversions().add((ClassNameConversion)new ClassNameJpaConversion());
        this.getClassNameConversions().add((ClassNameConversion)new ClassNameUnderlineConversion());
        this.getPropertyNameConversions().add((PropertyNameConversion)new PropertyNameJpaConversion());
        this.getPropertyNameConversions().add((PropertyNameConversion)new PropertyNameUnderlineConversion());
        this.sqlTypeMappingManager = new SqlTypeMappingManager();
    }

    public JdbcMappingFactory(DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        this.metadata = metadata;
        this.dialect = dialect;
        this.classNameConversions.addAll(classNameConversions);
        this.propertyNameConversions.addAll(propertyNameConversions);
        this.sqlTypeMappingManager = new SqlTypeMappingManager();
    }

    public List<ClassNameConversion> getClassNameConversions() {
        return this.classNameConversions;
    }

    public void setClassNameConversions(List<ClassNameConversion> classNameConversions) {
        this.classNameConversions = classNameConversions;
    }

    public List<PropertyNameConversion> getPropertyNameConversions() {
        return this.propertyNameConversions;
    }

    public void setPropertyNameConversions(List<PropertyNameConversion> propertyNameConversions) {
        this.propertyNameConversions = propertyNameConversions;
    }

    public DatabaseMetadata getMetadata() {
        return this.metadata;
    }

    public <T> ClassMapping<T> getClassMapping(Class<T> type) {
        Object classMapping = this.mappedTypes.get(type);
        if (classMapping == null) {
            classMapping = this.createClassMapping(type);
            this.mappedTypes.put(type, (ClassMapping<?>)classMapping);
        }
        return classMapping;
    }

    private <T> ClassMapping<T> createClassMapping(Class<T> type) {
        Table tm;
        HashMap<String, PropertyMapping> tableMapping = new HashMap<String, PropertyMapping>();
        StringBuilder logInfo = new StringBuilder();
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor(type);
        String tableName = this.getMappingTableName(type);
        tableName = this.dialect.convertTableOrColumnName(tableName);
        if (LOGGER.isDebugEnabled()) {
            logInfo.append(String.format("###%s\u7c7b%s\u6620\u5c04\u5230\u8868%s", SystemPropertyUtils.getLineSeparator(), type.getName(), tableName));
        }
        if ((tm = this.metadata.getTable(tableName)) == null) {
            throw new JdbcMappingException("#talbe.not.exists", new Object[]{tableName});
        }
        Collection bps = bd.findBeanPropertys((BeanPropertyMatcher)new BeanPropertyAnnotationMatcher(Logic.OR, new Class[]{Column.class, Id.class, Embedded.class}));
        boolean findPk = false;
        for (BeanProperty beanProperty : bps) {
            if (!this.mappingWithJpa(beanProperty, tableMapping, logInfo, tm)) continue;
            findPk = true;
        }
        if (!findPk) {
            throw new JdbcMappingException("#id.map.not.exists", new Object[]{type.getName()});
        }
        for (cn.featherfly.common.db.metadata.Column cmd : tm.getColumns()) {
            this.mappingFromColumnMetadata(bd, tableMapping, cmd, logInfo);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(logInfo.toString());
        }
        ClassMapping classMapping = new ClassMapping(type, tableName, tm.getRemark());
        classMapping.addPropertyMappings((Collection)tableMapping.values().stream().sorted((p1, p2) -> p1.getIndex() < p2.getIndex() ? -1 : 1).collect(Collectors.toList()));
        return classMapping;
    }

    private boolean mappingWithJpa(BeanProperty<?> beanProperty, Map<String, PropertyMapping> tableMapping, StringBuilder logInfo, Table tableMetadata) {
        boolean isPk = beanProperty.hasAnnotation(Id.class);
        PropertyMapping mapping = new PropertyMapping();
        Embedded embedded = (Embedded)beanProperty.getAnnotation(Embedded.class);
        if (embedded != null) {
            this.mappinEmbedded(mapping, beanProperty, logInfo, tableMetadata);
            tableMapping.put(mapping.getRepositoryFieldName(), mapping);
        } else {
            String columnName = this.getMappingColumnName(beanProperty);
            if (LangUtils.isNotEmpty((String)columnName)) {
                columnName = this.dialect.convertTableOrColumnName(columnName);
                mapping.setPropertyName(beanProperty.getName());
                mapping.setPropertyType(beanProperty.getType());
                mapping.setPrimaryKey(isPk);
                ManyToOne manyToOne = (ManyToOne)beanProperty.getAnnotation(ManyToOne.class);
                OneToOne oneToOne = (OneToOne)beanProperty.getAnnotation(OneToOne.class);
                if (manyToOne != null || oneToOne != null) {
                    mapping.setRepositoryFieldName(columnName);
                    this.mappingFk(mapping, beanProperty, columnName, isPk, logInfo);
                } else {
                    mapping.setRepositoryFieldName(columnName);
                    this.setColumnMapping(mapping, beanProperty);
                }
                tableMapping.put(mapping.getRepositoryFieldName(), mapping);
                if (LOGGER.isDebugEnabled()) {
                    logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName(), mapping.getRepositoryFieldName()));
                }
            }
        }
        return isPk;
    }

    private void mappinEmbedded(PropertyMapping mapping, BeanProperty<?> beanProperty, StringBuilder logInfo, Table tableMetadata) {
        mapping.setPropertyName(beanProperty.getName());
        mapping.setPropertyType(beanProperty.getType());
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor((Class)beanProperty.getType());
        Collection bps = bd.getBeanProperties();
        for (BeanProperty bp : bps) {
            String columnName = this.getMappingColumnName(bp);
            columnName = this.dialect.convertTableOrColumnName(columnName);
            PropertyMapping columnMpping = new PropertyMapping();
            columnMpping.setRepositoryFieldName(columnName);
            columnMpping.setPropertyType(bp.getType());
            columnMpping.setPropertyName(bp.getName());
            Column column = (Column)bp.getAnnotation(Column.class);
            if (column != null) {
                if (LOGGER.isDebugEnabled()) {
                    logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName() + "." + columnMpping.getPropertyName(), columnMpping.getRepositoryFieldName()));
                }
                this.setColumnMapping(mapping, beanProperty);
                mapping.add(columnMpping);
                continue;
            }
            cn.featherfly.common.db.metadata.Column columnMetadata = tableMetadata.getColumn(columnName);
            if (columnMetadata != null) {
                mapping.add(columnMpping);
                if (!LOGGER.isDebugEnabled()) continue;
                logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), columnMpping.getPropertyName(), columnMpping.getRepositoryFieldName()));
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            logInfo.append(String.format("%s\t\u6ca1\u6709\u5c5e\u6027 -> %s [\u5217%s\u7684\u9690\u5f0f\u6620\u5c04]", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName() + "." + bp.getName(), columnName));
        }
    }

    private void setColumnMapping(PropertyMapping mapping, BeanProperty<?> beanProperty) {
        Column column = (Column)beanProperty.getAnnotation(Column.class);
        if (column != null) {
            mapping.setNullable(column.nullable());
            mapping.setSize(beanProperty.getType() == String.class ? column.length() : column.precision());
            mapping.setDecimalDigits(column.scale());
            mapping.setInsertable(column.insertable());
            mapping.setUpdatable(column.updatable());
            mapping.setUnique(column.unique());
        }
    }

    private void mappingFk(PropertyMapping mapping, BeanProperty<?> beanProperty, String columnName, boolean hasPk, StringBuilder logInfo) {
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor((Class)beanProperty.getType());
        Collection bps = bd.findBeanPropertys((BeanPropertyMatcher)new BeanPropertyAnnotationMatcher(new Class[]{Id.class}));
        if (LangUtils.isEmpty((Collection)bps)) {
            throw new JdbcMappingException("#no.id.property", new Object[]{beanProperty.getType().getName()});
        }
        for (BeanProperty bp : bps) {
            PropertyMapping columnMpping = new PropertyMapping();
            columnMpping.setRepositoryFieldName(columnName);
            columnMpping.setPropertyType(bp.getType());
            columnMpping.setPropertyName(bp.getName());
            columnMpping.setPrimaryKey(hasPk);
            if (LOGGER.isDebugEnabled()) {
                logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName() + "." + columnMpping.getPropertyName(), columnMpping.getRepositoryFieldName()));
            }
            mapping.add(columnMpping);
        }
    }

    private <T> void mappingFromColumnMetadata(BeanDescriptor<T> bd, Map<String, PropertyMapping> tableMapping, cn.featherfly.common.db.metadata.Column cmd, StringBuilder logInfo) {
        HashMap nameSet = new HashMap();
        tableMapping.forEach((k, v) -> {
            if (LangUtils.isNotEmpty((String)k)) {
                nameSet.put(k, v);
            } else if (LangUtils.isNotEmpty((Collection)v.getPropertyMappings())) {
                v.getPropertyMappings().forEach(pm -> nameSet.put(pm.getRepositoryFieldName(), pm));
            }
        });
        if (!nameSet.containsKey(cmd.getName())) {
            String columnName = cmd.getName().toLowerCase();
            String propertyName = WordUtils.parseToUpperFirst((String)columnName, (char)'_');
            BeanProperty beanProperty = bd.findBeanProperty((BeanPropertyMatcher)new BeanPropertyNameRegexMatcher(propertyName));
            if (beanProperty != null && !beanProperty.hasAnnotation(Transient.class)) {
                PropertyMapping mapping = new PropertyMapping();
                mapping.setPropertyType(beanProperty.getType());
                mapping.setPropertyName(propertyName);
                mapping.setRepositoryFieldName(this.dialect.convertTableOrColumnName(columnName));
                mapping.setRemark(cmd.getRemark());
                mapping.setNullable(cmd.isNullable());
                mapping.setDecimalDigits(cmd.getDecimalDigits());
                mapping.setAutoincrement(cmd.isAutoincrement());
                mapping.setSize(cmd.getSize());
                mapping.setPrimaryKey(cmd.isPrimaryKey());
                mapping.setDefaultValue(cmd.getDefaultValue());
                mapping.setIndex(cmd.getColumnIndex());
                tableMapping.put(mapping.getRepositoryFieldName(), mapping);
                if (LOGGER.isDebugEnabled()) {
                    logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName(), mapping.getRepositoryFieldName()));
                }
            } else if (LOGGER.isDebugEnabled()) {
                logInfo.append(String.format("%s\t\u6ca1\u6709\u5c5e\u6027 -> %s [\u5217%s\u7684\u9690\u5f0f\u6620\u5c04]", SystemPropertyUtils.getLineSeparator(), propertyName, cmd.getName()));
            }
        } else {
            PropertyMapping mapping = (PropertyMapping)nameSet.get(cmd.getName());
            mapping.setPrimaryKey(cmd.isPrimaryKey());
            mapping.setDefaultValue(cmd.getDefaultValue());
            mapping.setRemark(cmd.getRemark());
            mapping.setNullable(cmd.isNullable());
            mapping.setDecimalDigits(cmd.getDecimalDigits());
            mapping.setAutoincrement(cmd.isAutoincrement());
            mapping.setSize(cmd.getSize());
            mapping.setIndex(cmd.getColumnIndex());
        }
    }

    private String getMappingTableName(Class<?> type) {
        String tableName = null;
        for (ClassNameConversion classNameConversion : this.classNameConversions) {
            tableName = classNameConversion.getMappingName(type);
            if (!LangUtils.isNotEmpty((String)tableName)) continue;
            return tableName;
        }
        return tableName;
    }

    private String getMappingColumnName(BeanProperty<?> type) {
        String columnName = null;
        for (PropertyNameConversion propertyNameConversion : this.propertyNameConversions) {
            columnName = propertyNameConversion.getMappingName(type);
            if (!LangUtils.isNotEmpty((String)columnName)) continue;
            return columnName;
        }
        return columnName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public SqlTypeMappingManager getSqlTypeMappingManager() {
        return this.sqlTypeMappingManager;
    }

    public static enum MappingMode {
        OBJ_DB_MIXED,
        OBJ_TO_DB_STRICT;

    }
}

