/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data.format;

import cn.featherfly.common.db.data.DataFormat;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.lang.DateUtils;
import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class SqlDataFormat
implements DataFormat {
    private Writer writer;
    private Dialect dialect;

    public SqlDataFormat(Writer writer, Dialect dialect) {
        this.writer = writer;
        this.dialect = dialect;
    }

    @Override
    public void writeDataStart(DatabaseMetadata databaseMetadata) throws IOException {
        Date now = new Date();
        StringBuilder descp = new StringBuilder();
        descp.append("/*==============================================================*/\n").append("/*\t").append("\t start at -> ").append(DateUtils.formartTime((Date)now)).append("\t timestamp -> ").append(now.getTime()).append("\t*/\n").append("/*==============================================================*/\n").append("\n\n\n");
        this.writer.write(descp.toString());
    }

    @Override
    public void writeDataEnd(DatabaseMetadata databaseMetadata) throws IOException {
        Date now = new Date();
        StringBuilder descp = new StringBuilder();
        descp.append("\n\n\n").append("/*==============================================================*/\n").append("/*\t").append("\t end at -> ").append(DateUtils.formartTime((Date)now)).append("\t timestamp -> ").append(now.getTime()).append("\t*/\n").append("/*==============================================================*/\n");
        this.writer.write(descp.toString());
        this.writer.close();
    }

    @Override
    public void writeTableStart(Table tableMetadata) throws Exception {
        Date now = new Date();
        StringBuilder tableDescp = new StringBuilder();
        tableDescp.append("/*==============================================================*/\n").append("/*\t").append(tableMetadata.getName()).append("\t start at -> ").append(DateUtils.formartTime((Date)now)).append("\t timestamp -> ").append(now.getTime()).append("\t*/\n").append("/*--------------------------------------------------------------*/\n");
        this.writer.write(tableDescp.toString());
    }

    @Override
    public void writeTableEnd(Table tableMetadata) throws Exception {
        Date now = new Date();
        StringBuilder tableDescp = new StringBuilder();
        tableDescp.append("/*--------------------------------------------------------------*/\n").append("/*\t").append(tableMetadata.getName()).append("\t end at -> ").append(DateUtils.formartTime((Date)now)).append("\t timestamp -> ").append(now.getTime()).append("\t*/\n").append("/*==============================================================*/\n").append("\n\n");
        this.writer.write(tableDescp.toString());
    }

    @Override
    public void writeRow(Table tableMetadata, ResultSet res) throws Exception {
        ResultSetMetaData rsmd = res.getMetaData();
        int columnTotal = rsmd.getColumnCount();
        String tableName = tableMetadata.getName();
        ArrayList rows = new ArrayList();
        StringBuilder insertSql = new StringBuilder();
        HashMap row = new HashMap();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        values.append(" VALUES ( ");
        columns.append(" ( ");
        for (int i = 1; i <= columnTotal; ++i) {
            HashMap<String, Object> column = new HashMap<String, Object>();
            String columnName = rsmd.getColumnName(i);
            Object value = res.getObject(columnName);
            int type = rsmd.getColumnType(i);
            columns.append(this.getDialect().wrapName(columnName.toUpperCase())).append(",");
            values.append(this.getDialect().valueToSql(value, type)).append(",");
            column.put("name", columnName);
            column.put("value", value);
            column.put("type", type);
            row.put(columnName, column);
        }
        rows.add(row);
        if (columns.lastIndexOf(",") + 1 == columns.length()) {
            columns.deleteCharAt(columns.length() - 1);
        }
        columns.append(" )");
        if (values.lastIndexOf(",") + 1 == values.length()) {
            values.deleteCharAt(values.length() - 1);
        }
        values.append(" )");
        columns.append(values.toString());
        insertSql.append("INSERT INTO ").append(this.getDialect().wrapName(tableName.toUpperCase())).append((CharSequence)columns).append(";\n");
        this.writer.write(insertSql.toString());
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

