/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.data.AbstractDataExportor;
import cn.featherfly.common.db.data.DataFormat;
import cn.featherfly.common.db.data.DataFormatFactory;
import cn.featherfly.common.db.data.ExportException;
import cn.featherfly.common.db.data.query.SimpleQuery;
import cn.featherfly.common.db.data.query.TableQuery;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.repository.Query;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;

public class DataExportorImpl
extends AbstractDataExportor {
    private DataFormatFactory facotry;

    public DataExportorImpl(Dialect dialect, DataFormatFactory facotry) {
        super(dialect);
        this.facotry = facotry;
    }

    @Override
    public void exportData(Writer writer, Collection<Query> querys) {
        try {
            DatabaseMetadata databaseMetadata = this.getDatabaseMetadata();
            DataFormat dataFormat = this.facotry.createDataFormat(writer, this.getDialect());
            dataFormat.writeDataStart(databaseMetadata);
            for (Query query : querys) {
                this.exportData(query, dataFormat);
            }
            dataFormat.writeDataEnd(databaseMetadata);
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    private void exportData(Query query, DataFormat dataFormat) throws Exception {
        Connection conn = this.getDataSource().getConnection();
        PreparedStatement prep = conn.prepareStatement(query.getExecution());
        if (LangUtils.isNotEmpty((Object[])query.getParams())) {
            JdbcUtils.setParameters(prep, query.getParams());
        }
        ResultSet res = prep.executeQuery();
        ResultSetMetaData rsmd = res.getMetaData();
        String name = null;
        if (query instanceof SimpleQuery) {
            name = ((SimpleQuery)query).getName();
        } else if (query instanceof TableQuery) {
            name = ((TableQuery)query).getName();
        }
        if (LangUtils.isEmpty((String)name)) {
            name = rsmd.getTableName(1);
            if (LangUtils.isEmpty((String)name)) {
                throw new ExportException("#driver.resultset.tablename");
            }
            this.logger.debug("\u81ea\u52a8\u4ece\u7ed3\u679c\u96c6\u7b2c\u4e00\u5217\u83b7\u53d6\u8868\u540d\u79f0\uff1a{}", (Object)name);
        }
        Table tableMetadata = this.getDatabaseMetadata().getTable(name);
        dataFormat.writeTableStart(tableMetadata);
        while (res.next()) {
            dataFormat.writeRow(tableMetadata, res);
        }
        dataFormat.writeTableEnd(tableMetadata);
        JdbcUtils.closeQuietly(conn, prep, res);
    }
}

