/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.data.ExportException;
import cn.featherfly.common.db.data.ImportException;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.lang.LangUtils;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataImpExp {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource;
    protected Dialect dialect;

    protected AbstractDataImpExp(Dialect dialect) {
        this.dialect = dialect;
    }

    protected String getTableQuerySql(String tableName) {
        return "select * from " + tableName;
    }

    public Dialect getDialect() {
        if (this.dialect == null) {
            throw new ImportException("#dialect.null");
        }
        return this.dialect;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new ExportException("#dataSource.null");
        }
        return this.dataSource;
    }

    protected DatabaseMetadata getDatabaseMetadata() {
        return DatabaseMetadataManager.getDefaultManager().create(this.getDataSource(), this.getCheckedDatabase());
    }

    private String getCheckedDatabase() {
        String database = JdbcUtils.getCatalog(this.getDataSource());
        if (LangUtils.isEmpty((String)database) && (database = JdbcUtils.getCatalog(this.getDataSource())) == null) {
            throw new ExportException("#database.null");
        }
        return database;
    }

    protected String getValueToSql(String value, int type, String isNull) {
        String v = null;
        v = "1".equals(isNull) && LangUtils.isEmpty((String)value) ? "null" : this.getDialect().valueToSql(value, type);
        return v;
    }

    protected int getType(String strType) {
        int type = 12;
        try {
            type = Integer.parseInt(strType);
        }
        catch (Exception e) {
            this.logger.warn("\u8f6c\u6362sql\u7c7b\u578b\u5931\u8d25\uff0c\u76ee\u6807\u7c7b\u578b -> " + strType);
        }
        return type;
    }
}

