/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml.basic;

import cn.featherfly.common.db.builder.SqlBuilder;
import cn.featherfly.common.db.builder.model.SelectColumnElement;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.mapping.ClassMappingUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.repository.builder.AliasManager;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.operate.AggregateFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlSelectColumnsBasicBuilder
implements SqlBuilder {
    protected String tableAlias;
    protected List<SelectColumnElement> columns = new ArrayList<SelectColumnElement>(0);
    protected Dialect dialect;
    protected ClassMapping<?> classMapping;
    protected Map<String, String> fetchProperties = new HashMap<String, String>(0);
    protected MappingFactory mappingFactory;

    public SqlSelectColumnsBasicBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public SqlSelectColumnsBasicBuilder(Dialect dialect, String tableAlias) {
        this.dialect = dialect;
        this.tableAlias = tableAlias;
    }

    public SqlSelectColumnsBasicBuilder(Dialect dialect, ClassMapping<?> classMapping, MappingFactory mappingFactory) {
        this(dialect, classMapping, AliasManager.generateAlias((String)classMapping.getRepositoryName()), mappingFactory);
    }

    public SqlSelectColumnsBasicBuilder(Dialect dialect, ClassMapping<?> classMapping, String tableAlias, MappingFactory mappingFactory) {
        this.dialect = dialect;
        this.classMapping = classMapping;
        this.tableAlias = tableAlias;
        this.mappingFactory = mappingFactory;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public SqlSelectColumnsBasicBuilder addSelectColumn(String column, AggregateFunction aggregateFunction) {
        this.columns.add(new SelectColumnElement(this.dialect, column, this.tableAlias, aggregateFunction));
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectColumn(String column, AggregateFunction aggregateFunction, String asName) {
        this.columns.add(new SelectColumnElement(this.dialect, column, this.tableAlias, aggregateFunction, asName));
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectColumn(String column) {
        this.columns.add(new SelectColumnElement(this.dialect, column, this.tableAlias));
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectColumn(String column, String asName) {
        this.columns.add(new SelectColumnElement(this.dialect, column, this.tableAlias, asName));
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectColumns(String ... columns) {
        for (String c : columns) {
            this.addSelectColumn(c);
        }
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectColumns(Collection<String> columns) {
        for (String c : columns) {
            this.addSelectColumn(c);
        }
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectProperty(String propertyName, String aliasName) {
        this.fetchProperties.put(propertyName, aliasName);
        return this;
    }

    public SqlSelectColumnsBasicBuilder addSelectProperties(Map<String, String> properties) {
        this.fetchProperties.putAll(properties);
        return this;
    }

    public String build() {
        StringBuilder columnsBuilder = new StringBuilder();
        if (this.columns.isEmpty()) {
            if (this.classMapping == null) {
                if (LangUtils.isEmpty((String)this.tableAlias)) {
                    columnsBuilder.append("*");
                } else {
                    columnsBuilder.append(this.tableAlias).append(".").append("*");
                }
            } else if (this.fetchProperties.isEmpty()) {
                columnsBuilder.append(ClassMappingUtils.getSelectColumnsSql(this.classMapping, this.tableAlias, this.dialect));
            } else {
                columnsBuilder.append(ClassMappingUtils.getSelectColumnsSql(this.classMapping, this.tableAlias, this.dialect, this.mappingFactory, this.fetchProperties));
            }
        } else {
            for (SelectColumnElement column : this.columns) {
                column.setTableAlias(this.tableAlias);
                columnsBuilder.append(column).append(",").append(" ");
            }
            columnsBuilder.delete(columnsBuilder.length() - 2, columnsBuilder.length());
        }
        return columnsBuilder.toString();
    }
}

