/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.ddl;

import cn.featherfly.common.db.metadata.Column;
import cn.featherfly.common.db.metadata.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableModel
implements Table {
    private String type;
    private String name;
    private String remark;
    private String catalog;
    private List<Column> primaryColumns = new ArrayList<Column>(1);
    private Map<String, Column> columnMap = new LinkedHashMap<String, Column>(0);

    @Override
    public String getType() {
        return this.type;
    }

    public TableModel setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TableModel setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    public TableModel setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public TableModel setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.columnMap.get(columnName.toUpperCase());
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columnMap.values();
    }

    @Override
    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    public TableModel addColumn(Column column) {
        if (column.isPrimaryKey()) {
            this.primaryColumns.add(column);
        }
        this.columnMap.put(column.getName().toUpperCase(), column);
        return this;
    }

    public TableModel addColumn(Column ... columns) {
        for (Column columnMetadata : columns) {
            this.addColumn(columnMetadata);
        }
        return this;
    }

    public TableModel addColumn(Collection<Column> columns) {
        for (Column columnMetadata : columns) {
            this.addColumn(columnMetadata);
        }
        return this;
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return this.primaryColumns;
    }
}

