/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.metadata;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.metadata.ColumnMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataException;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.db.metadata.TableMetadata;
import cn.featherfly.common.db.metadata.TableType;
import cn.featherfly.common.lang.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseMetadataManager.class);
    private final Map<String, DatabaseMetadata> databasemetadataPool = new HashMap<String, DatabaseMetadata>(0);
    private static final DatabaseMetadataManager DEFAULT_MANAGER = new DatabaseMetadataManager();
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("[a-zA-Z-_0-9]+");

    public DatabaseMetadata getDatabaseMetadata(String dataBase) {
        return this.databasemetadataPool.get(dataBase);
    }

    public synchronized DatabaseMetadata create(DataSource dataSource) {
        return this.create(JdbcUtils.getConnection(dataSource));
    }

    public synchronized DatabaseMetadata create(Connection connection) {
        return this.create(connection, this.getDatabase(connection));
    }

    public DatabaseMetadata create(Connection connection, String dataBase) {
        return this.create(connection, dataBase, false);
    }

    public synchronized DatabaseMetadata create(DataSource dataSource, String dataBase) {
        return this.create(JdbcUtils.getConnection(dataSource), dataBase);
    }

    public synchronized DatabaseMetadata reCreate(Connection connection) {
        return this.reCreate(connection, this.getDatabase(connection));
    }

    public synchronized DatabaseMetadata reCreate(DataSource dataSource) {
        return this.reCreate(JdbcUtils.getConnection(dataSource));
    }

    public synchronized DatabaseMetadata reCreate(DataSource dataSource, String dataBase) {
        return this.reCreate(JdbcUtils.getConnection(dataSource), dataBase);
    }

    public synchronized DatabaseMetadata reCreate(Connection connection, String dataBase) {
        return this.create(connection, dataBase, true);
    }

    private String getDatabase(Connection connection) {
        String catalog = JdbcUtils.getCatalog(connection);
        if (StringUtils.isEmpty((String)catalog)) {
            throw new DatabaseMetadataException("#driver.not.support.catalog");
        }
        return catalog;
    }

    private synchronized DatabaseMetadata create(Connection connection, String dataBase, boolean reCreate) {
        try {
            DatabaseMetadata databaseMetadata = this.getDatabaseMetadata(dataBase);
            if (databaseMetadata != null && !reCreate) {
                DatabaseMetadata databaseMetadata2 = databaseMetadata;
                return databaseMetadata2;
            }
            databaseMetadata = new DatabaseMetadata();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet rs = null;
            rs = metaData.getTables(dataBase, null, null, new String[]{TableType.TABLE.toString()});
            String remarks = "REMARKS";
            String columnName = "COLUMN_NAME";
            boolean hasDatabase = false;
            while (rs.next()) {
                hasDatabase = true;
                TableMetadata tableMetadata = new TableMetadata(databaseMetadata);
                String tableName = rs.getString("TABLE_NAME");
                tableMetadata.setName(tableName);
                if (!TABLE_NAME_PATTERN.matcher(tableName).matches()) {
                    LOGGER.debug("{} \u4e0d\u662f\u7528\u6237\u8868, \u5ffd\u7565\uff01", (Object)tableName);
                    continue;
                }
                tableMetadata.setType(rs.getString("TABLE_TYPE"));
                String tableCat = rs.getString("TABLE_CAT");
                if (tableCat != null) {
                    tableMetadata.setCatalog(tableCat);
                } else {
                    tableMetadata.setCatalog(dataBase);
                }
                tableMetadata.setRemark(rs.getString("REMARKS"));
                databaseMetadata.addTable((Table)tableMetadata);
                ResultSet rp = metaData.getPrimaryKeys(dataBase, null, tableMetadata.getName());
                HashSet<String> pkColumnNames = new HashSet<String>();
                while (rp.next()) {
                    pkColumnNames.add(rp.getString("COLUMN_NAME"));
                }
                rp.close();
                ResultSet rc = metaData.getColumns(dataBase, null, tableMetadata.getName(), null);
                while (rc.next()) {
                    ColumnMetadata columnMetadata = new ColumnMetadata(tableMetadata);
                    columnMetadata.setName(rc.getString("COLUMN_NAME"));
                    columnMetadata.setType(rc.getInt("DATA_TYPE"));
                    columnMetadata.setTypeName(rc.getString("TYPE_NAME"));
                    columnMetadata.setRemark(rc.getString("REMARKS"));
                    columnMetadata.setSize(rc.getInt("COLUMN_SIZE"));
                    columnMetadata.setDecimalDigits(rc.getInt("DECIMAL_DIGITS"));
                    columnMetadata.setDefaultValue(rc.getString("COLUMN_DEF"));
                    int nullable = rc.getInt("NULLABLE");
                    if (1 == nullable) {
                        columnMetadata.setNullable(true);
                    } else {
                        columnMetadata.setNullable(false);
                    }
                    String isAutoincrement = rc.getString("IS_AUTOINCREMENT");
                    if ("YES".equals(isAutoincrement)) {
                        columnMetadata.setAutoincrement(true);
                    } else {
                        columnMetadata.setAutoincrement(false);
                    }
                    columnMetadata.setColumnIndex(rc.getInt("ORDINAL_POSITION"));
                    if (pkColumnNames.contains(columnMetadata.getName())) {
                        columnMetadata.setPrimaryKey(true);
                    }
                    tableMetadata.addColumn(columnMetadata);
                }
                rc.close();
            }
            rs.close();
            if (!hasDatabase) {
                throw new DatabaseMetadataException("#driver.not.find.database", new Object[]{dataBase});
            }
            this.databasemetadataPool.put(dataBase, databaseMetadata);
            databaseMetadata.setName(dataBase);
            databaseMetadata.setProductName(metaData.getDatabaseProductName());
            databaseMetadata.setProductVersion(metaData.getDatabaseProductVersion());
            databaseMetadata.setMajorVersion(metaData.getDatabaseMajorVersion());
            databaseMetadata.setMinorVersion(metaData.getDatabaseMinorVersion());
            DatabaseMetadata databaseMetadata3 = databaseMetadata;
            return databaseMetadata3;
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    public static DatabaseMetadataManager getDefaultManager() {
        return DEFAULT_MANAGER;
    }
}

