/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.metadata;

import cn.featherfly.common.db.metadata.Column;
import cn.featherfly.common.db.metadata.SqlType;
import cn.featherfly.common.db.metadata.TableMetadata;

public class ColumnMetadata
implements Column {
    private TableMetadata tableMetadata;
    private String name;
    private int type;
    private String typeName;
    private int size;
    private String remark;
    private String defaultValue;
    private boolean nullable;
    private int columnIndex;
    private boolean primaryKey;
    private SqlType sqlType;
    private int decimalDigits;
    private boolean autoincrement;

    public ColumnMetadata(TableMetadata tableMetadata) {
        this.tableMetadata = tableMetadata;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getName() != null && this.getName().length() > 0) {
            byte[] bs;
            for (byte b : bs = this.getName().getBytes()) {
                hashCode += b;
            }
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ColumnMetadata cm = (ColumnMetadata)obj;
            if (this.getTableMetadata() == null || !this.getTableMetadata().equals(cm.getTableMetadata())) {
                return false;
            }
            return this.getName().equals(cm.getName());
        }
        return false;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public int getType() {
        return this.type;
    }

    void setType(int type) {
        this.type = type;
        this.sqlType = SqlType.value(type);
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    void setSize(int size) {
        this.size = size;
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    @Override
    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    void setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
        this.type = sqlType.getValue();
    }
}

