/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.MappingFactory;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import com.speedment.common.tuple.Tuple2;
import com.speedment.common.tuple.Tuples;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClassMappingUtils {
    public static String getSelectSql(ClassMapping<?> classMapping, Dialect dialect) {
        return ClassMappingUtils.getSelectSql(classMapping, null, dialect);
    }

    public static String getSelectSql(ClassMapping<?> classMapping, String alias, Dialect dialect) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ");
        selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, alias, dialect));
        selectSql.append(" from ").append(classMapping.getRepositoryName());
        return selectSql.toString();
    }

    public static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, Dialect dialect) {
        return ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, "", dialect);
    }

    public static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, String prefixPropertyName, Dialect dialect) {
        return ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, prefixPropertyName, dialect, null, new HashMap<String, String>(0));
    }

    public static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, Dialect dialect, MappingFactory mappingFactory, Map<String, String> fetchProperties) {
        return ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, null, dialect, mappingFactory, fetchProperties);
    }

    private static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, String prefixPropertyName, Dialect dialect, MappingFactory mappingFactory, Map<String, String> fetchProperties) {
        StringBuilder selectSql = new StringBuilder();
        int columnNum = 0;
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, propertyMapping, prefixPropertyName, dialect));
                ++columnNum;
                continue;
            }
            boolean fetchAble = false;
            String fetchPropertyTableAlia = null;
            if (LangUtils.isNotEmpty(fetchProperties)) {
                for (Map.Entry<String, String> entry : fetchProperties.entrySet()) {
                    fetchPropertyTableAlia = entry.getValue();
                    if (!propertyMapping.getPropertyName().equals(entry.getKey())) continue;
                    fetchAble = true;
                    break;
                }
            }
            if (fetchAble) {
                ClassMapping pcm = mappingFactory.getClassMapping(propertyMapping.getPropertyType());
                for (PropertyMapping pm : pcm.getPropertyMappings()) {
                    selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, fetchPropertyTableAlia, pm, propertyMapping, dialect));
                    ++columnNum;
                }
            } else {
                for (PropertyMapping propertyMapping2 : propertyMapping.getPropertyMappings()) {
                    selectSql.append(ClassMappingUtils.getSelectColumnsSql(classMapping, tableAlias, propertyMapping2, prefixPropertyName, dialect));
                    ++columnNum;
                }
            }
            fetchAble = false;
        }
        if (columnNum > 0) {
            selectSql.delete(selectSql.length() - 2, selectSql.length());
        }
        return selectSql.toString();
    }

    private static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, PropertyMapping propertyMapping, String prefixPropertyName, Dialect dialect) {
        StringBuilder selectSql = new StringBuilder();
        if (StringUtils.isNotBlank((String)tableAlias)) {
            selectSql.append(tableAlias).append(".");
        }
        selectSql.append(dialect.wrapName(propertyMapping.getRepositoryFieldName())).append(" ").append(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, prefixPropertyName, dialect)).append(",").append(" ");
        return selectSql.toString();
    }

    private static String getSelectColumnsSql(ClassMapping<?> classMapping, String tableAlias, PropertyMapping propertyMapping, PropertyMapping nestedPropertyMapping, Dialect dialect) {
        StringBuilder selectSql = new StringBuilder();
        if (StringUtils.isNotBlank((String)tableAlias)) {
            selectSql.append(tableAlias).append(".");
        }
        selectSql.append(dialect.wrapName(propertyMapping.getRepositoryFieldName())).append(" ").append(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, nestedPropertyMapping, dialect)).append(",").append(" ");
        return selectSql.toString();
    }

    public static String getPropertyAliasName(PropertyMapping propertyMapping) {
        return ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, "");
    }

    private static String getNestedPropertyAliasName(PropertyMapping propertyMapping, PropertyMapping nestedPropertyMapping) {
        String prefixPropertyName = null;
        if (nestedPropertyMapping != null) {
            prefixPropertyName = nestedPropertyMapping.getPropertyName();
        }
        return ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, prefixPropertyName);
    }

    private static String getNestedPropertyAliasName(PropertyMapping pm, String prefixPropertyName) {
        PropertyMapping propertyMapping = pm;
        if (!propertyMapping.getPropertyMappings().isEmpty()) {
            propertyMapping = (PropertyMapping)propertyMapping.getPropertyMappings().get(0);
        }
        String propertyName = propertyMapping.getPropertyName();
        if (propertyMapping.getParent() != null) {
            propertyName = propertyMapping.getParent().getPropertyName() + "." + propertyMapping.getPropertyName();
        }
        if (LangUtils.isNotEmpty((String)prefixPropertyName)) {
            propertyName = prefixPropertyName + "." + propertyName;
        }
        return propertyName;
    }

    public static String getPropertyAliasName(PropertyMapping propertyMapping, Dialect dialect) {
        return dialect.wrapName(ClassMappingUtils.getPropertyAliasName(propertyMapping));
    }

    private static String getNestedPropertyAliasName(PropertyMapping propertyMapping, String prefixPropertyName, Dialect dialect) {
        return dialect.wrapName(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, prefixPropertyName));
    }

    private static String getNestedPropertyAliasName(PropertyMapping propertyMapping, PropertyMapping nestedPropertyMapping, Dialect dialect) {
        return dialect.wrapName(ClassMappingUtils.getNestedPropertyAliasName(propertyMapping, nestedPropertyMapping));
    }

    public static Map<String, String> getSelectColumns(ClassMapping<?> classMapping) {
        HashMap<String, String> columns = new HashMap<String, String>();
        for (PropertyMapping propertyMapping : classMapping.getPropertyMappings()) {
            if (LangUtils.isEmpty((Collection)propertyMapping.getPropertyMappings())) {
                columns.put(propertyMapping.getRepositoryFieldName(), propertyMapping.getPropertyName());
                continue;
            }
            for (PropertyMapping pm : propertyMapping.getPropertyMappings()) {
                columns.put(pm.getRepositoryFieldName(), propertyMapping.getPropertyName() + "." + pm.getPropertyName());
            }
        }
        return columns;
    }

    public static Tuple2<String, String> getColumnAndPropertyName(String name, ClassMapping<?> classMapping) {
        PropertyMapping propertyMapping = null;
        if (classMapping != null && LangUtils.isNotEmpty((String)name)) {
            if (name.contains(".")) {
                String[] names = name.split("\\.");
                propertyMapping = ClassMappingUtils.getNestedMapping(names, classMapping);
            } else {
                propertyMapping = ClassMappingUtils.getSimpleMapping(name, classMapping);
            }
        }
        if (propertyMapping != null) {
            return Tuples.of((Object)propertyMapping.getRepositoryFieldName(), (Object)propertyMapping.getPropertyName());
        }
        return Tuples.of((Object)name, (Object)"");
    }

    public static String getColumnName(String name, ClassMapping<?> classMapping) {
        if (classMapping != null && LangUtils.isNotEmpty((String)name)) {
            if (name.contains(".")) {
                String[] names = name.split("\\.");
                return ClassMappingUtils.getNestedColumnName(names, classMapping);
            }
            return ClassMappingUtils.getSimpleColumnName(name, classMapping);
        }
        return name;
    }

    private static PropertyMapping getSimpleMapping(String name, ClassMapping<?> classMapping) {
        PropertyMapping pm = classMapping.getPropertyMapping(name);
        return pm;
    }

    private static String getSimpleColumnName(String name, ClassMapping<?> classMapping) {
        PropertyMapping pm = ClassMappingUtils.getSimpleMapping(name, classMapping);
        if (pm != null) {
            return pm.getRepositoryFieldName();
        }
        return name;
    }

    private static PropertyMapping getNestedMapping(String[] names, ClassMapping<?> classMapping) {
        PropertyMapping pm = null;
        for (String n : names) {
            pm = pm == null ? classMapping.getPropertyMapping(n) : pm.getPropertyMapping(n);
        }
        return pm;
    }

    private static String getNestedColumnName(String[] names, ClassMapping<?> classMapping) {
        PropertyMapping pm = ClassMappingUtils.getNestedMapping(names, classMapping);
        if (pm != null) {
            return pm.getRepositoryFieldName();
        }
        return null;
    }

    public static String[] getColumnNames(ClassMapping<?> classMapping, String ... names) {
        if (classMapping != null) {
            ArrayList<String> newNames = new ArrayList<String>();
            for (String name : names) {
                newNames.add(ClassMappingUtils.getColumnName(name, classMapping));
            }
            return newNames.toArray(new String[0]);
        }
        return names;
    }

    public static String[] getColumnNames(ClassMapping<?> classMapping, Collection<String> names) {
        if (names == null) {
            names = new ArrayList<String>();
        }
        return ClassMappingUtils.getColumnNames(classMapping, names.toArray(new String[0]));
    }
}

